/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.items;

import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBattery
extends Item {
    public ItemBattery() {
        super(new Item.Properties().m_41487_(1).m_41503_(500));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.battery_energy", (Object[])new Object[]{Component.m_237113_((String)String.valueOf(this.getEnergy(stack))).m_130940_(ChatFormatting.DARK_GRAY)}).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.battery").m_130940_(ChatFormatting.GRAY));
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        IEnergyStorage storage;
        if (context.m_43725_().m_8055_(context.m_8083_()).m_60734_().equals(ModBlocks.GENERATOR.get()) && (storage = EnergyUtils.getEnergyStorage((LevelAccessor)context.m_43725_(), context.m_8083_(), context.m_43719_())) != null) {
            ItemStack stack = context.m_43723_().m_21120_(context.m_43724_());
            int energyToFill = stack.m_41773_();
            int amount = storage.extractEnergy(energyToFill, false);
            stack.m_41721_(energyToFill - amount);
            context.m_43723_().m_21008_(context.m_43724_(), stack);
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    public int getEnergy(ItemStack stack) {
        return this.getMaxDamage(stack) - this.getDamage(stack);
    }

    public void setEnergy(ItemStack stack, int energy) {
        this.setDamage(stack, Math.max(this.getMaxDamage(stack) - energy, 0));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ENERGY) {
                    return LazyOptional.of(() -> new BatteryEnergyStorage(stack)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public class BatteryEnergyStorage
    implements IEnergyStorage {
        private ItemStack stack;

        public BatteryEnergyStorage(ItemStack stack) {
            this.stack = stack;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int amount = Math.min(maxReceive, ItemBattery.this.getMaxDamage(this.stack) - ItemBattery.this.getEnergy(this.stack));
            if (!simulate) {
                ItemBattery.this.setEnergy(this.stack, ItemBattery.this.getEnergy(this.stack) + amount);
            }
            return amount;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return ItemBattery.this.getEnergy(this.stack);
        }

        public int getMaxEnergyStored() {
            return ItemBattery.this.getMaxDamage(this.stack);
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

