/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.BlockFluidExtractor;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.fluid.FluidUtils;
import de.maxhenkel.tools.BlockPosList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityFluidExtractor
extends TileEntityBase
implements ITickableBlockEntity {
    private IFluidHandler extractHandler;
    private final int drainSpeed;
    private ItemStack filter;

    public TileEntityFluidExtractor(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.FLUID_EXTRACTOR_TILE_ENTITY_TYPE.get(), pos, state);
        this.drainSpeed = (Integer)Main.SERVER_CONFIG.fluidExtractorDrainSpeed.get();
        this.filter = null;
    }

    @Nullable
    public Fluid getFilterFluid() {
        if (this.filter == null) {
            return null;
        }
        FluidStack stack = FluidUtil.getFluidContained((ItemStack)this.filter).orElse(null);
        if (stack == null || stack.getAmount() <= 0) {
            return null;
        }
        return stack.getFluid();
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateExtractHandler();
        if (this.extractHandler == null) {
            return;
        }
        FluidStack drainSimulated = this.getFilterFluid() == null ? this.extractHandler.drain(this.drainSpeed, IFluidHandler.FluidAction.SIMULATE) : this.extractHandler.drain(new FluidStack(this.getFilterFluid(), this.drainSpeed), IFluidHandler.FluidAction.SIMULATE);
        if (drainSimulated.getAmount() <= 0) {
            return;
        }
        LinkedList<IFluidHandler> handlers = new LinkedList<IFluidHandler>();
        this.getConnectedHandlers(handlers, new BlockPosList(), this.f_58858_);
        LinkedList<IFluidHandler> fillHandlers = new LinkedList<IFluidHandler>();
        for (IFluidHandler handler : handlers) {
            int amount = handler.fill(drainSimulated, IFluidHandler.FluidAction.SIMULATE);
            if (amount <= 0) continue;
            fillHandlers.add(handler);
        }
        if (fillHandlers.isEmpty()) {
            return;
        }
        for (IFluidHandler handler : fillHandlers) {
            if (this.getFilterFluid() == null) {
                FluidUtils.tryFluidTransfer(handler, this.extractHandler, this.drainSpeed, true);
                continue;
            }
            FluidUtils.tryFluidTransfer(handler, this.extractHandler, this.drainSpeed, true, this.getFilterFluid());
        }
    }

    public void updateExtractHandler() {
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        if (!state.m_60734_().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
            this.extractHandler = null;
            return;
        }
        Direction side = (Direction)state.m_61143_((Property)BlockFluidExtractor.FACING);
        this.extractHandler = FluidUtils.getFluidHandlerOffset((LevelAccessor)this.f_58857_, this.f_58858_, side);
    }

    public void getConnectedHandlers(List<IFluidHandler> handlers, BlockPosList positions, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockPos p = pos.m_121945_(side);
            if (positions.contains(p)) continue;
            BlockState state = this.f_58857_.m_8055_(p);
            if (state.m_60734_().equals(ModBlocks.FLUID_PIPE.get()) || state.m_60734_().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
                positions.add(p);
                this.getConnectedHandlers(handlers, positions, p);
                continue;
            }
            IFluidHandler handler = FluidUtils.getFluidHandlerOffset((LevelAccessor)this.f_58857_, pos, side);
            if (handler == null || handler.equals(this.extractHandler)) continue;
            handlers.add(handler);
        }
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.filter != null) {
            CompoundTag tag = new CompoundTag();
            this.filter.m_41739_(tag);
            compound.m_128365_("filter", (Tag)tag);
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("filter")) {
            CompoundTag tag = compound.m_128469_("filter");
            this.filter = ItemStack.m_41712_((CompoundTag)tag);
        } else {
            this.filter = null;
        }
        super.m_142466_(compound);
    }

    @Override
    public Component getTranslatedName() {
        return Component.m_237115_((String)"block.car.fluid_extractor");
    }

    public ItemStack getFilter() {
        if (this.filter == null) {
            return null;
        }
        return this.filter.m_41777_();
    }

    public void setFilter(ItemStack filter) {
        if (filter == null) {
            this.filter = null;
            this.m_6596_();
            this.synchronize();
            return;
        }
        this.filter = filter.m_41777_();
        this.m_6596_();
        this.synchronize();
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

