/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks.tileentity;

import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityBase;
import de.maxhenkel.car.corelib.blockentity.ITickableBlockEntity;
import de.maxhenkel.car.corelib.energy.EnergyUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityDynamo
extends TileEntityBase
implements IEnergyStorage,
ITickableBlockEntity {
    private int storedEnergy;
    public final int maxStorage;
    public final int generation;

    public TileEntityDynamo(BlockPos pos, BlockState state) {
        super((BlockEntityType)Main.DYNAMO_TILE_ENTITY_TYPE.get(), pos, state);
        this.maxStorage = (Integer)Main.SERVER_CONFIG.dynamoEnergyStorage.get();
        this.generation = (Integer)Main.SERVER_CONFIG.dynamoEnergyGeneration.get();
        this.storedEnergy = 0;
    }

    @Override
    public void tick() {
        for (Direction side : Direction.values()) {
            IEnergyStorage storage = EnergyUtils.getEnergyStorageOffset((LevelAccessor)this.f_58857_, this.f_58858_, side);
            if (storage == null) continue;
            EnergyUtils.pushEnergy(this, storage, this.storedEnergy);
        }
    }

    public void addEnergy(int energy) {
        this.storedEnergy += energy;
        if (this.storedEnergy > this.maxStorage) {
            this.storedEnergy = this.maxStorage;
        }
        this.m_6596_();
    }

    @Override
    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("stored_energy", this.storedEnergy);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        this.storedEnergy = compound.m_128451_("stored_energy");
        super.m_142466_(compound);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int i = Math.min(maxExtract, this.storedEnergy);
        if (!simulate) {
            this.storedEnergy -= i;
            this.m_6596_();
        }
        return i;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getMaxEnergyStored() {
        return this.maxStorage;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    public Component getTranslatedName() {
        return Component.m_237115_((String)"block.car.dynamo");
    }

    @Override
    public ContainerData getFields() {
        return new SimpleContainerData(0);
    }
}

