/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.vicmatskiv.pointblank.feature.ConditionContext;
import com.vicmatskiv.pointblank.feature.ConditionalFeature;
import com.vicmatskiv.pointblank.feature.FeatureBuilder;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.feature.Features;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.util.Conditions;
import com.vicmatskiv.pointblank.util.JsonUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;

public class DurabilityFeature
extends ConditionalFeature {
    private static final double MIN_DEGRADATION_RATE = 1.0E-7;
    private static final double MAX_DEGRADATION_RATE = 1.0;
    private static final int MIN_DURABILITY = 1;
    private static final int MAX_DURABILITY = Integer.MAX_VALUE;
    private double degradationMultiplier;
    private int durability;

    private DurabilityFeature(FeatureProvider owner, Predicate<ConditionContext> predicate, int durability, double hitScanDamageModifier) {
        super(owner, predicate);
        this.durability = durability;
        this.degradationMultiplier = hitScanDamageModifier;
    }

    public MutableComponent getDescription() {
        if (this.degradationMultiplier < 1.0) {
            return Component.m_237115_((String)"description.pointblank.reducesDegradation").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", 100.0 * (1.0 - this.degradationMultiplier))));
        }
        return Component.m_237115_((String)"description.pointblank.increasesDegradation").m_7220_((Component)Component.m_237113_((String)String.format(" %.0f%%", 100.0 * (this.degradationMultiplier - 1.0))));
    }

    public static void ensureDurability(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return;
        }
        int baseMaxDurability = 0;
        double baseDegradationRate = 1.0;
        int combinedMaxDurability = baseMaxDurability;
        double combinedDegradationRate = baseDegradationRate;
        List<Features.EnabledFeature> enabledDurabilityFeatures = Features.getEnabledFeatures(itemStack, DurabilityFeature.class);
        for (Features.EnabledFeature enabledFeature : enabledDurabilityFeatures) {
            DurabilityFeature durabilityFeature = (DurabilityFeature)enabledFeature.feature();
            combinedMaxDurability += durabilityFeature.durability;
            combinedDegradationRate *= durabilityFeature.degradationMultiplier;
        }
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            int currentMaxDurability = tag.m_128451_("mdu");
            if (currentMaxDurability == 0) {
                currentMaxDurability = combinedMaxDurability;
                tag.m_128405_("mdu", currentMaxDurability);
            }
            if (!tag.m_128441_("du")) {
                tag.m_128405_("du", combinedMaxDurability);
            }
            int currentDurability = tag.m_128451_("du");
            if (currentMaxDurability != combinedMaxDurability) {
                tag.m_128405_("mdu", Mth.m_14045_((int)combinedMaxDurability, (int)1, (int)Integer.MAX_VALUE));
                int durabilityDiff = currentMaxDurability - combinedMaxDurability;
                float diffRate = (float)durabilityDiff / (float)currentMaxDurability;
                currentDurability = (int)((float)currentDurability * Mth.m_14036_((float)diffRate, (float)0.0f, (float)2.1474836E9f));
                tag.m_128405_("du", currentDurability);
            }
            tag.m_128347_("dr", combinedDegradationRate);
        }
    }

    public static void degradeDurability(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41783_();
        if (tag != null) {
            int currentMaxDurability = tag.m_128451_("mdu");
            int durability = tag.m_128451_("du");
            double degradationRate = tag.m_128459_("dr");
            durability = (int)Mth.m_14008_((double)((double)durability * (1.0 - degradationRate)), (double)0.0, (double)currentMaxDurability);
            tag.m_128405_("du", durability);
        }
    }

    public static float getRelativeDurability(ItemStack itemStack) {
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return 0.0f;
        }
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return 0.0f;
        }
        int currentMaxDurability = tag.m_128451_("mdu");
        if (currentMaxDurability == 0) {
            return 0.0f;
        }
        float durability = tag.m_128451_("du");
        return durability / (float)currentMaxDurability;
    }

    public static class Builder
    implements FeatureBuilder<Builder, DurabilityFeature> {
        private Predicate<ConditionContext> condition = ctx -> true;
        private double degradationMultiplier;
        private int durability;

        public Builder withCondition(Predicate<ConditionContext> condition) {
            this.condition = condition;
            return this;
        }

        public Builder withDurability(int durability) {
            this.durability = durability;
            return this;
        }

        public Builder withDegradationMultiplier(double degradationMultiplier) {
            this.degradationMultiplier = degradationMultiplier;
            return this;
        }

        @Override
        public Builder withJsonObject(JsonObject obj) {
            if (obj.has("condition")) {
                this.withCondition(Conditions.fromJson((JsonElement)obj.getAsJsonObject("condition")));
            }
            this.withDegradationMultiplier(JsonUtil.getJsonFloat(obj, "degradationMultiplier"));
            return this;
        }

        @Override
        public DurabilityFeature build(FeatureProvider featureProvider) {
            return new DurabilityFeature(featureProvider, this.condition, Mth.m_14045_((int)this.durability, (int)1, (int)Integer.MAX_VALUE), Mth.m_14008_((double)this.degradationMultiplier, (double)1.0E-7, (double)1.0));
        }
    }
}

