/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.explosion;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.client.effect.EffectBuilder;
import com.vicmatskiv.pointblank.explosion.ExplosionEvent;
import com.vicmatskiv.pointblank.item.ExplosionDescriptor;
import com.vicmatskiv.pointblank.item.ExplosionProvider;
import com.vicmatskiv.pointblank.registry.SoundRegistry;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.SimpleHitResult;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EntityBasedExplosionDamageCalculator;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import software.bernie.geckolib.util.ClientUtils;

public class CustomExplosion
extends Explosion {
    private static final ExplosionDamageCalculator EXPLOSION_DAMAGE_CALCULATOR = new ExplosionDamageCalculator();
    private static final float DEFAULT_SOUND_VOLUME = 4.0f;
    private Item item;
    private Level level;
    private float radius;
    private double x;
    private double y;
    private double z;
    private boolean fire;
    private final ObjectArrayList<BlockPos> toBlow = new ObjectArrayList();
    private Explosion.BlockInteraction blockInteraction;
    private Random random;
    private Entity source;
    private ExplosionDamageCalculator damageCalculator;
    private final Map<Player, Vec3> hitPlayers = Maps.newHashMap();

    public CustomExplosion(Level level, Item item, Entity entity, DamageSource damageSource, ExplosionDamageCalculator calc, double posX, double posY, double posZ, float power, boolean fire, Explosion.BlockInteraction blockInteraction) {
        super(level, entity, damageSource, calc, posX, posY, posZ, power, fire, blockInteraction);
        this.level = level;
        this.item = item;
        this.source = entity;
        this.x = posX;
        this.y = posY;
        this.z = posZ;
        this.radius = power;
        this.fire = fire;
        this.blockInteraction = blockInteraction;
        this.random = new Random();
        this.damageCalculator = calc == null ? this.m_46062_(entity) : calc;
    }

    public CustomExplosion(Level level, Item gunItem, Entity entity, double x, double y, double z, float power, List<BlockPos> toBlow) {
        super(level, entity, x, y, z, power, toBlow);
        this.level = level;
        this.item = gunItem;
        this.source = entity;
        this.x = x;
        this.y = y;
        this.z = z;
        this.radius = power;
        this.toBlow.addAll(toBlow);
    }

    private ExplosionDamageCalculator m_46062_(@Nullable Entity entity) {
        return entity == null ? EXPLOSION_DAMAGE_CALCULATOR : new EntityBasedExplosionDamageCalculator(entity);
    }

    public Item getItem() {
        return this.item;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void finalizeClientExplosion() {
        Item item = this.item;
        if (item instanceof ExplosionProvider) {
            ExplosionProvider explosionProvider = (ExplosionProvider)item;
            ExplosionDescriptor explosionDescriptor = explosionProvider.getExplosion();
            MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent(new Vec3(this.x, this.y, this.z), explosionDescriptor));
            SoundEvent soundEvent = null;
            float soundVolume = 4.0f;
            if (explosionDescriptor != null) {
                if (explosionDescriptor.soundName() != null) {
                    soundEvent = SoundRegistry.getSoundEvent(explosionDescriptor.soundName());
                }
                soundVolume = explosionDescriptor.soundVolume();
                this.applyExplosionEffects(explosionDescriptor);
            }
            if (soundEvent == null) {
                soundEvent = SoundEvents.f_11913_;
            }
            if (!MiscUtil.isNearlyZero(soundVolume)) {
                this.playSound(soundEvent, soundVolume);
            }
        }
        this.m_46075_(false);
    }

    private void playSound(SoundEvent soundEvent, float volume) {
        this.level.m_7785_(this.x, this.y, this.z, soundEvent, SoundSource.BLOCKS, volume, (1.0f + (this.level.f_46441_.m_188501_() - this.level.f_46441_.m_188501_()) * 0.2f) * 0.7f, false);
    }

    private void applyExplosionEffects(ExplosionDescriptor explosionDescriptor) {
        List<Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>>> effects = explosionDescriptor.effects();
        for (Supplier<EffectBuilder<EffectBuilder<?, ?>, ?>> effectBuilderSupplier : effects) {
            EffectBuilder<EffectBuilder<?, ?>, ?> effectBuilder = effectBuilderSupplier.get();
            EffectBuilder.Context context = new EffectBuilder.Context().withHitResult(new SimpleHitResult(this.getPosition(), HitResult.Type.BLOCK, Direction.UP, -1));
            Object effect = effectBuilder.build(context);
            effect.launch((Entity)ClientUtils.getClientPlayer());
        }
    }

    public void m_46075_(boolean ignored) {
        boolean flag = this.m_254884_();
        if (flag) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            boolean flag1 = this.m_252906_() instanceof Player;
            Util.m_214673_(this.toBlow, (RandomSource)this.level.f_46441_);
            for (BlockPos blockpos : this.toBlow) {
                Level $$9;
                BlockState blockstate = this.level.m_8055_(blockpos);
                if (blockstate.m_60795_()) continue;
                BlockPos blockpos1 = blockpos.m_7949_();
                this.level.m_46473_().m_6180_("explosion_blocks");
                if (blockstate.canDropFromExplosion((BlockGetter)this.level, blockpos, (Explosion)this) && ($$9 = this.level) instanceof ServerLevel) {
                    ServerLevel serverlevel = (ServerLevel)$$9;
                    BlockEntity blockentity = blockstate.m_155947_() ? this.level.m_7702_(blockpos) : null;
                    LootParams.Builder lootparams$builder = new LootParams.Builder(serverlevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_287289_(LootContextParams.f_81462_, (Object)blockentity).m_287289_(LootContextParams.f_81455_, (Object)this.source);
                    if (this.blockInteraction == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
                        lootparams$builder.m_287286_(LootContextParams.f_81464_, (Object)Float.valueOf(this.radius));
                    }
                    blockstate.m_222967_(serverlevel, blockpos, ItemStack.f_41583_, flag1);
                    blockstate.m_287290_(lootparams$builder).forEach(p_46074_ -> CustomExplosion.m_46067_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_46074_, blockpos1));
                }
                blockstate.onBlockExploded(this.level, blockpos, (Explosion)this);
                this.level.m_46473_().m_7238_();
            }
            for (Pair pair : objectarraylist) {
                Block.m_49840_((Level)this.level, (BlockPos)((BlockPos)pair.getSecond()), (ItemStack)((ItemStack)pair.getFirst()));
            }
        }
        if (this.fire) {
            for (BlockPos blockpos2 : this.toBlow) {
                if (this.random.nextInt(3) != 0 || !this.level.m_8055_(blockpos2).m_60795_() || !this.level.m_8055_(blockpos2.m_7495_()).m_60804_((BlockGetter)this.level, blockpos2.m_7495_())) continue;
                this.level.m_46597_(blockpos2, BaseFireBlock.m_49245_((BlockGetter)this.level, (BlockPos)blockpos2));
            }
        }
    }

    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> blockPosToBlow, ItemStack itemStack, BlockPos blockPos) {
        int i = blockPosToBlow.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)blockPosToBlow.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.m_32026_((ItemStack)itemstack, (ItemStack)itemStack)) continue;
            ItemStack itemstack1 = ItemEntity.m_32029_((ItemStack)itemstack, (ItemStack)itemStack, (int)16);
            blockPosToBlow.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!itemStack.m_41619_()) continue;
            return;
        }
        blockPosToBlow.add((Object)Pair.of((Object)itemStack, (Object)blockPos));
    }

    private static Explosion.BlockInteraction getDestroyType(Level level, GameRules.Key<GameRules.BooleanValue> gameRulesKey) {
        return level.m_46469_().m_46207_(gameRulesKey) ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY;
    }

    public static CustomExplosion explode(Level level, Item item, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator calc, double posX, double posY, double posZ, float power, boolean fire, Level.ExplosionInteraction interaction, boolean particlesEnabled) {
        if (!Config.explosionDestroyBlocksEnabled) {
            interaction = Level.ExplosionInteraction.NONE;
        }
        CustomExplosion explosion = new CustomExplosion(level, item, entity, damageSource, calc, posX, posY, posZ, power, fire, switch (interaction) {
            case Level.ExplosionInteraction.NONE -> Explosion.BlockInteraction.KEEP;
            case Level.ExplosionInteraction.BLOCK -> CustomExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254629_);
            case Level.ExplosionInteraction.TNT -> CustomExplosion.getDestroyType(level, (GameRules.Key<GameRules.BooleanValue>)GameRules.f_254705_);
            default -> throw new IncompatibleClassChangeError();
        });
        explosion.m_46061_();
        explosion.m_46075_(false);
        return explosion;
    }

    public void m_46061_() {
        this.level.m_220400_(this.source, GameEvent.f_157812_, new Vec3(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                block2: for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x;
                    double d6 = this.y;
                    double d8 = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.f_46441_.m_188501_() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = BlockPos.m_274561_((double)d4, (double)d6, (double)d8);
                        BlockState blockstate = this.level.m_8055_(blockpos);
                        FluidState fluidstate = this.level.m_6425_(blockpos);
                        if (!this.level.m_46739_(blockpos)) continue block2;
                        Optional optional = this.damageCalculator.m_6617_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, fluidstate);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && this.damageCalculator.m_6714_((Explosion)this, (BlockGetter)this.level, blockpos, blockstate, f)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.toBlow.addAll((Collection)set);
        float adjustedRadius = this.radius * 2.0f;
        int bbXMin = Mth.m_14107_((double)(this.x - (double)adjustedRadius - 1.0));
        int bbXMax = Mth.m_14107_((double)(this.x + (double)adjustedRadius + 1.0));
        int bbYMin = Mth.m_14107_((double)(this.y - (double)adjustedRadius - 1.0));
        int bbYMax = Mth.m_14107_((double)(this.y + (double)adjustedRadius + 1.0));
        int bbZMin = Mth.m_14107_((double)(this.z - (double)adjustedRadius - 1.0));
        int bbZMax = Mth.m_14107_((double)(this.z + (double)adjustedRadius + 1.0));
        List list = this.level.m_45933_(this.source, new AABB((double)bbXMin, (double)bbYMin, (double)bbZMin, (double)bbXMax, (double)bbYMax, (double)bbZMax));
        ForgeEventFactory.onExplosionDetonate((Level)this.level, (Explosion)this, (List)list, (double)adjustedRadius);
        Vec3 thisPos = new Vec3(this.x, this.y, this.z);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            Player player;
            double d11;
            double zOffset;
            double yOffset;
            double xOffset;
            double adjustedDistanceToEntity;
            double normalizedDistanceToEntity;
            Entity entity = (Entity)list.get(k2);
            if (entity.m_6128_() || MiscUtil.isProtected(entity) || !((normalizedDistanceToEntity = Math.sqrt(entity.m_20238_(thisPos)) / (double)adjustedRadius) <= 1.0) || (adjustedDistanceToEntity = Math.sqrt((xOffset = entity.m_20185_() - this.x) * xOffset + (yOffset = (entity instanceof PrimedTnt ? entity.m_20186_() : entity.m_20188_()) - this.y) * yOffset + (zOffset = entity.m_20189_() - this.z) * zOffset)) == 0.0) continue;
            xOffset /= adjustedDistanceToEntity;
            yOffset /= adjustedDistanceToEntity;
            zOffset /= adjustedDistanceToEntity;
            double seenPercent = CustomExplosion.m_46064_((Vec3)thisPos, (Entity)entity);
            double damage = (1.0 - normalizedDistanceToEntity) * seenPercent;
            entity.m_6469_(this.m_46077_(), (float)((int)((damage * damage + damage) / 2.0 * 7.5 * (double)adjustedRadius + 1.0)));
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                d11 = ProtectionEnchantment.m_45135_((LivingEntity)livingentity, (double)damage);
            } else {
                d11 = damage;
            }
            Vec3 knockbackMovement = new Vec3(xOffset *= d11, yOffset *= d11, zOffset *= d11);
            entity.m_20256_(entity.m_20184_().m_82549_(knockbackMovement));
            if (!(entity instanceof Player) || (player = (Player)entity).m_5833_() || player.m_7500_() && player.m_150110_().f_35935_) continue;
            this.hitPlayers.put(player, knockbackMovement);
        }
    }
}

