/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import cubicoder.well.block.WellBlock;
import cubicoder.well.block.entity.WellBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;

public class WellRenderer
implements BlockEntityRenderer<WellBlockEntity> {
    public WellRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(WellBlockEntity well, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluidStack fluid = well.getTank().getFluid();
        if (!fluid.isEmpty()) {
            int amount = fluid.getAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = well.isUpsideDown();
            Level level = well.m_58904_();
            BlockPos pos = well.m_58899_();
            FluidType fluidType = fluid.getFluid().getFluidType();
            IClientFluidTypeExtensions fluidEx = IClientFluidTypeExtensions.of((FluidState)fluidType.getStateForPlacement((BlockAndTintGetter)level, pos, fluid));
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidEx.getStillTexture(fluid));
            int color = fluidEx.getTintColor(fluidType.getStateForPlacement((BlockAndTintGetter)level, pos, fluid), (BlockAndTintGetter)level, pos);
            float corner = 0.1875f;
            float height = WellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
            float minU = sprite.m_118367_(3.0);
            float maxU = sprite.m_118367_(13.0);
            float minV = sprite.m_118393_(3.0);
            float maxV = sprite.m_118393_(13.0);
            VertexConsumer builder = bufferSource.m_6299_(RenderType.m_110466_());
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            if (upsideDown) {
                builder.m_252986_(matrix, 1.0f - corner, height, corner).m_193479_(color).m_7421_(maxU, minV).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, 1.0f - corner, height, 1.0f - corner).m_193479_(color).m_7421_(maxU, maxV).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, corner, height, 1.0f - corner).m_193479_(color).m_7421_(minU, maxV).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, corner, height, corner).m_193479_(color).m_7421_(minU, minV).m_85969_(packedLight).m_5601_(0.0f, -1.0f, 0.0f).m_5752_();
            } else {
                builder.m_252986_(matrix, corner, height, corner).m_193479_(color).m_7421_(minU, minV).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, corner, height, 1.0f - corner).m_193479_(color).m_7421_(minU, maxV).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, 1.0f - corner, height, 1.0f - corner).m_193479_(color).m_7421_(maxU, maxV).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, 1.0f - corner, height, corner).m_193479_(color).m_7421_(maxU, minV).m_85969_(packedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
    }
}

