/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.block;

import cubicoder.well.block.ModBlocks;
import cubicoder.well.block.entity.WellBlockEntity;
import cubicoder.well.config.WellConfig;
import cubicoder.well.sound.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class WellBlock
extends BaseEntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.m_61465_((String)"upside_down");
    public static final VoxelShape SHAPE_BASE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Block.m_49796_((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.f_82685_);
    public static final VoxelShape SHAPE_BASE_UPSIDE_DOWN = WellBlock.flipShapeUpsideDown(SHAPE_BASE);
    public static final VoxelShape SHAPE_INNER_SUPPORT = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.5, (double)0.0, (double)1.0, (double)8.5, (double)15.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.5, (double)0.0, (double)14.0, (double)8.5, (double)15.0, (double)15.0), Block.m_49796_((double)7.5, (double)7.0, (double)2.0, (double)8.5, (double)8.0, (double)14.0), Block.m_49796_((double)5.0, (double)4.5, (double)4.5, (double)11.0, (double)10.5, (double)11.5)});
    public static final VoxelShape SHAPE_INNER_SUPPORT_Z = WellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT);
    public static final VoxelShape SHAPE_INNER_SUPPORT_UPSIDE_DOWN = WellBlock.flipShapeUpsideDown(SHAPE_INNER_SUPPORT);
    public static final VoxelShape SHAPE_INNER_SUPPORT_UPSIDE_DOWN_Z = WellBlock.flipShapeUpsideDown(SHAPE_INNER_SUPPORT_Z);
    public static final VoxelShape SHAPE_ROOF = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.5, (double)12.5, (double)0.0, (double)10.5, (double)15.707, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.75, (double)10.5, (double)0.0, (double)5.5, (double)13.75, (double)16.0), Block.m_49796_((double)10.5, (double)10.5, (double)0.0, (double)13.25, (double)13.75, (double)16.0), Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)2.75, (double)11.25, (double)16.0), Block.m_49796_((double)13.25, (double)8.0, (double)0.0, (double)16.0, (double)11.25, (double)16.0), SHAPE_INNER_SUPPORT});
    public static final VoxelShape SHAPE_ROOF_Z = WellBlock.flipShapeXZ(SHAPE_ROOF);
    public static final VoxelShape SHAPE_ROOF_UPSIDE_DOWN = WellBlock.flipShapeUpsideDown(SHAPE_ROOF);
    public static final VoxelShape SHAPE_ROOF_UPSIDE_DOWN_Z = WellBlock.flipShapeUpsideDown(SHAPE_ROOF_Z);

    public WellBlock(DyeColor mapColor) {
        this(BlockBehaviour.Properties.m_284310_().m_284268_(mapColor).m_280658_(NoteBlockInstrument.BASEDRUM).m_60913_(1.5f, 6.0f).m_60999_());
    }

    public WellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? new WellBlockEntity(pos, state) : null;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.f_46443_ ? null : WellBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)ModBlocks.WELL_BE.get()), WellBlockEntity::serverTick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS, HALF, UPSIDE_DOWN});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction.Axis axis;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction.Axis axis2 = axis = context.m_43723_().m_6047_() ? context.m_8125_().m_122427_().m_122434_() : context.m_8125_().m_122434_();
        if (pos.m_123342_() < level.m_151558_() - 1 && level.m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false));
        }
        if (pos.m_123342_() > level.m_141937_() + 1 && level.m_8055_(pos.m_7495_()).m_60629_(context)) {
            return (BlockState)((BlockState)this.m_49966_().m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Direction flippedDir2;
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        Direction flippedDir1 = (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? Direction.DOWN : Direction.UP;
        Direction direction2 = flippedDir2 = (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? Direction.UP : Direction.DOWN;
        if ((direction.m_122434_() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == flippedDir1) || neighborState.m_60713_((Block)this) && neighborState.m_61143_(HALF) != half) && (half != DoubleBlockHalf.LOWER || direction != flippedDir2 || state.m_60710_((LevelReader)level, currentPos))) {
            return state;
        }
        return Blocks.f_50016_.m_49966_();
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity be;
        level.m_46597_(pos.m_6630_((Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? -1 : 1), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER));
        if (((Boolean)WellConfig.onlyOnePerChunk.get()).booleanValue() && placer instanceof ServerPlayer && (be = level.m_7702_(pos)) instanceof WellBlockEntity && ((WellBlockEntity)be).nearbyWells > 1) {
            String message = (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? "warn.well.onePerChunkFlipped" : "warn.well.onePerChunk";
            ((ServerPlayer)placer).m_5661_((Component)Component.m_237115_((String)message), true);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return super.m_7898_(state, level, pos);
        }
        BlockState base = level.m_8055_(pos.m_6625_((Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? -1 : 1));
        if (state.m_60734_() != this) {
            return super.m_7898_(state, level, pos);
        }
        return base.m_60713_((Block)this) && base.m_61143_(HALF) == DoubleBlockHalf.LOWER;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos otherPos;
        BlockState otherState;
        if (!level.f_46443_ && state.m_61143_(HALF) == DoubleBlockHalf.UPPER && (otherState = level.m_8055_(otherPos = pos.m_6625_((Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? -1 : 1))).m_60713_((Block)this) && otherState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            if (player.m_7500_()) {
                level.m_46953_(otherPos, false, (Entity)player);
            } else {
                level.m_46953_(otherPos, this.canHarvestBlock(state, (BlockGetter)level, pos, player), (Entity)player);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof WellBlockEntity) {
                ((WellBlockEntity)be).countNearbyWells(e -> --e.nearbyWells);
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return InteractionResult.PASS;
        }
        if (!player.m_21120_(hand).getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent()) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof WellBlockEntity) {
            WellBlockEntity well = (WellBlockEntity)be;
            boolean delayFlag = true;
            boolean fillingItem = FluidUtil.tryFillContainer((ItemStack)player.m_21120_((InteractionHand)hand), (IFluidHandler)well.getTank(), (int)Integer.MAX_VALUE, (Player)player, (boolean)false).success;
            if (fillingItem && well.delayUntilNextBucket > 0) {
                delayFlag = false;
            }
            if (delayFlag && FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hit.m_82434_())) {
                if (((Boolean)WellConfig.playSound.get()).booleanValue() && fillingItem) {
                    level.m_5594_(null, pos.m_7494_(), (SoundEvent)ModSounds.CRANK.get(), SoundSource.BLOCKS, 0.25f, 1.0f);
                    well.delayUntilNextBucket = 32;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        Fluid fluid;
        int baseFluidLight;
        FluidStack fluidStack;
        BlockEntity be;
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (be = level.m_7702_(pos)) instanceof WellBlockEntity && (fluidStack = ((WellBlockEntity)be).getTank().getFluid()) != null && !fluidStack.isEmpty() && (baseFluidLight = (fluid = fluidStack.getFluid()).getFluidType().getLightLevel(fluid.m_76145_(), (BlockAndTintGetter)be.m_58904_(), pos)) > 0) {
            return Mth.m_14045_((int)((int)((double)(baseFluidLight * fluidStack.getAmount() / (Integer)WellConfig.tankCapacity.get()) + 0.5)), (int)1, (int)15);
        }
        return 0;
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        WellBlockEntity well;
        FluidStack fluid;
        BlockEntity be;
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (be = level.m_7702_(pos)) instanceof WellBlockEntity && (fluid = (well = (WellBlockEntity)be).getTank().getFluid()) != null) {
            int amount = well.getTank().getFluidAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = (Boolean)state.m_61143_((Property)UPSIDE_DOWN);
            FluidType fluidType = fluid.getFluid().getFluidType();
            if (!upsideDown) {
                if (entity.m_20186_() < (double)pos.m_123342_() + (double)WellBlock.getFluidRenderHeight(amount, capacity, upsideDown)) {
                    if (fluidType == ForgeMod.LAVA_TYPE.get()) {
                        entity.m_20093_();
                    }
                    if (fluidType.canExtinguish(entity) && !level.f_46443_ && entity.m_6060_()) {
                        entity.m_20095_();
                    }
                }
            } else if (entity.m_20186_() > (double)pos.m_123342_() + (double)WellBlock.getFluidRenderHeight(amount, capacity, upsideDown)) {
                // empty if block
            }
        }
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        WellBlockEntity well;
        FluidStack fluid;
        BlockEntity be;
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER && (be = level.m_7702_(pos)) instanceof WellBlockEntity && (fluid = (well = (WellBlockEntity)be).getTank().getFluid()) != null) {
            int amount = well.getTank().getFluidAmount();
            int capacity = well.getTank().getCapacity();
            boolean upsideDown = (Boolean)state.m_61143_((Property)UPSIDE_DOWN);
            float height = WellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
            FluidState fluidState = fluid.getFluid().m_76145_();
            fluidState.m_230558_(level, pos, random);
            if (fluid.getFluid() == Fluids.f_76195_) {
                double z;
                double y;
                double x;
                if (random.m_188503_(100) == 0) {
                    x = (double)pos.m_123341_() + random.m_188500_();
                    y = (double)pos.m_123342_() + (double)height;
                    z = (double)pos.m_123343_() + random.m_188500_();
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123756_, x, y, z, 0.0, 0.0, 0.0);
                    level.m_7785_(x, y, z, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
                }
                if (random.m_188503_(200) == 0) {
                    x = (double)pos.m_123341_() + 0.5;
                    y = (double)pos.m_123342_() + (double)(height / 2.0f);
                    z = (double)pos.m_123343_() + 0.5;
                    level.m_7785_(x, y, z, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + random.m_188501_() * 0.2f, 0.9f + random.m_188501_() * 0.15f, false);
                }
            }
        }
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, Entity entity) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? this.f_60446_ : Blocks.f_50076_.getSoundType(state, level, pos, entity);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_BASE_UPSIDE_DOWN : SHAPE_BASE;
        }
        if (state.m_61143_(AXIS) == Direction.Axis.X) {
            return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_ROOF_UPSIDE_DOWN : SHAPE_ROOF;
        }
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_ROOF_UPSIDE_DOWN_Z : SHAPE_ROOF_Z;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_BASE_UPSIDE_DOWN : SHAPE_BASE;
        }
        if (state.m_61143_(AXIS) == Direction.Axis.X) {
            return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_INNER_SUPPORT_UPSIDE_DOWN : SHAPE_INNER_SUPPORT;
        }
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_INNER_SUPPORT_UPSIDE_DOWN_Z : SHAPE_INNER_SUPPORT_Z;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            return Shapes.m_83144_();
        }
        if (state.m_61143_(AXIS) == Direction.Axis.X) {
            return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_ROOF_UPSIDE_DOWN : SHAPE_ROOF;
        }
        return (Boolean)state.m_61143_((Property)UPSIDE_DOWN) != false ? SHAPE_ROOF_UPSIDE_DOWN_Z : SHAPE_ROOF_Z;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.m_61143_(AXIS)) {
                    case Z: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    private static VoxelShape flipShapeXZ(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)minZ, (double)minY, (double)minX, (double)maxZ, (double)maxY, (double)maxX));
        });
        return buffer[1];
    }

    private static VoxelShape flipShapeUpsideDown(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.m_83040_()};
        buffer[0].m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = Shapes.m_83110_((VoxelShape)buffer[1], (VoxelShape)Shapes.m_166049_((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ));
        });
        return buffer[1];
    }

    public static float getFluidRenderHeight(int amount, int capacity, boolean upsideDown) {
        float height = (float)amount * 14.0f / (float)(16 * capacity) + 0.125f;
        return upsideDown ? 1.0f - height : height;
    }
}

