/*
 * Decompiled with CFR 0.152.
 */
package me.wesley1808.servercore.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import me.wesley1808.servercore.common.config.Config;
import me.wesley1808.servercore.common.config.data.CommandConfig;
import me.wesley1808.servercore.common.dynamic.DynamicSetting;
import me.wesley1808.servercore.common.services.Formatter;
import me.wesley1808.servercore.common.utils.Mobcaps;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.LocalMobCapCalculator;
import net.minecraft.world.level.NaturalSpawner;

public class MobcapsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        if (Config.get().commands().mobcapsCommandEnabled()) {
            dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"mobcaps").executes(ctx -> MobcapsCommand.mobcaps((CommandSourceStack)ctx.getSource(), ((CommandSourceStack)ctx.getSource()).m_81375_())));
        }
    }

    private static int mobcaps(CommandSourceStack source, ServerPlayer player) {
        CommandConfig config = Config.get().commands();
        source.m_288197_(() -> {
            MutableComponent component = Component.m_237119_();
            Component title = Formatter.parse("<c:#tertiary>Mobcaps <c:#primary>(<c:#tertiary>%s</c>)".formatted(DynamicSetting.MOBCAP_PERCENTAGE.getFormattedValue()));
            Formatter.addLines(component, 16, config.primaryValue(), title);
            NaturalSpawner.SpawnState state = player.m_284548_().m_7726_().m_8485_();
            if (state != null) {
                LocalMobCapCalculator.MobCounts mobCounts = state.f_186542_.f_186498_.getOrDefault(player, Mobcaps.EMPTY_MOBCOUNTS);
                for (MobCategory category : MobCategory.values()) {
                    if (category == MobCategory.MISC) continue;
                    component.m_7220_(Formatter.parse("\n<dark_gray>\u00bb <c:#primary>%s:</c> <c:#secondary>%d</c> / <c:#secondary>%d".formatted(category.m_21607_(), mobCounts.f_186515_.getOrDefault((Object)category, 0), category.m_21608_())));
                }
            }
            return component;
        }, false);
        return 1;
    }
}

