/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.io.single;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.minecraft.server.MinecraftServer;
import xaero.pac.common.server.io.FileIOHelper;
import xaero.pac.common.server.io.FilePathConfig;
import xaero.pac.common.server.io.IOThreadWorker;
import xaero.pac.common.server.io.ObjectManagerIO;
import xaero.pac.common.server.io.ObjectManagerIOObject;
import xaero.pac.common.server.io.serialization.SerializationHandler;
import xaero.pac.common.server.io.serialization.SerializedDataFileIO;
import xaero.pac.common.server.io.single.ObjectHolderIOHolder;

public class ObjectHolderIO<S, T extends ObjectManagerIOObject, M extends ObjectHolderIOHolder<T, M>>
extends ObjectManagerIO<S, Object, T, M> {
    private final Path filePath;

    protected ObjectHolderIO(Path filePath, SerializationHandler<S, Object, T, M> serializationHandler, SerializedDataFileIO<S, Object> serializedDataFileIO, IOThreadWorker ioThreadWorker, MinecraftServer server, String fileExtension, M manager, FileIOHelper fileIOHelper) {
        super(serializationHandler, serializedDataFileIO, ioThreadWorker, server, fileExtension, manager, fileIOHelper);
        this.filePath = filePath;
    }

    @Override
    public void load() {
        if (!Files.exists(this.filePath, new LinkOption[0])) {
            return;
        }
        Object object = this.loadFile(this.filePath, null, true);
        if (object != null) {
            ((ObjectHolderIOHolder)this.manager).setObject(object);
        }
    }

    @Override
    protected Stream<FilePathConfig> getObjectFolderPaths() {
        throw new IllegalArgumentException("this shouldn't be used!");
    }

    @Override
    protected void onObjectLoad(T loadedObject) {
        throw new IllegalArgumentException("this shouldn't be used!");
    }

    @Override
    protected Object getObjectId(String fileNameNoExtension, Path file, FilePathConfig filePathConfig) {
        return null;
    }

    @Override
    protected Path getFilePath(T object, String fileName) {
        if (fileName != null) {
            throw new IllegalArgumentException("fileName isn't null but that's pointless!");
        }
        return this.filePath;
    }

    public static final class FinalBuilder<S, T extends ObjectManagerIOObject, M extends ObjectHolderIOHolder<T, M>>
    extends Builder<S, T, M, FinalBuilder<S, T, M>> {
        protected ObjectHolderIO<S, T, M> buildInternally() {
            return new ObjectHolderIO(this.filePath, this.serializationHandler, this.serializedDataFileIO, this.ioThreadWorker, this.server, this.fileExtension, (ObjectHolderIOHolder)this.manager, this.fileIOHelper);
        }
    }

    public static abstract class Builder<S, T extends ObjectManagerIOObject, M extends ObjectHolderIOHolder<T, M>, B extends Builder<S, T, M, B>>
    extends ObjectManagerIO.Builder<S, Object, T, M, B> {
        protected Path filePath;

        @Override
        public B setDefault() {
            this.setFilePath(null);
            return (B)((Builder)super.setDefault());
        }

        public B setFilePath(Path filePath) {
            this.filePath = filePath;
            if (filePath == null) {
                this.setFileExtension(null);
            } else {
                String fileName = filePath.getFileName().toString();
                this.setFileExtension(fileName.substring(fileName.lastIndexOf(".")));
            }
            return (B)((Builder)this.self);
        }

        public ObjectHolderIO<S, T, M> build() {
            if (this.filePath == null) {
                throw new IllegalStateException();
            }
            if (!this.filePath.getFileName().toString().endsWith(this.fileExtension)) {
                throw new IllegalStateException();
            }
            return (ObjectHolderIO)super.build();
        }
    }
}

