/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.network.c2s;

import forge.net.mca.cobalt.network.Message;
import forge.net.mca.server.world.data.Building;
import forge.net.mca.server.world.data.Village;
import forge.net.mca.server.world.data.VillageManager;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class ReportBuildingMessage
implements Message {
    private static final long serialVersionUID = 3510050513221709603L;
    private final Action action;
    private final String data;

    public ReportBuildingMessage(Action action, String data) {
        this.action = action;
        this.data = data;
    }

    public ReportBuildingMessage(Action action) {
        this(action, null);
    }

    @Override
    public void receive(ServerPlayer player) {
        VillageManager villages = VillageManager.get(player.m_284548_());
        switch (this.action) {
            case ADD: 
            case ADD_ROOM: {
                Building.validationResult result = villages.processBuilding(player.m_20183_(), true, this.action == Action.ADD_ROOM);
                player.m_5661_((Component)Component.m_237115_((String)("blueprint.scan." + result.name().toLowerCase(Locale.ENGLISH))), true);
                break;
            }
            case AUTO_SCAN: {
                villages.findNearestVillage((Entity)player).ifPresent(Village::toggleAutoScan);
                break;
            }
            case FULL_SCAN: {
                villages.findNearestVillage((Entity)player).ifPresent(buildings -> buildings.getBuildings().values().stream().toList().forEach(b -> villages.processBuilding(b.getCenter(), true, b.isStrictScan())));
                break;
            }
            case FORCE_TYPE: 
            case REMOVE: {
                Optional<Village> village = villages.findNearestVillage((Entity)player);
                Optional building = village.flatMap(v -> v.getBuildings().values().stream().filter(b -> b.containsPos((Vec3i)player.m_20183_())).filter(b -> this.action != Action.FORCE_TYPE || !b.getBuildingType().grouped()).findAny());
                building.ifPresentOrElse(b -> {
                    if (this.action == Action.FORCE_TYPE) {
                        if (b.getType().equals(this.data)) {
                            b.setTypeForced(false);
                            b.determineType();
                        } else {
                            b.setTypeForced(true);
                            b.setType(this.data);
                        }
                    } else {
                        ((Village)village.get()).removeBuilding(b.getId());
                    }
                }, () -> player.m_5661_((Component)Component.m_237115_((String)"blueprint.noBuilding"), true));
            }
        }
    }

    public static enum Action {
        AUTO_SCAN,
        ADD_ROOM,
        ADD,
        REMOVE,
        FORCE_TYPE,
        FULL_SCAN;

    }
}

