/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.save;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.geheimagentnr1.minecraft_forge_api.events.ForgeEventHandlerInterface;
import de.geheimagentnr1.world_pre_generator.elements.workers.PregenWorker;
import de.geheimagentnr1.world_pre_generator.helpers.JsonHelper;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class PregenerationWorldPersistencer
implements ForgeEventHandlerInterface {
    private static final Logger log = LogManager.getLogger(PregenerationWorldPersistencer.class);
    @NotNull
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    private static final LevelResource WORLD_PRE_GENERATOR_RESOURCE = new LevelResource("world_pre_generator.dat");
    @NotNull
    private static final String queueName = "queue";
    @NotNull
    private final PregenWorker pregenWorker;

    @NotNull
    private String getFilePath() {
        return ServerLifecycleHooks.getCurrentServer().m_129843_(WORLD_PRE_GENERATOR_RESOURCE).toString();
    }

    private void load() {
        try (FileReader reader = new FileReader(this.getFilePath());){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (JsonHelper.isJsonObject(json, queueName)) {
                this.pregenWorker.clearUp();
                this.pregenWorker.getQueue().read(json.getAsJsonObject(queueName));
            }
        }
        catch (FileNotFoundException ignored) {
            log.debug("File {} not found", (Object)this.getFilePath());
        }
        catch (JsonParseException | IOException exception) {
            log.error("{} could not be readed", (Object)this.getFilePath(), (Object)exception);
        }
    }

    private void save() {
        JsonObject json = new JsonObject();
        json.add(queueName, (JsonElement)this.pregenWorker.getQueue().write());
        try (FileWriter writer = new FileWriter(this.getFilePath());){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (JsonIOException | IOException exception) {
            log.error("{} could not be written", (Object)this.getFilePath(), (Object)exception);
        }
    }

    @SubscribeEvent
    public void handleServerStartingEvent(@NotNull ServerStartingEvent event) {
        this.pregenWorker.setServer(event.getServer());
        this.load();
    }

    @SubscribeEvent
    public void handleServerStoppedEvent(@NotNull ServerStoppedEvent event) {
        this.save();
        this.pregenWorker.clearUp();
    }

    public PregenerationWorldPersistencer(@NotNull PregenWorker pregenWorker) {
        if (pregenWorker == null) {
            throw new NullPointerException("pregenWorker is marked non-null but is null");
        }
        this.pregenWorker = pregenWorker;
    }
}

