/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.QueryTimeout;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TotalHits;
import guideme.internal.shaded.lucene.search.knn.KnnCollectorManager;
import java.io.IOException;

public class TimeLimitingKnnCollectorManager
implements KnnCollectorManager {
    private final KnnCollectorManager delegate;
    private final QueryTimeout queryTimeout;

    public TimeLimitingKnnCollectorManager(KnnCollectorManager delegate, QueryTimeout timeout) {
        this.delegate = delegate;
        this.queryTimeout = timeout;
    }

    public QueryTimeout getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public KnnCollector newCollector(int visitedLimit, LeafReaderContext context) throws IOException {
        KnnCollector collector = this.delegate.newCollector(visitedLimit, context);
        if (this.queryTimeout == null) {
            return collector;
        }
        return new TimeLimitingKnnCollector(collector);
    }

    class TimeLimitingKnnCollector
    implements KnnCollector {
        private final KnnCollector collector;

        TimeLimitingKnnCollector(KnnCollector collector) {
            this.collector = collector;
        }

        @Override
        public boolean earlyTerminated() {
            return TimeLimitingKnnCollectorManager.this.queryTimeout.shouldExit() || this.collector.earlyTerminated();
        }

        @Override
        public void incVisitedCount(int count) {
            this.collector.incVisitedCount(count);
        }

        @Override
        public long visitedCount() {
            return this.collector.visitedCount();
        }

        @Override
        public long visitLimit() {
            return this.collector.visitLimit();
        }

        @Override
        public int k() {
            return this.collector.k();
        }

        @Override
        public boolean collect(int docId, float similarity) {
            return this.collector.collect(docId, similarity);
        }

        @Override
        public float minCompetitiveSimilarity() {
            return this.collector.minCompetitiveSimilarity();
        }

        @Override
        public TopDocs topDocs() {
            TopDocs docs = this.collector.topDocs();
            TotalHits.Relation relation = TimeLimitingKnnCollectorManager.this.queryTimeout.shouldExit() ? TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO : docs.totalHits.relation;
            return new TopDocs(new TotalHits(docs.totalHits.value, relation), docs.scoreDocs);
        }
    }
}

