/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.function.valuesource;

import guideme.internal.shaded.lucene.index.DocValues;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.SortedSetDocValues;
import guideme.internal.shaded.lucene.queries.function.FunctionValues;
import guideme.internal.shaded.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import guideme.internal.shaded.lucene.queries.function.valuesource.FieldCacheSource;
import guideme.internal.shaded.lucene.search.SortField;
import guideme.internal.shaded.lucene.search.SortedSetSelector;
import guideme.internal.shaded.lucene.search.SortedSetSortField;
import java.io.IOException;
import java.util.Map;

public class SortedSetFieldSource
extends FieldCacheSource {
    protected final SortedSetSelector.Type selector;

    public SortedSetFieldSource(String field) {
        this(field, SortedSetSelector.Type.MIN);
    }

    public SortedSetFieldSource(String field, SortedSetSelector.Type selector) {
        super(field);
        this.selector = selector;
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedSetSortField(this.field, reverse, this.selector);
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        SortedSetDocValues sortedSet = DocValues.getSortedSet(readerContext.reader(), this.field);
        SortedDocValues view = SortedSetSelector.wrap(sortedSet, this.selector);
        return new DocTermsIndexDocValues(this, view){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc) throws IOException {
                return this.strVal(doc);
            }
        };
    }

    @Override
    public String description() {
        return "sortedset(" + this.field + ",selector=" + this.selector + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.selector == null ? 0 : this.selector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SortedSetFieldSource other = (SortedSetFieldSource)obj;
        return this.selector == other.selector;
    }
}

