/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.Document;
import guideme.internal.shaded.lucene.document.FieldType;
import guideme.internal.shaded.lucene.document.StoredField;
import guideme.internal.shaded.lucene.document.TextField;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.StoredFieldVisitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class DocumentStoredFieldVisitor
extends StoredFieldVisitor {
    private final Document doc = new Document();
    private final Set<String> fieldsToAdd;

    public DocumentStoredFieldVisitor(Set<String> fieldsToAdd) {
        this.fieldsToAdd = fieldsToAdd;
    }

    public DocumentStoredFieldVisitor(String ... fields) {
        this.fieldsToAdd = new HashSet<String>(Arrays.asList(fields));
    }

    public DocumentStoredFieldVisitor() {
        this.fieldsToAdd = null;
    }

    @Override
    public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
        this.doc.add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void stringField(FieldInfo fieldInfo, String value) throws IOException {
        FieldType ft = new FieldType(TextField.TYPE_STORED);
        ft.setStoreTermVectors(fieldInfo.hasVectors());
        ft.setOmitNorms(fieldInfo.omitsNorms());
        ft.setIndexOptions(fieldInfo.getIndexOptions());
        this.doc.add(new StoredField(fieldInfo.name, Objects.requireNonNull(value, "String value should not be null"), ft));
    }

    @Override
    public void intField(FieldInfo fieldInfo, int value) {
        this.doc.add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void longField(FieldInfo fieldInfo, long value) {
        this.doc.add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void floatField(FieldInfo fieldInfo, float value) {
        this.doc.add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public void doubleField(FieldInfo fieldInfo, double value) {
        this.doc.add(new StoredField(fieldInfo.name, value));
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
        return this.fieldsToAdd == null || this.fieldsToAdd.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
    }

    public Document getDocument() {
        return this.doc;
    }
}

