/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import guideme.Guide;
import guideme.GuidePage;
import guideme.PageAnchor;
import guideme.PageCollection;
import guideme.color.ConstantColor;
import guideme.color.SymbolicColor;
import guideme.compiler.AnchorIndexer;
import guideme.compiler.PageCompiler;
import guideme.compiler.ParsedGuidePage;
import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytBlock;
import guideme.document.block.LytDocument;
import guideme.document.block.LytHeading;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowAnchor;
import guideme.document.flow.LytFlowContent;
import guideme.document.flow.LytFlowSpan;
import guideme.internal.GuidebookText;
import guideme.internal.screen.DocumentScreen;
import guideme.internal.screen.GlobalInMemoryHistory;
import guideme.internal.screen.GuideNavBar;
import guideme.internal.screen.GuideNavigation;
import guideme.internal.screen.GuideScreenHistory;
import guideme.internal.screen.NavigationToolbar;
import guideme.layout.LayoutContext;
import guideme.layout.MinecraftFontMetrics;
import guideme.render.GuiAssets;
import guideme.render.GuidePageTexture;
import guideme.render.RenderContext;
import guideme.style.TextAlignment;
import guideme.style.TextStyle;
import guideme.ui.GuideUiHost;
import guideme.ui.UiPoint;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideScreen
extends DocumentScreen
implements GuideUiHost {
    private static final Logger LOG = LoggerFactory.getLogger(GuideScreen.class);
    private final Guide guide;
    private GuidePage currentPage;
    private final LytParagraph pageTitle;
    private final NavigationToolbar toolbar;
    @Nullable
    private Screen returnToOnClose;
    @Nullable
    private String pendingScrollToAnchor;
    private final GuideNavBar navbar;

    private GuideScreen(Guide guide, PageAnchor anchor) {
        super((Component)Component.m_237113_((String)"GuideME Guidebook"));
        this.guide = guide;
        this.pageTitle = new LytParagraph();
        this.pageTitle.setStyle(DefaultStyles.HEADING1);
        this.toolbar = new NavigationToolbar(guide);
        this.toolbar.setCloseCallback(this::m_7379_);
        this.toolbar.setCanSearch(true);
        this.navbar = new GuideNavBar(this);
        this.loadPageAndScrollTo(anchor);
    }

    public static GuideScreen openNew(Guide guide, PageAnchor anchor) {
        return GuideScreen.openNew(guide, anchor, GlobalInMemoryHistory.get(guide));
    }

    public static GuideScreen openNew(Guide guide, PageAnchor anchor, GuideScreenHistory history) {
        history.push(anchor);
        return new GuideScreen(guide, anchor);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)this.navbar);
        this.toolbar.addToScreen(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.updateScreenLayout();
    }

    private void updateScreenLayout() {
        if (this.screenRect.isEmpty()) {
            return;
        }
        this.navbar.setPinned(this.hasSpaceForSidebar());
        this.navbar.m_252865_(this.screenRect.x());
        int left = this.screenRect.x();
        if (!this.navbar.isPinned() && left < 15) {
            left = 15;
        }
        int availableWidth = this.screenRect.right() - left - this.toolbar.getWidth() - 5;
        this.updateTitleLayout(left, availableWidth);
        int marginTop = this.pageTitle.getBounds().bottom() + 4;
        int toolbarTop = (marginTop - this.toolbar.getHeight()) / 2;
        this.toolbar.move(this.screenRect.right() - this.toolbar.getWidth(), toolbarTop);
        if (this.navbar.isPinned()) {
            left = this.screenRect.x() + this.navbar.m_5711_();
        }
        this.setDocumentRect(new LytRect(left, this.screenRect.y() + marginTop, this.screenRect.right() - left, this.screenRect.height() - this.getMarginBottom() - marginTop));
        if (this.navbar.isPinned()) {
            this.navbar.m_253211_(this.getDocumentRect().y());
            this.navbar.setHeight(this.getDocumentRect().height());
        } else {
            this.navbar.m_253211_(this.screenRect.y());
            this.navbar.setHeight(this.screenRect.height());
        }
        this.updateDocumentLayout();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.toolbar.update();
        this.processPendingScrollTo();
    }

    @Override
    protected boolean documentClicked(UiPoint documentPoint, int button) {
        if (button == 3) {
            GuideNavigation.navigateBack(this.guide);
            return true;
        }
        if (button == 4) {
            GuideNavigation.navigateForward(this.guide);
            return true;
        }
        return false;
    }

    private void processPendingScrollTo() {
        LytFlowAnchor flowAnchor;
        if (this.pendingScrollToAnchor == null) {
            return;
        }
        String anchor = this.pendingScrollToAnchor;
        this.pendingScrollToAnchor = null;
        AnchorIndexer indexer = new AnchorIndexer(this.currentPage.document());
        AnchorIndexer.AnchorTarget targetAnchor = indexer.get(anchor);
        if (targetAnchor == null) {
            LOG.warn("Failed to find anchor {} in page {}", (Object)anchor, (Object)this.currentPage);
            return;
        }
        LytFlowContent lytFlowContent = targetAnchor.flowContent();
        if (lytFlowContent instanceof LytFlowAnchor && (flowAnchor = (LytFlowAnchor)lytFlowContent).getLayoutY().isPresent()) {
            this.setDocumentScrollY(flowAnchor.getLayoutY().getAsInt());
        } else {
            LytRect bounds = targetAnchor.blockNode().getBounds();
            this.setDocumentScrollY(bounds.y());
        }
    }

    @Override
    public void scaledRender(GuiGraphics guiGraphics, RenderContext context, int mouseX, int mouseY, float partialTick) {
        context.fillIcon(this.screenRect, GuiAssets.GUIDE_BACKGROUND, SymbolicColor.GUIDE_SCREEN_BACKGROUND);
        LytRect documentRect = this.getDocumentRect();
        context.fillRect(documentRect, new ConstantColor(0x40333333));
        this.renderDocument(context);
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, 0.0f, 200.0f);
        this.renderTitle(documentRect, context);
        if (this.hasFooter()) {
            this.renderFooter(documentRect, context);
        }
        super.scaledRender(guiGraphics, context, mouseX, mouseY, partialTick);
        poseStack.m_85849_();
        this.renderDocumentTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void renderFooter(LytRect documentRect, RenderContext context) {
        String externalSource = this.getExternalSourceName();
        if (externalSource != null) {
            LytParagraph paragraph = new LytParagraph();
            paragraph.appendText(GuidebookText.ContentFrom.text().getString() + " ");
            LytFlowSpan sourceSpan = new LytFlowSpan();
            sourceSpan.appendText(externalSource);
            sourceSpan.setStyle(TextStyle.builder().italic(true).build());
            paragraph.append(sourceSpan);
            paragraph.setStyle(TextStyle.builder().alignment(TextAlignment.RIGHT).build());
            LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
            paragraph.layout(layoutContext, documentRect.x(), documentRect.bottom(), documentRect.width());
            MultiBufferSource.BufferSource buffers = context.beginBatch();
            paragraph.renderBatch(context, (MultiBufferSource)buffers);
            context.endBatch(buffers);
        }
    }

    @Override
    protected boolean hasFooter() {
        return this.getExternalSourceName() != null;
    }

    @Nullable
    private String getExternalSourceName() {
        Pack pack = Minecraft.m_91087_().m_91099_().m_10507_(this.currentPage.sourcePack());
        if (pack != null && !pack.m_10446_().equals("mod_resources")) {
            return pack.m_10442_().getString();
        }
        String pageNamespace = this.currentPage.id().m_135827_();
        if (!this.guide.getDefaultNamespace().equals(pageNamespace)) {
            return ModList.get().getModContainerById(pageNamespace).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(null);
        }
        return null;
    }

    public void m_280273_(GuiGraphics guiGraphics) {
    }

    private void renderTitle(LytRect documentRect, RenderContext context) {
        MultiBufferSource.BufferSource buffers = context.beginBatch();
        this.pageTitle.renderBatch(context, (MultiBufferSource)buffers);
        context.endBatch(buffers);
        LytRect separatorRect = new LytRect(this.screenRect.x(), documentRect.y() - 1, this.screenRect.width(), 1);
        separatorRect = separatorRect.withWidth(this.screenRect.width());
        context.fillRect(separatorRect, SymbolicColor.HEADER1_SEPARATOR);
    }

    @Override
    public void navigateTo(ResourceLocation pageId) {
        this.navigateTo(PageAnchor.page(pageId));
    }

    @Override
    public void navigateTo(PageAnchor anchor) {
        GuideNavigation.navigateTo(this.guide, anchor);
    }

    void loadPageAndScrollTo(PageAnchor anchor) {
        this.loadPage(anchor.pageId());
        this.setDocumentScrollY(0);
        this.updateDocumentLayout();
        this.pendingScrollToAnchor = anchor.anchor();
    }

    @Override
    public void reloadPage() {
        this.loadPage(this.currentPage.id());
        this.updateDocumentLayout();
    }

    private void loadPage(ResourceLocation pageId) {
        GuidePageTexture.releaseUsedTextures();
        ParsedGuidePage page = this.guide.getParsedPage(pageId);
        if (page == null) {
            page = this.buildNotFoundPage(pageId);
        }
        this.currentPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
        this.pageTitle.clearContent();
        for (LytFlowContent flowContent : this.extractPageTitle(this.currentPage)) {
            this.pageTitle.append(flowContent);
        }
        this.updateScreenLayout();
    }

    private Iterable<LytFlowContent> extractPageTitle(GuidePage page) {
        for (LytBlock block : page.document().getBlocks()) {
            if (!(block instanceof LytHeading)) continue;
            LytHeading heading = (LytHeading)block;
            if (heading.getDepth() != 1) break;
            page.document().removeChild(heading);
            return heading.getContent();
        }
        return List.of();
    }

    private ParsedGuidePage buildNotFoundPage(ResourceLocation pageId) {
        String pageSource = "# Page not Found\n\nPage \"" + pageId + "\" could not be found.";
        return PageCompiler.parse(pageId.m_135827_(), "en_us", pageId, pageSource);
    }

    public void m_7861_() {
        super.m_7861_();
        GuidePageTexture.releaseUsedTextures();
    }

    public void setReturnToOnClose(@Nullable Screen screen) {
        this.returnToOnClose = screen;
    }

    @Nullable
    public Screen getReturnToOnClose() {
        return this.returnToOnClose;
    }

    @Override
    protected LytDocument getDocument() {
        return this.currentPage.document();
    }

    private void updateTitleLayout(int left, int availableWidth) {
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        int minTitleHeight = 20;
        this.pageTitle.layout(context, 0, 0, availableWidth);
        int titleY = Math.max(4, minTitleHeight - this.pageTitle.getBounds().height()) / 2;
        this.pageTitle.layout(context, left + 5, titleY, availableWidth);
    }

    public void scrollToAnchor(@Nullable String anchor) {
        this.pendingScrollToAnchor = anchor;
        if (anchor == null) {
            this.setDocumentScrollY(0);
        }
    }

    @Override
    public PageCollection getGuide() {
        return this.guide;
    }

    public ResourceLocation getCurrentPageId() {
        return this.currentPage.id();
    }

    @Override
    public void m_7379_() {
        if (this.f_96541_ != null && this.f_96541_.f_91080_ == this && this.returnToOnClose != null) {
            this.f_96541_.m_91152_(this.returnToOnClose);
            this.returnToOnClose = null;
            return;
        }
        super.m_7379_();
    }

    private boolean hasSpaceForSidebar() {
        return this.f_96543_ >= super.getMaxWidth();
    }
}

