/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.WaterFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={WaterFluid.class})
public abstract class MixinWaterFluid
extends FlowingFluid {
    @Unique
    boolean isWithinInfBiomeHeights = false;
    @Unique
    boolean isInfBiome = false;
    @Unique
    boolean hasSkyLight = false;

    @Shadow
    public abstract int m_6713_(LevelReader var1);

    @Shadow
    public abstract boolean m_6212_(Fluid var1);

    protected void m_213812_(Level level, BlockPos blockPos, FluidState fluidState, RandomSource randomSource) {
        super.m_213812_(level, blockPos, fluidState, randomSource);
        if (level.m_5776_() || fluidState.m_76178_() || !FlowingFluids.config.enableMod || !FlowingFluids.config.isFluidAllowed(fluidState)) {
            return;
        }
        if (FlowingFluids.config.dontTickAtLocation(blockPos, (LevelAccessor)level)) {
            return;
        }
        this.isWithinInfBiomeHeights = FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly ? level.m_5736_() == blockPos.m_123342_() || level.m_5736_() - 1 == blockPos.m_123342_() : level.m_5736_() == blockPos.m_123342_() && blockPos.m_123342_() > 0;
        this.hasSkyLight = level.m_45517_(LightLayer.SKY, blockPos) > 0;
        this.isInfBiome = FFFluidUtils.matchInfiniteBiomes((Holder<Biome>)level.m_204166_(blockPos));
        int amount = fluidState.m_76186_();
        if (amount < 8) {
            if (this.ff$tryBiomeFillOrDrain(level, blockPos, amount, level.f_46441_.m_188501_())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was filled by biome at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.oceanRiverSwampRefillChance);
                }
                return;
            }
            if (this.ff$tryRainFill(level, blockPos, level.f_46441_.m_188501_())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was filled by rain at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.rainRefillChance);
                }
                return;
            }
            if (this.ff$tryEvaporateNether(level, blockPos, amount, level.f_46441_.m_188501_())) {
                if (FlowingFluids.config.printRandomTicks) {
                    FlowingFluids.info("--- Water was evaporated via Nether at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.evaporationChanceV2);
                }
                return;
            }
            if (this.ff$tryEvaporate(level, blockPos, amount, level.f_46441_.m_188501_()) && FlowingFluids.config.printRandomTicks) {
                FlowingFluids.info("--- Water was evaporated - non Nether at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.evaporationChanceV2);
            }
        } else if (this.ff$tryRainFill(level, blockPos, level.f_46441_.m_188501_()) && FlowingFluids.config.printRandomTicks) {
            FlowingFluids.info("--- Water was filled by rain at " + String.valueOf(blockPos) + ". Chance: " + FlowingFluids.config.rainRefillChance);
        }
    }

    @Unique
    private boolean ff$tryRainFill(Level level, BlockPos blockPos, float chance) {
        int amount;
        Pair<Integer, Runnable> result;
        if (chance < Math.min(FlowingFluids.config.rainRefillChance, FlowingFluids.config.evaporationChanceV2 / 3.0f) && level.m_46471_() && level.m_45527_(blockPos.m_7494_()) && (!this.isInfBiome || !this.isWithinInfBiomeHeights) && !level.m_204166_(blockPos).m_203656_(BiomeTags.f_207590_) && (Integer)(result = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction((LevelAccessor)level, blockPos, amount = level.m_46470_() ? 2 : 1, this, 40, FlowingFluids.config.rainFillsWaterHigherV2, false)).first() != amount) {
            ((Runnable)result.second()).run();
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryBiomeFillOrDrain(Level level, BlockPos blockPos, int amount, float chance) {
        if (level.m_5736_() == blockPos.m_123342_()) {
            FluidState below;
            if ((chance < FlowingFluids.config.infiniteWaterBiomeNonConsumeChance || chance < FlowingFluids.config.oceanRiverSwampRefillChance || level.m_46471_() && chance < FlowingFluids.config.rainRefillChance) && (below = level.m_6425_(blockPos.m_7495_())).m_76186_() == 8 && below.m_205070_(FluidTags.f_13131_) && this.hasSkyLight && this.isInfBiome) {
                level.m_46597_(blockPos, FFFluidUtils.getBlockForFluidByAmount((Fluid)this, amount - 2));
                return true;
            }
        } else if (this.isWithinInfBiomeHeights && amount < 8 && chance < FlowingFluids.config.oceanRiverSwampRefillChance && this.isInfBiome && this.hasSkyLight) {
            level.m_46597_(blockPos, FFFluidUtils.getBlockForFluidByAmount((Fluid)this, amount + 2));
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryEvaporate(Level level, BlockPos blockPos, int amount, float chance) {
        if (chance < FlowingFluids.config.evaporationChanceV2 && amount <= this.m_6713_((LevelReader)level) && level.m_6425_(blockPos.m_7495_()).m_76178_()) {
            level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            return true;
        }
        return false;
    }

    @Unique
    private boolean ff$tryEvaporateNether(Level level, BlockPos blockPos, int amount, float chance) {
        if (chance < FlowingFluids.config.evaporationNetherChance && level.m_204166_(blockPos).m_203656_(BiomeTags.f_207612_)) {
            if (amount == 1) {
                level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
            } else {
                level.m_46597_(blockPos, FFFluidUtils.getBlockForFluidByAmount((Fluid)this, amount - 3));
            }
            return true;
        }
        return false;
    }

    @Inject(method={"getSlopeFindDistance"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifySlopeDistance(LevelReader level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)Mth.m_14045_((int)FlowingFluids.config.waterFlowDistance, (int)1, (int)8));
        }
    }

    @Inject(method={"getTickDelay"}, at={@At(value="RETURN")}, cancellable=true)
    private void ff$modifyTickDelay(LevelReader level, CallbackInfoReturnable<Integer> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed((Fluid)this)) {
            cir.setReturnValue((Object)Mth.m_14045_((int)FlowingFluids.config.waterTickDelay, (int)1, (int)255));
        }
    }
}

