/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.forge.mixin.create;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.config.FFConfig;

@Pseudo
@Mixin(value={WaterWheelBlockEntity.class})
public abstract class MixinWaterWheel
extends GeneratingKineticBlockEntity {
    @Shadow(remap=false)
    protected abstract Set<BlockPos> getOffsetsToCheck();

    @Shadow(remap=false)
    public abstract void setFlowScoreAndUpdate(int var1);

    public MixinWaterWheel(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Inject(method={"determineAndApplyFlowScore"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void ff$modifyWaterCheck(CallbackInfo ci) {
        try {
            if (!FlowingFluids.config.enableMod || FlowingFluids.config.create_waterWheelMode == FFConfig.CreateWaterWheelMode.REQUIRE_FLOW || this.f_58857_ == null) {
                return;
            }
            if (FlowingFluids.config.create_waterWheelMode.isRiver() && (!this.f_58857_.m_204166_(this.f_58858_).m_203656_(BiomeTags.f_207605_) || Math.abs(this.f_58858_.m_123342_() - this.f_58857_.m_5736_()) > 5)) {
                if (FlowingFluids.config.create_waterWheelMode.isRiverOnly()) {
                    ci.cancel();
                    this.setFlowScoreAndUpdate(0);
                }
                return;
            }
            ci.cancel();
            boolean fluidCanBeAnyHeight = !FlowingFluids.config.create_waterWheelMode.needsFullFluid();
            boolean oppositeSpin = FlowingFluids.config.create_waterWheelMode.isCounterSpin();
            boolean alwaysSpin = FlowingFluids.config.create_waterWheelMode.always();
            boolean lava = false;
            int score = 0;
            for (BlockPos blockPos : this.getOffsetsToCheck()) {
                BlockPos checkPos = blockPos.m_121955_((Vec3i)this.f_58858_);
                FluidState fState = this.f_58857_.m_6425_(checkPos);
                lava |= fState.m_76152_().m_6212_((Fluid)Fluids.f_76195_);
                if (!alwaysSpin && (fState.m_76178_() || !fluidCanBeAnyHeight && fState.m_76186_() != 8)) continue;
                score += oppositeSpin ? -1 : 1;
            }
            if (score != 0 && !this.f_58857_.m_5776_()) {
                this.award(lava ? AllAdvancements.LAVA_WHEEL : AllAdvancements.WATER_WHEEL);
            }
            this.setFlowScoreAndUpdate(score);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

