/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.forge.mixin.create;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyFluidHandler;
import com.simibubi.create.content.fluids.transfer.FluidDrainingBehaviour;
import com.simibubi.create.content.fluids.transfer.FluidFillingBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.FluidHelper;
import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.forge.mixin.create.FluidDrainingBehaviourAccessor;
import traben.flowing_fluids.forge.mixin.create.FluidManipulationBehaviourAccessor;

@Pseudo
@Mixin(value={HosePulleyFluidHandler.class})
public abstract class MixinHosePulley {
    @Shadow(remap=false)
    private FluidDrainingBehaviour drainer;
    @Shadow(remap=false)
    private FluidFillingBehaviour filler;
    private static final String INSERT_METHOD_FF = "fill";

    @WrapOperation(method={"drainInternal"}, remap=false, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/fluids/transfer/FluidDrainingBehaviour;getDrainableFluid(Lnet/minecraft/core/BlockPos;)Lnet/minecraftforge/fluids/FluidStack;")})
    private FluidStack ff$modifyWaterRemoval1(FluidDrainingBehaviour instance, BlockPos blockPos, Operation<FluidStack> original) {
        if (FlowingFluids.config.enableMod) {
            Fluid newFluid;
            Fluid fluid = ((FluidDrainingBehaviourAccessor)this.drainer).ff$getFluid();
            if (fluid == null && FlowingFluids.config.isFluidAllowed(newFluid = this.drainer.getWorld().m_6425_(blockPos).m_76152_())) {
                if (((FluidDrainingBehaviourAccessor)this.drainer).ff$getFluid() == null) {
                    ((FluidDrainingBehaviourAccessor)this.drainer).ff$setFluid(FluidHelper.convertToStill((Fluid)newFluid));
                }
                fluid = newFluid;
            }
            if (fluid == Fluids.f_76191_) {
                return FluidStack.EMPTY;
            }
            if (FlowingFluids.config.isFluidAllowed(fluid)) {
                Fluid source = FluidHelper.convertToStill((Fluid)fluid);
                return new FluidStack(source, 1000);
            }
        }
        return (FluidStack)original.call(new Object[]{instance, blockPos});
    }

    @WrapOperation(method={"drainInternal"}, remap=false, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/fluids/transfer/FluidDrainingBehaviour;pullNext(Lnet/minecraft/core/BlockPos;Z)Z")})
    private boolean ff$modifyWaterRemoval2(FluidDrainingBehaviour instance, BlockPos blockPos, boolean simulate, Operation<Boolean> original, @Share(value="foundLevels") LocalIntRef foundLevels, @Local(ordinal=0, argsOnly=true) int maxAmount) {
        foundLevels.set(8);
        if (FlowingFluids.config.enableMod) {
            Fluid fluid;
            Level world = this.drainer.getWorld();
            BlockState state = world.m_8055_(blockPos);
            FluidState fluidState = state.m_60819_();
            if (fluidState.m_76178_()) {
                return false;
            }
            if (FlowingFluids.config.isFluidAllowed(fluidState) && (fluid = fluidState.m_76152_()) instanceof FlowingFluid) {
                FlowingFluid flowing = (FlowingFluid)fluid;
                if (simulate) {
                    return true;
                }
                ((FluidManipulationBehaviourAccessor)this.drainer).ff$PlayEffect(world, blockPos, (Fluid)flowing, true);
                this.drainer.blockEntity.award(AllAdvancements.HOSE_PULLEY);
                if (this.drainer.isInfinite() && FluidHelper.isLava((Fluid)flowing)) {
                    this.drainer.blockEntity.award(AllAdvancements.HOSE_PULLEY_LAVA);
                }
                if (FlowingFluids.config.create_infinitePipes || this.drainer.isInfinite()) {
                    return true;
                }
                Pair<Integer, Runnable> data = FFFluidUtils.collectConnectedFluidAmountAndRemoveAction((LevelAccessor)world, blockPos, 1, 8, flowing);
                Integer found = (Integer)data.first();
                if (found == 0) {
                    return false;
                }
                ((Runnable)data.second()).run();
                foundLevels.set(found.intValue());
                return true;
            }
        }
        return (Boolean)original.call(new Object[]{instance, blockPos, simulate});
    }

    @ModifyConstant(method={"drainInternal"}, constant={@Constant(intValue=1000, ordinal=1)}, remap=false)
    private int ff$modifyWaterRemoval3(int original, @Share(value="foundLevels") LocalIntRef foundLevels) {
        return this.waterModified(foundLevels.get());
    }

    @WrapOperation(method={"fill"}, remap=false, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/fluids/transfer/FluidFillingBehaviour;tryDeposit(Lnet/minecraft/world/level/material/Fluid;Lnet/minecraft/core/BlockPos;Z)Z")})
    private boolean ff$modifyWaterPlacing(FluidFillingBehaviour instance, Fluid fluid, BlockPos blockPos, boolean b, Operation<Boolean> original, @Share(value="placedLevels") LocalIntRef placedLevels) {
        placedLevels.set(8);
        if (FlowingFluids.config.enableMod && !FlowingFluids.config.create_infinitePipes && FlowingFluids.config.isFluidAllowed(fluid)) {
            Level world = this.filler.getWorld();
            int remainder = FFFluidUtils.addAmountToFluidAtPosWithRemainder((LevelAccessor)world, blockPos.m_7495_(), fluid, 8);
            if (remainder == 8) {
                return false;
            }
            placedLevels.set(8 - remainder);
            return true;
        }
        return (Boolean)original.call(new Object[]{instance, fluid, blockPos, b});
    }

    @ModifyConstant(method={"fill"}, constant={@Constant(intValue=1000, ordinal=1)}, remap=false)
    private int ff$modifyWaterPlacing1(int original, @Share(value="placedLevels") LocalIntRef placedLevels) {
        return this.waterModified(placedLevels.get());
    }

    @ModifyConstant(method={"fill"}, constant={@Constant(intValue=1000, ordinal=2)}, remap=false)
    private int ff$modifyWaterPlacing2(int original, @Share(value="placedLevels") LocalIntRef placedLevels) {
        return this.waterModified(placedLevels.get());
    }

    @Inject(method={"fill"}, at={@At(value="INVOKE", target="Lnet/minecraftforge/fluids/FluidStack;shrink(I)V")}, remap=false)
    private void ff$modifyWaterPlacing3(FluidStack resource, IFluidHandler.FluidAction action, CallbackInfoReturnable<Integer> cir, @Share(value="placedLevels") LocalIntRef placedLevels, @Local(name={"diff"}) LocalIntRef diff) {
        if (placedLevels.get() == 8) {
            return;
        }
        int newDiff = diff.get() + 1000;
        diff.set(newDiff - this.waterModified(placedLevels.get()));
    }

    @Unique
    private int waterModified(int level) {
        if (level == 0) {
            return 0;
        }
        if (level == 8) {
            return 1000;
        }
        return 125 * level;
    }
}

