/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.forge;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.config.FFConfig;

public class ForgePacketHandler {
    private static final int PROTOCOL_VERSION = 1;
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)FFFluidUtils.res("flowing_fluids", "channel"), () -> String.valueOf(1), String.valueOf(1)::equals, String.valueOf(1)::equals);

    public static void init() {
        INSTANCE.registerMessage(0, FFConfigPacket.class, FFConfigPacket::encoder, FFConfigPacket::decoder, FFConfigPacket::messageConsumer);
    }

    public static class FFConfigPacket
    extends FFConfig {
        private boolean is_valid;

        FFConfigPacket() {
        }

        FFConfigPacket(FriendlyByteBuf buffer) {
            super(buffer);
        }

        public static FFConfigPacket decoder(FriendlyByteBuf buffer) {
            FFConfigPacket packet;
            if (FMLEnvironment.dist == Dist.CLIENT) {
                try {
                    FlowingFluids.info("- Server Config packet received");
                    packet = new FFConfigPacket(buffer);
                    packet.is_valid = true;
                }
                catch (Exception e) {
                    FlowingFluids.error("- Server Config packet decoding failed because:\n" + String.valueOf(e));
                    e.printStackTrace();
                    packet = new FFConfigPacket();
                    packet.is_valid = false;
                }
            } else {
                packet = new FFConfigPacket(buffer);
                packet.is_valid = false;
            }
            return packet;
        }

        public void messageConsumer(Supplier<NetworkEvent.Context> ctx) {
            if (!this.is_valid) {
                FlowingFluids.error("- Server Config data received and failed to sync");
                throw new RuntimeException("[Flowing Fluids] - Server Config data received and failed to sync");
            }
            FlowingFluids.config = this;
            FlowingFluids.info("- Server Config data received and synced");
            ctx.get().setPacketHandled(true);
        }

        public void encoder(FriendlyByteBuf buffer) {
            FlowingFluids.config.encodeToByteBuffer(buffer);
        }
    }
}

