/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import traben.flowing_fluids.FlowingFluids;

public class PlugWaterFeature {
    private static final Pair<Boolean, Runnable> defTrue = Pair.of((Object)true, null);
    private static final Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.DOWN};

    public static Set<BlockPos> findBlocks(ChunkAccess chunkAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        for (int i = chunkAccess.m_151560_(); i < chunkAccess.m_151561_(); ++i) {
            LevelChunkSection levelChunkSection = chunkAccess.m_183278_(chunkAccess.m_151566_(i));
            if (!levelChunkSection.m_63002_(PlugWaterFeature::isFluidSource)) continue;
            BlockPos blockPos = SectionPos.m_123196_((ChunkPos)chunkAccess.m_7697_(), (int)i).m_123249_();
            for (int y = y1; y < y2; ++y) {
                for (int z = z1; z < z2; ++z) {
                    for (int x = x1; x < x2; ++x) {
                        BlockState blockState = levelChunkSection.m_62982_(x, y, z);
                        if (!PlugWaterFeature.isFluidSource(blockState)) continue;
                        set.add(mutableBlockPos.m_122154_((Vec3i)blockPos, x, y, z).m_7949_());
                    }
                }
            }
        }
        return set;
    }

    public static void processChunk(LevelAccessor level, ChunkPos chunk, ChunkAccess chunkAccess) {
        boolean hasXNeg = level.m_7232_(chunk.f_45578_ - 1, chunk.f_45579_);
        boolean hasXPos = level.m_7232_(chunk.f_45578_ + 1, chunk.f_45579_);
        boolean hasZNeg = level.m_7232_(chunk.f_45578_, chunk.f_45579_ - 1);
        boolean hasZPos = level.m_7232_(chunk.f_45578_, chunk.f_45579_ + 1);
        Set<BlockPos> set = PlugWaterFeature.findBlocks(chunkAccess, 0, 0, 0, 16, 16, 16);
        if (hasXNeg) {
            set.addAll(PlugWaterFeature.findBlocks(level.m_6325_(chunk.f_45578_ - 1, chunk.f_45579_), 15, 0, 0, 16, 16, 16));
        }
        if (hasXPos) {
            set.addAll(PlugWaterFeature.findBlocks(level.m_6325_(chunk.f_45578_ + 1, chunk.f_45579_), 0, 0, 0, 1, 16, 16));
        }
        if (hasZNeg) {
            set.addAll(PlugWaterFeature.findBlocks(level.m_6325_(chunk.f_45578_, chunk.f_45579_ - 1), 0, 0, 15, 16, 16, 16));
        }
        if (hasZPos) {
            set.addAll(PlugWaterFeature.findBlocks(level.m_6325_(chunk.f_45578_, chunk.f_45579_ + 1), 0, 0, 0, 16, 16, 1));
        }
        if (set.isEmpty()) {
            return;
        }
        int minx = chunk.m_45604_();
        int minz = chunk.m_45605_();
        int maxx = chunk.m_45608_();
        int maxz = chunk.m_45609_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int sea = level.m_5736_() - 5;
        HashSet doneSet = new HashSet();
        Supplier<Pair> testDo = () -> {
            if (mutableBlockPos.m_123341_() < minx || mutableBlockPos.m_123341_() > maxx) {
                return defTrue;
            }
            if (mutableBlockPos.m_123343_() < minz || mutableBlockPos.m_123343_() > maxz) {
                return defTrue;
            }
            if (set.contains(mutableBlockPos)) {
                return defTrue;
            }
            BlockState blockState = chunkAccess.m_8055_((BlockPos)mutableBlockPos);
            if (blockState.m_60795_() && blockState.m_60819_().m_76178_()) {
                BlockPos immutable = mutableBlockPos.m_7949_();
                doneSet.add(immutable);
                return Pair.of((Object)false, () -> PlugWaterFeature.fillBlock(chunkAccess, immutable, sea));
            }
            return null;
        };
        ArrayList<Runnable> runs = new ArrayList<Runnable>();
        for (BlockPos blockPos : set) {
            if (doneSet.contains(blockPos)) continue;
            boolean neighbourWater = false;
            runs.clear();
            for (Direction dir : dirs) {
                mutableBlockPos.m_122159_((Vec3i)blockPos, dir);
                Pair result = testDo.get();
                if (result == null) continue;
                if (((Boolean)result.first()).booleanValue()) {
                    neighbourWater = true;
                    continue;
                }
                runs.add((Runnable)result.second());
            }
            if (!neighbourWater) continue;
            for (Runnable run : runs) {
                run.run();
            }
        }
    }

    private static boolean isFluidSource(BlockState state) {
        FluidState fluid = state.m_60819_();
        if (fluid.m_76178_() || !fluid.m_76170_()) {
            return false;
        }
        return FlowingFluids.config.isFluidAllowed(fluid);
    }

    private static void fillBlock(ChunkAccess chunk, BlockPos pos, int seaLevel) {
        Holder biome = chunk.m_203495_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        BlockState blockState = biome.m_203656_(BiomeTags.f_207612_) ? Blocks.f_50134_.m_49966_() : (biome.m_203656_(BiomeTags.f_215818_) ? Blocks.f_50259_.m_49966_() : (pos.m_123342_() < 0 ? Blocks.f_152550_.m_49966_() : (pos.m_123342_() < seaLevel ? Blocks.f_50069_.m_49966_() : (biome.m_203656_(BiomeTags.f_207590_) || biome.m_203656_(BiomeTags.f_207604_) || biome.m_203656_(BiomeTags.f_207603_) ? Blocks.f_49992_.m_49966_() : Blocks.f_220864_.m_49966_()))));
        if (FlowingFluids.config.announceWorldGenActions) {
            FlowingFluids.info("placed block during world gen: " + String.valueOf(blockState) + " at /tp @s " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_());
        }
        ++FlowingFluids.waterPluggedThisSession;
        chunk.m_6978_(pos, blockState, false);
    }
}

