/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import org.zeith.hammerlib.util.java.io.win32.ZoneIdentifier;
import org.zeith.hammerlib.util.java.net.HttpRequest;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class ModSourceAdapter {
    public static final List<IllegalSite> ILLEGAL_SITES;

    public static Optional<ModSource> getModSource(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getOwningFile).map(IModFileInfo::getFile).map(IModFile::getFilePath).map(Path::toFile).flatMap(ZoneIdentifier::forFileSafe).map(ModSource::new);
    }

    public static Optional<ModSource> getModSource(Class<?> modClass) {
        try {
            File modFile = null;
            Mod mod = modClass.getDeclaredAnnotation(Mod.class);
            if (mod != null) {
                modFile = ModList.get().getModFileById(mod.value()).getFile().getFilePath().toFile();
            }
            if (modFile == null) {
                modFile = Path.of(modClass.getProtectionDomain().getCodeSource().getLocation().toURI()).toFile();
            }
            return ZoneIdentifier.forFile(modFile).map(ModSource::new);
        }
        catch (Throwable err) {
            err.printStackTrace();
            return Optional.empty();
        }
    }

    static {
        List<Object> illegalSites = List.of();
        try {
            illegalSites = new JSONTokener(HttpRequest.get("https://api.stopmodreposts.org/minecraft/sites.json").userAgent("HammerLib").body()).nextValueARR().stream().flatMap(array -> IntStream.range(0, array.size()).mapToObj(array::getJSONObject).map(IllegalSite::new)).toList();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        ILLEGAL_SITES = illegalSites;
    }

    public record IllegalSite(String domain, String notes, String path, String reason) implements Predicate<URL>
    {
        public IllegalSite(JSONObject object) {
            this(object.getString("domain"), object.optString("notes"), object.optString("path"), object.optString("reason"));
        }

        @Override
        public boolean test(URL url) {
            return (url.getHost().equalsIgnoreCase(this.domain) || url.getHost().endsWith("." + this.domain)) && url.getPath().startsWith(this.path);
        }
    }

    public record ModSource(String referrerUrl, String hostUrl) {
        public ModSource(ZoneIdentifier id) {
            this(id.referrerUrl, id.hostUrl);
        }

        public boolean wasDownloadedIllegally() {
            try {
                List<URL> urls = List.of(new URL(this.referrerUrl), new URL(this.hostUrl));
                return ILLEGAL_SITES.stream().anyMatch(site -> urls.stream().anyMatch(site));
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        public String referrerDomain() {
            try {
                return new URL(this.referrerUrl).getHost();
            }
            catch (MalformedURLException malformedURLException) {
                return this.referrerUrl;
            }
        }
    }
}

