/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.client.render.IGuiDrawable;
import org.zeith.hammerlib.client.utils.FXUtils;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.util.colors.ColorHelper;

public class UV
implements IGuiDrawable {
    public ResourceLocation path;
    public float posX;
    public float posY;
    public float width;
    public float height;

    public UV(ResourceLocation resource, float x, float y, float w, float h) {
        this.posX = x;
        this.posY = y;
        this.width = w;
        this.height = h;
        this.path = resource;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack pose, double x, double y, float width, float height) {
        pose.m_85836_();
        pose.m_85837_(x, y, 0.0);
        pose.m_85841_(1.0f / this.width * width, 1.0f / this.height * height, 1.0f);
        this.render(pose, 0.0f, 0.0f);
        pose.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gfx, double x, double y, float width, float height) {
        this.render(gfx.m_280168_(), x, y, width, height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(PoseStack pose, float x, float y) {
        RenderSystem.enableBlend();
        this.bindTexture();
        RenderUtils.drawTexturedModalRect(pose, x, y, this.posX, this.posY, this.width, this.height);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gfx, float x, float y) {
        this.render(gfx.m_280168_(), x, y);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderWithColor(PoseStack pose, int color, double x, double y, float width, float height) {
        pose.m_85836_();
        pose.m_85837_(x, y, 0.0);
        pose.m_85841_(1.0f / this.width * width, 1.0f / this.height * height, 1.0f);
        this.renderWithColor(pose, color, 0.0f, 0.0f);
        pose.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderWithColor(PoseStack pose, int color, float x, float y) {
        float[] pcol = (float[])RenderSystem.getShaderColor().clone();
        RenderSystem.enableBlend();
        this.bindTexture();
        ColorHelper.glColor1ia(color);
        RenderUtils.drawTexturedModalRect(pose, x, y, this.posX, this.posY, this.width, this.height);
        RenderSystem.setShaderColor((float)pcol[0], (float)pcol[1], (float)pcol[2], (float)pcol[3]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void bindTexture() {
        FXUtils.bindTexture(this.path);
    }

    public String toString() {
        return "UV{path=" + this.path + ", posX=" + this.posX + ", posY=" + this.posY + ", width=" + this.width + ", height=" + this.height + "}";
    }

    @Override
    public void renderDrawable(GuiGraphics gfx, int xOffset, int yOffset, int width, int height) {
        this.render(gfx, (double)xOffset, (double)yOffset, (float)width, (float)height);
    }
}

