/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.reader;

import com.google.common.base.MoreObjects;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapterFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.LowerCaseEnumTypeAdapterFactory;
import org.jetbrains.annotations.NotNull;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.JsContext;
import org.zeith.hammerlib.core.js.CallerSpec;
import org.zeith.hammerlib.core.js.ObjectMirrorConverter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.OptionalBoolean;
import org.zeith.hammerlib.util.java.OptionalFloat;
import org.zeith.hammerlib.util.java.cbqs.cbq3.BoolCallback3;
import org.zeith.hammerlib.util.java.cbqs.cbq3.Callback3;
import org.zeith.hammerlib.util.java.cbqs.cbq3.DoubleCallback3;
import org.zeith.hammerlib.util.java.cbqs.cbq3.IntCallback3;
import org.zeith.hammerlib.util.java.itf.BooleanConsumer;
import org.zeith.hammerlib.util.java.itf.FloatConsumer;
import org.zeith.hammerlib.util.shaded.json.JSONObject;

public class ComDrivers {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComDrivers.class);
    private static final CallerSpec CBQ_SPEC = new CallerSpec("invoke", false);
    private static final CallerSpec CBQ_RET_SPEC = new CallerSpec("invoke", true);
    private static final Gson GSON = (Gson)Util.m_137537_(() -> {
        GsonBuilder gsonbuilder = new GsonBuilder();
        gsonbuilder.disableHtmlEscaping();
        gsonbuilder.registerTypeHierarchyAdapter(Component.class, (Object)new Component.Serializer());
        gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
        gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new LowerCaseEnumTypeAdapterFactory());
        return gsonbuilder.create();
    });
    private static final String CAST_NAME = Cast.class.getName();

    public static boolean driveComponent(DriverContext ctx, String name, Component defaultValue, boolean alwaysDrive, Consumer<Component> driver) {
        boolean dynamic;
        Supplier<Component> parsed = ComDrivers.readComponent(ctx, name);
        Supplier<Optional<Component>> fallback = Cast.constant(Optional.ofNullable(defaultValue));
        boolean bl = dynamic = alwaysDrive || !ComDrivers.isConstant(parsed);
        if (dynamic) {
            ctx.onPreRender((time, mouse) -> Optional.ofNullable((Component)parsed.get()).or(fallback).ifPresent(driver));
        }
        Optional.ofNullable(parsed.get()).or(fallback).ifPresent(driver);
        return dynamic;
    }

    public static boolean driveString(DriverContext ctx, String name, String defaultValue, boolean alwaysDrive, Consumer<String> driver) {
        boolean dynamic;
        Supplier<String> parsed = ComDrivers.readString(ctx, name);
        Supplier<Optional<String>> fallback = Cast.constant(Optional.ofNullable(defaultValue));
        boolean bl = dynamic = alwaysDrive || !ComDrivers.isConstant(parsed);
        if (dynamic) {
            ctx.onPreRender((time, mouse) -> Optional.ofNullable((String)parsed.get()).or(fallback).ifPresent(driver));
        }
        Optional.ofNullable(parsed.get()).or(fallback).ifPresent(driver);
        return dynamic;
    }

    public static boolean driveBool(DriverContext ctx, String name, Boolean defaultValue, boolean alwaysDrive, BooleanConsumer driver) {
        boolean dynamic;
        Supplier<OptionalBoolean> parsed = ComDrivers.readBoolean(ctx, name);
        OptionalBoolean fallback = defaultValue != null ? OptionalBoolean.of(defaultValue) : OptionalBoolean.empty();
        boolean bl = dynamic = alwaysDrive || !ComDrivers.isConstant(parsed);
        if (dynamic) {
            ctx.onPreRender((time, mouse) -> ((OptionalBoolean)((Object)((Object)parsed.get()))).or(fallback).ifPresent(driver));
        }
        parsed.get().or(fallback).ifPresent(driver);
        return dynamic;
    }

    public static boolean driveFloat(DriverContext ctx, String name, Float defaultValue, boolean alwaysDrive, FloatConsumer driver) {
        boolean dynamic;
        Supplier<OptionalFloat> parsed = ComDrivers.readFloat(ctx, name);
        OptionalFloat fallback = defaultValue != null ? OptionalFloat.of(defaultValue.floatValue()) : OptionalFloat.empty();
        boolean bl = dynamic = alwaysDrive || !ComDrivers.isConstant(parsed);
        if (dynamic) {
            ctx.onPreRender((time, mouse) -> ((OptionalFloat)parsed.get()).or(fallback).ifPresent(driver));
        }
        parsed.get().or(fallback).ifPresent(driver);
        return dynamic;
    }

    public static boolean driveInt(DriverContext ctx, String name, Integer defaultValue, boolean alwaysDrive, IntConsumer driver) {
        boolean dynamic;
        Supplier<OptionalInt> parsed = ComDrivers.readInt(ctx, name);
        OptionalInt fallback = defaultValue != null ? OptionalInt.of(defaultValue) : OptionalInt.empty();
        boolean bl = dynamic = alwaysDrive || !ComDrivers.isConstant(parsed);
        if (dynamic) {
            ctx.onPreRender((time, mouse) -> ((OptionalInt)parsed.get()).ifPresentOrElse(driver, () -> fallback.ifPresent(driver)));
        }
        parsed.get().ifPresentOrElse(driver, () -> fallback.ifPresent(driver));
        return dynamic;
    }

    public static boolean driveColor(DriverContext ctx, String name, Integer defaultValue, boolean alwaysDrive, IntConsumer driver) {
        boolean dynamic;
        Supplier<OptionalInt> parsed = ComDrivers.readColor(ctx, name);
        OptionalInt fallback = defaultValue != null ? OptionalInt.of(defaultValue) : OptionalInt.empty();
        boolean bl = dynamic = alwaysDrive || !ComDrivers.isConstant(parsed);
        if (dynamic) {
            ctx.onPreRender((time, mouse) -> ((OptionalInt)parsed.get()).ifPresentOrElse(driver, () -> fallback.ifPresent(driver)));
        }
        parsed.get().ifPresentOrElse(driver, () -> fallback.ifPresent(driver));
        return dynamic;
    }

    @NotNull
    public static Supplier<Component> readComponent(DriverContext ctx, String from) {
        Callback3 cbq;
        String str = ctx.getString(from);
        if (str == null || str.isBlank()) {
            return Cast.constant(Component.m_237119_());
        }
        Callback3 callback3 = cbq = JsContext.isScript(str) ? ctx.eval(Callback3.class, str, CBQ_RET_SPEC) : null;
        if (cbq != null) {
            return () -> {
                try {
                    Component com;
                    Object s = cbq.invoke(ctx.query(), ctx.self(), null);
                    if (s instanceof ScriptObjectMirror) {
                        ScriptObjectMirror som = (ScriptObjectMirror)s;
                        s = ObjectMirrorConverter.toGson(som);
                    }
                    return s instanceof Component ? (com = (Component)s) : ComDrivers.componentFromString(Objects.toString(s));
                }
                catch (Exception e) {
                    return Component.m_237113_((String)("Error: " + e)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED));
                }
            };
        }
        return Cast.constant(ComDrivers.componentFromString(str));
    }

    @NotNull
    public static Supplier<List<Component>> readComponents(DriverContext ctx, String from) {
        Callback3 cbq;
        String str = ctx.getString(from);
        if (str == null || str.isBlank()) {
            return Cast.constant(List.of());
        }
        Callback3 callback3 = cbq = JsContext.isScript(str) ? ctx.eval(Callback3.class, str, CBQ_RET_SPEC) : null;
        if (cbq != null) {
            return () -> {
                try {
                    List<Component> list;
                    Object s = cbq.invoke(ctx.query(), ctx.self(), null);
                    if (s instanceof ScriptObjectMirror) {
                        ScriptObjectMirror som = (ScriptObjectMirror)s;
                        s = ObjectMirrorConverter.toGson(som);
                    }
                    if (s instanceof Component[]) {
                        Component[] coms = (Component[])s;
                        list = List.of(coms);
                    } else if (s instanceof Component) {
                        Component com = (Component)s;
                        list = List.of(com);
                    } else {
                        list = ComDrivers.componentsFromString(Objects.toString(s));
                    }
                    return list;
                }
                catch (Exception e) {
                    return List.of(Component.m_237113_((String)("Error: " + e)).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
                }
            };
        }
        return Cast.constant(ComDrivers.componentsFromString(str));
    }

    @NotNull
    public static Supplier<String> readString(DriverContext ctx, String from) {
        Callback3 cbq;
        String str = ctx.getString(from);
        if (str == null || str.isBlank()) {
            return Cast.constant("");
        }
        Callback3 callback3 = cbq = JsContext.isScript(str) ? ctx.eval(Callback3.class, str, CBQ_RET_SPEC) : null;
        if (cbq != null) {
            return () -> {
                try {
                    String string;
                    Object s = cbq.invoke(ctx.query(), ctx.self(), null);
                    if (s instanceof CharSequence) {
                        CharSequence com = (CharSequence)s;
                        string = com.toString();
                    } else {
                        string = Objects.toString(s);
                    }
                    return string;
                }
                catch (Exception e) {
                    return e.toString();
                }
            };
        }
        return Cast.constant(str);
    }

    @NotNull
    public static <T> Supplier<T> readObject(DriverContext ctx, String from, Class<T> returnType) {
        Callback3 cbq;
        String str = ctx.getString(from);
        if (str == null || str.isBlank()) {
            return Cast.constant(null);
        }
        Callback3 callback3 = cbq = JsContext.isScript(str) ? ctx.eval(Callback3.class, str, CBQ_RET_SPEC) : null;
        if (cbq != null) {
            return () -> {
                try {
                    Object s = cbq.invoke(ctx.query(), ctx.self(), null);
                    return returnType.isInstance(s) ? s : ObjectMirrorConverter.unwrap(s, returnType);
                }
                catch (Exception e) {
                    return null;
                }
            };
        }
        return Cast.constant(null);
    }

    public static Component componentFromString(String str) {
        try {
            return Component.Serializer.m_130701_((String)str);
        }
        catch (Exception exception) {
            return Component.m_237115_((String)str);
        }
    }

    public static List<Component> componentsFromString(String str) {
        try {
            JsonElement t = (JsonElement)GSON.fromJson(str, JsonElement.class);
            if (t instanceof JsonArray) {
                JsonArray arr = (JsonArray)t;
                ArrayList<Component> coms = new ArrayList<Component>(arr.size());
                for (int i = 0; i < arr.size(); ++i) {
                    coms.add((Component)Component.Serializer.m_130691_((JsonElement)arr.get(i)));
                }
                return coms;
            }
            return List.of((Component)MoreObjects.firstNonNull((Object)Component.Serializer.m_130691_((JsonElement)t), (Object)Component.m_237119_()));
        }
        catch (Exception exception) {
            return List.of(Component.m_237115_((String)str));
        }
    }

    @NotNull
    public static Supplier<OptionalBoolean> readBoolean(DriverContext ctx, String from) {
        String expression = ctx.getString(from);
        if ("true".equalsIgnoreCase(expression) || "false".equalsIgnoreCase(expression)) {
            return Cast.constant(OptionalBoolean.of(Boolean.parseBoolean(expression)));
        }
        if (expression == null) {
            return Cast.constant(OptionalBoolean.empty());
        }
        String str = ctx.getString(from);
        if (str == null) {
            return Cast.constant(OptionalBoolean.empty());
        }
        BoolCallback3 cbq = ctx.eval(BoolCallback3.class, str, CBQ_RET_SPEC);
        if (cbq == null) {
            return Cast.constant(OptionalBoolean.empty());
        }
        return () -> {
            try {
                return OptionalBoolean.of(cbq.invoke(ctx.query(), ctx.self(), null));
            }
            catch (Exception e) {
                return OptionalBoolean.empty();
            }
        };
    }

    @NotNull
    public static Supplier<OptionalFloat> readFloat(DriverContext ctx, String from) {
        OptionalFloat of = ctx.getFloat(from);
        if (of.isPresent()) {
            return Cast.constant(of);
        }
        String str = ctx.getString(from);
        if (str == null) {
            return Cast.constant(OptionalFloat.empty());
        }
        DoubleCallback3 cbq = ctx.eval(DoubleCallback3.class, str, CBQ_RET_SPEC);
        if (cbq == null) {
            return Cast.constant(OptionalFloat.empty());
        }
        return () -> {
            try {
                return OptionalFloat.of((float)cbq.invoke(ctx.query(), ctx.self(), null));
            }
            catch (Exception e) {
                return OptionalFloat.empty();
            }
        };
    }

    @NotNull
    public static Supplier<OptionalInt> readInt(DriverContext ctx, String from) {
        OptionalInt of = ctx.getInt(from);
        if (of.isPresent()) {
            return Cast.constant(of);
        }
        String str = ctx.getString(from);
        if (str == null) {
            return Cast.constant(OptionalInt.empty());
        }
        IntCallback3 cbq = ctx.eval(IntCallback3.class, str, CBQ_RET_SPEC);
        if (cbq == null) {
            return Cast.constant(OptionalInt.empty());
        }
        return () -> {
            try {
                return OptionalInt.of(cbq.invoke(ctx.query(), ctx.self(), null));
            }
            catch (Exception e) {
                return OptionalInt.empty();
            }
        };
    }

    @NotNull
    public static Supplier<OptionalInt> readColor(DriverContext ctx, String from) {
        OptionalInt of = ctx.getInt(from);
        if (of.isPresent()) {
            return Cast.constant(of);
        }
        String str = ctx.getString(from);
        if (str == null || str.isBlank()) {
            return Cast.constant(OptionalInt.empty());
        }
        if (str != null && str.matches("^#[a-fA-F0-9]{1,6}$")) {
            return Cast.constant(OptionalInt.of(Integer.parseInt(str.substring(1), 16)));
        }
        IntCallback3 cbq = ctx.eval(IntCallback3.class, str, CBQ_RET_SPEC);
        if (cbq == null) {
            return Cast.constant(OptionalInt.empty());
        }
        return () -> {
            try {
                return OptionalInt.of(cbq.invoke(ctx.query(), ctx.self(), null));
            }
            catch (Exception e) {
                return OptionalInt.empty();
            }
        };
    }

    public static Runnable readCallback(DriverContext ctx, String from, boolean returns) {
        return ComDrivers.readCallback(ctx, from, returns, null);
    }

    public static Runnable readCallback(DriverContext ctx, String from, boolean returns, Object thirdParam) {
        String expression = ctx.getString(from);
        if (expression == null || expression.isBlank()) {
            return () -> {};
        }
        Callback3 cbq = ctx.eval(Callback3.class, expression, returns ? CBQ_RET_SPEC : CBQ_SPEC);
        if (cbq == null) {
            return () -> {};
        }
        return () -> {
            try {
                cbq.invoke(ctx.query(), ctx.self(), thirdParam);
            }
            catch (RuntimeException e) {
                log.error("Failed to invoke callback {} (code: {})", (Object)ComDrivers.readableName(ctx.attributes()), (Object)expression);
            }
        };
    }

    public static String readableName(IDataNode node) {
        Set<String> keys = node.keys();
        return "<%s %s %s/>".formatted(node.getMyName(), keys.contains("class") ? "class=%s".formatted(JSONObject.quote(node.getString("class"))) : "", keys.contains("id") ? "id=%s".formatted(JSONObject.quote(node.getString("id"))) : "").trim();
    }

    public static boolean isConstant(Object supplier) {
        return supplier != null && supplier.getClass().getName().startsWith(CAST_NAME);
    }
}

