/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.processing.recipe;

import com.simibubi.create.Create;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.createmod.catnip.lang.Lang;

public enum HeatCondition {
    NONE(0xFFFFFF),
    HEATED(15237888),
    SUPERHEATED(6067176);

    private int color;

    private HeatCondition(int color) {
        this.color = color;
    }

    public boolean testBlazeBurner(BlazeBurnerBlock.HeatLevel level) {
        if (this == SUPERHEATED) {
            return level == BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        if (this == HEATED) {
            return level != BlazeBurnerBlock.HeatLevel.NONE && level != BlazeBurnerBlock.HeatLevel.SMOULDERING;
        }
        return true;
    }

    public BlazeBurnerBlock.HeatLevel visualizeAsBlazeBurner() {
        if (this == SUPERHEATED) {
            return BlazeBurnerBlock.HeatLevel.SEETHING;
        }
        if (this == HEATED) {
            return BlazeBurnerBlock.HeatLevel.KINDLED;
        }
        return BlazeBurnerBlock.HeatLevel.NONE;
    }

    public String serialize() {
        return Lang.asId((String)this.name());
    }

    public String getTranslationKey() {
        return "recipe.heat_requirement." + this.serialize();
    }

    public static HeatCondition deserialize(String name) {
        for (HeatCondition heatCondition : HeatCondition.values()) {
            if (!heatCondition.serialize().equals(name)) continue;
            return heatCondition;
        }
        Create.LOGGER.warn("Tried to deserialize invalid heat condition: \"" + name + "\"");
        return NONE;
    }

    public int getColor() {
        return this.color;
    }
}

