/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.annotation;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.LytErrorSink;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstAnyContent;
import guideme.scene.GuidebookScene;
import guideme.scene.annotation.AnnotationTagCompiler;
import guideme.scene.element.SceneElementTagCompiler;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public class BlockAnnotationTemplateElementCompiler
implements SceneElementTagCompiler {
    @Override
    public Set<String> getTagNames() {
        return Set.of("BlockAnnotationTemplate");
    }

    @Override
    public void compile(GuidebookScene scene, PageCompiler compiler, LytErrorSink errorSink, MdxJsxElementFields el) {
        Predicate<BlockState> predicate = MdxAttrs.getRequiredBlockStatePredicate(compiler, errorSink, el, "id");
        if (predicate == null) {
            return;
        }
        for (MdAstAnyContent mdAstAnyContent : el.children()) {
            if (!(mdAstAnyContent instanceof MdxJsxElementFields)) continue;
            MdxJsxElementFields childEl = (MdxJsxElementFields)((Object)mdAstAnyContent);
            String childTagName = childEl.name();
            AnnotationTagCompiler childCompiler = this.findCompiler(compiler, childTagName);
            if (childCompiler == null) {
                errorSink.appendError(compiler, "Element is not supported as an annotation template", mdAstAnyContent);
                continue;
            }
            Iterator it = scene.getFilledBlocks().iterator();
            while (it.hasNext()) {
                BlockPos position = (BlockPos)it.next();
                BlockState state = scene.getLevel().m_8055_(position);
                if (!predicate.test(state)) continue;
                childCompiler.compileTemplate(scene, compiler, errorSink, childEl, position);
            }
        }
    }

    private AnnotationTagCompiler findCompiler(PageCompiler compiler, String childTagName) {
        for (SceneElementTagCompiler sceneElementCompiler : compiler.getExtensions(SceneElementTagCompiler.EXTENSION_POINT)) {
            if (!(sceneElementCompiler instanceof AnnotationTagCompiler)) continue;
            AnnotationTagCompiler annotationTagCompiler = (AnnotationTagCompiler)sceneElementCompiler;
            for (String tagName : annotationTagCompiler.getTagNames()) {
                if (!Objects.equals(childTagName, tagName)) continue;
                return annotationTagCompiler;
            }
        }
        return null;
    }
}

