/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.workers;

import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.PregenTaskQueue;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.PrinterSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.SaverSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.WorldWorkerManager;
import org.jetbrains.annotations.NotNull;

public class PregenWorker
implements WorldWorkerManager.IWorker {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final PregenTaskQueue queue;
    @NotNull
    private final PrinterSubTask printer;
    @NotNull
    private final SaverSubTask saver;
    private MinecraftServer server;
    private boolean startingNewTask = true;

    public PregenWorker(@NotNull ServerConfig _serverConfig) {
        this.serverConfig = _serverConfig;
        this.queue = new PregenTaskQueue();
        this.printer = new PrinterSubTask(this.serverConfig, this.queue);
        this.saver = new SaverSubTask(this.serverConfig, this.printer);
    }

    public void setServer(@NotNull MinecraftServer _server) {
        this.server = _server;
        this.queue.setServer(this.server);
        this.printer.setServer(this.server);
        this.saver.setServer(this.server);
    }

    public boolean hasWork() {
        return true;
    }

    public boolean doWork() {
        Optional<PregenTask> next_task = this.queue.getCurrentTask();
        if (next_task.isPresent()) {
            PregenTask task = next_task.get();
            if (this.startingNewTask) {
                this.startingNewTask = false;
                this.server.m_6846_().m_240416_((Component)Component.m_237113_((String)String.format("Generation of %s started.", DimensionHelper.getNameOfDim(task.getDimension()))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))), false);
                this.printer.start();
                this.saver.start();
            }
            boolean finished = task.generate(this.server, this.serverConfig);
            this.printer.run();
            this.saver.run();
            if (finished) {
                this.printer.stop();
                this.saver.stop();
                this.printer.execute();
                this.server.m_6846_().m_240416_((Component)Component.m_237113_((String)String.format("Generation of %s finished.", DimensionHelper.getNameOfDim(task.getDimension()))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))), false);
                this.saver.execute();
                this.queue.removeCurrentTask();
                this.startingNewTask = true;
                return this.queue.isNotEmpty();
            }
            return true;
        }
        return false;
    }

    @NotNull
    public PregenTaskQueue getQueue() {
        return this.queue;
    }

    public void clearUp() {
        this.queue.clearUp();
        this.startingNewTask = true;
        this.printer.stop();
        this.saver.stop();
    }
}

