/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen;

import com.google.gson.JsonObject;
import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.TaskType;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPregenData;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import de.geheimagentnr1.world_pre_generator.helpers.JsonHelper;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.jetbrains.annotations.NotNull;

public class PregenTask
implements Savable<JsonObject> {
    @NotNull
    private static final String taskTypeName = "type";
    @NotNull
    private static final String centerXName = "center_x";
    @NotNull
    private static final String centerZName = "center_z";
    @NotNull
    private static final String radiusName = "radius";
    @NotNull
    private static final String chunkIndexName = "chunk_index";
    @NotNull
    private static final String dimensionName = "dimension";
    private TaskType taskType;
    private int centerX;
    private int centerZ;
    private int radius;
    private boolean forceGeneration;
    private ResourceKey<Level> dimension;
    private boolean canceled = false;
    private WorldPregenData worldPregenData;
    private long generated_chunks_count;
    private ThreadPoolExecutor executor;

    public PregenTask(@NotNull TaskType _taskType, @NotNull WorldPos center, int _radius, @NotNull ResourceKey<Level> _dimension, boolean _forceGeneration) {
        this.taskType = _taskType;
        this.centerX = center.getX();
        this.centerZ = center.getZ();
        this.radius = _radius;
        this.dimension = _dimension;
        this.forceGeneration = _forceGeneration;
        this.worldPregenData = new WorldPregenData(this.centerX, this.centerZ, this.radius);
    }

    public PregenTask() {
    }

    public boolean generate(@NotNull MinecraftServer server, @NotNull ServerConfig serverConfig) {
        if (this.canceled) {
            return true;
        }
        switch (serverConfig.getGenerationType()) {
            case SERIAL: {
                this.worldPregenData.nextChunk().ifPresent(currentPos -> {
                    if (this.shouldBeGenerated(server, (WorldPos)currentPos)) {
                        this.generate(server, (WorldPos)currentPos);
                    } else {
                        this.incGeneratedChunksCount();
                    }
                });
                break;
            }
            case SEMI_PARALLEL: {
                if (this.executor == null || this.executor.isShutdown()) {
                    this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(serverConfig.getGenerationSemiParallelTaskCount());
                }
                if ((long)serverConfig.getGenerationSemiParallelTaskCount() << 1 <= this.executor.getTaskCount() - this.executor.getCompletedTaskCount()) break;
                this.worldPregenData.nextChunk().ifPresent(currentPos -> {
                    if (this.shouldBeGenerated(server, (WorldPos)currentPos)) {
                        this.executor.submit(() -> {
                            try {
                                this.generate(server, (WorldPos)currentPos);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    } else {
                        this.incGeneratedChunksCount();
                    }
                });
            }
        }
        return this.getGeneratedChunksCount() >= this.getChunkCount();
    }

    private boolean shouldBeGenerated(@NotNull MinecraftServer server, @NotNull WorldPos pos) {
        ServerLevel serverLevel = Objects.requireNonNull(server.m_129880_(this.dimension));
        return this.forceGeneration || !serverLevel.m_7232_(pos.getX(), pos.getZ()) && Optional.ofNullable(serverLevel.m_6522_(pos.getX(), pos.getZ(), ChunkStatus.f_62314_, true)).stream().noneMatch(chunk -> chunk.m_6415_().m_62427_(ChunkStatus.f_62326_));
    }

    private void generate(@NotNull MinecraftServer server, @NotNull WorldPos pos) {
        Objects.requireNonNull(server.m_129880_(this.dimension)).m_7726_().m_7587_(pos.getX(), pos.getZ(), ChunkStatus.f_62326_, true);
        this.incGeneratedChunksCount();
    }

    public void cancel() {
        this.canceled = true;
    }

    @Override
    @NotNull
    public JsonObject write() {
        JsonObject compound = new JsonObject();
        compound.addProperty(taskTypeName, this.taskType.name());
        compound.addProperty(centerXName, (Number)this.centerX);
        compound.addProperty(centerZName, (Number)this.centerZ);
        compound.addProperty(radiusName, (Number)this.radius);
        compound.addProperty(dimensionName, DimensionHelper.getNameOfDim(this.dimension));
        compound.addProperty(chunkIndexName, (Number)this.getGeneratedChunksCount());
        return compound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(@NotNull JsonObject json) {
        if (json.has(taskTypeName)) {
            if (!JsonHelper.isString(json, taskTypeName)) throw new IllegalArgumentException("Invalid type value.");
            this.taskType = TaskType.valueOf(JsonHelper.getString(json, taskTypeName));
        } else {
            this.taskType = TaskType.CHUNK;
        }
        if (!JsonHelper.isInt(json, centerXName)) {
            throw new IllegalArgumentException("Invalid center x value.");
        }
        this.centerX = JsonHelper.getInt(json, centerXName);
        if (!JsonHelper.isInt(json, centerZName)) {
            throw new IllegalArgumentException("Invalid center z value.");
        }
        this.centerZ = JsonHelper.getInt(json, centerZName);
        if (!JsonHelper.isInt(json, radiusName)) {
            throw new IllegalArgumentException("Invalid radius value.");
        }
        this.radius = JsonHelper.getInt(json, radiusName);
        if (!JsonHelper.isString(json, dimensionName)) throw new IllegalArgumentException("Invalid dimension value.");
        try {
            this.dimension = DimensionHelper.getDimFromName(JsonHelper.getString(json, dimensionName));
        }
        catch (ResourceLocationException exception) {
            throw new IllegalArgumentException("Invalid dimension resource location.", exception);
        }
        this.worldPregenData = new WorldPregenData(this.centerX, this.centerZ, this.radius);
        if (!JsonHelper.isInt(json, chunkIndexName)) {
            throw new IllegalArgumentException("Invalid chunk index value.");
        }
        this.worldPregenData.setChunkIndex(JsonHelper.getInt(json, chunkIndexName));
        this.setGeneratedChunksCount(this.worldPregenData.getChunkIndex());
    }

    public boolean isDimensionInvalid(@NotNull MinecraftServer server) {
        return server.m_129880_(this.dimension) == null;
    }

    private synchronized void incGeneratedChunksCount() {
        ++this.generated_chunks_count;
    }

    private synchronized void setGeneratedChunksCount(long _generated_chunks_count) {
        this.generated_chunks_count = _generated_chunks_count;
    }

    private synchronized long getGeneratedChunksCount() {
        return this.generated_chunks_count;
    }

    public long getChunkIndex() {
        return this.getGeneratedChunksCount();
    }

    public long getChunkCount() {
        return this.worldPregenData.getChunkCount();
    }

    public long getProgress() {
        return this.getGeneratedChunksCount() * 100L / this.getChunkCount();
    }

    public void shutdown() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public int getCenterZ() {
        return this.centerZ;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isForceGeneration() {
        return this.forceGeneration;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }
}

