/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks;

import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.PrinterSubTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.TimedSubTask;
import de.geheimagentnr1.world_pre_generator.helpers.SaveHelper;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class SaverSubTask
extends TimedSubTask {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final PrinterSubTask printer;
    private MinecraftServer server;

    @Override
    int getDelay() {
        return this.serverConfig.getSaveDelay();
    }

    @Override
    public void execute() {
        this.printer.pause();
        SaveHelper.saveWorld(this.server);
        System.gc();
        this.printer.resume();
    }

    public void setServer(@NotNull MinecraftServer _server) {
        this.server = _server;
    }

    public SaverSubTask(@NotNull ServerConfig serverConfig, @NotNull PrinterSubTask printer) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        if (printer == null) {
            throw new NullPointerException("printer is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
        this.printer = printer;
    }
}

