/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks;

import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.PregenTaskQueue;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.TimedSubTask;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class PrinterSubTask
extends TimedSubTask {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final PregenTaskQueue queue;
    private MinecraftServer server;
    private LocalDateTime old_time;
    private long old_chunks;

    @Override
    public void start() {
        super.start();
        this.old_time = LocalDateTime.now();
        this.old_chunks = 0L;
    }

    @Override
    public void resume() {
        super.resume();
        this.old_time = LocalDateTime.now();
    }

    @Override
    int getDelay() {
        return this.serverConfig.getPrintDelay();
    }

    @Override
    public void execute() {
        this.queue.getCurrentTask().ifPresent(task -> {
            LocalDateTime new_time = LocalDateTime.now();
            long duration = Duration.between(this.old_time, new_time).getSeconds();
            MutableComponent message = Component.m_237113_((String)String.format("pregen %s %d/%d(%d%%) %d chunks/s", DimensionHelper.getNameOfDim(task.getDimension()), task.getChunkIndex(), task.getChunkCount(), task.getProgress(), Math.max(0L, task.getChunkIndex() - this.old_chunks) / (duration == 0L ? 1L : duration))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
            if (this.serverConfig.isSendFeedbackEnabled()) {
                this.server.m_6846_().m_240416_((Component)message, false);
            } else {
                this.server.m_213846_((Component)message);
            }
            this.old_time = new_time;
            this.old_chunks = task.getChunkIndex();
        });
    }

    public void setServer(@NotNull MinecraftServer _server) {
        this.server = _server;
    }

    public PrinterSubTask(@NotNull ServerConfig serverConfig, @NotNull PregenTaskQueue queue) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
        this.queue = queue;
    }
}

