/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.minecraft_forge_api.elements.commands.CommandInterface;
import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.commands.models.TaskRow;
import de.geheimagentnr1.world_pre_generator.elements.commands.models.TasksMessage;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.TaskType;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.workers.PregenWorker;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.SectionPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PregenCommand
implements CommandInterface {
    @NotNull
    private final ServerConfig serverConfig;
    @NotNull
    private final PregenWorker pregenWorker;

    @NotNull
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        LiteralArgumentBuilder pregenCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"pregen").requires(source -> source.m_6761_(2));
        pregenCommand.then(Commands.m_82127_((String)"clear").executes(this::clear));
        LiteralArgumentBuilder startCommand = Commands.m_82127_((String)"start");
        for (TaskType taskType : TaskType.values()) {
            startCommand.then(Commands.m_82127_((String)taskType.m_7912_()).then(Commands.m_82129_((String)"center", (ArgumentType)ColumnPosArgument.m_118989_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> this.start((CommandContext<CommandSourceStack>)context, taskType, false))).then(Commands.m_82129_((String)"force", (ArgumentType)BoolArgumentType.bool()).executes(context -> this.start((CommandContext<CommandSourceStack>)context, taskType, true))))));
        }
        pregenCommand.then(Commands.m_82127_((String)"gen").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then(Commands.m_82127_((String)"cancel").executes(this::cancel))).then(Commands.m_82127_((String)"pause").executes(this::pause))).then(Commands.m_82127_((String)"resume").executes(this::resume))).then((ArgumentBuilder)startCommand)));
        pregenCommand.then(Commands.m_82127_((String)"list").executes(this::printList));
        pregenCommand.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sendFeedback").executes(this::showSendFeedback)).then(Commands.m_82129_((String)"isFeedbackEnabled", (ArgumentType)BoolArgumentType.bool()).executes(this::setSendFeedback)));
        return pregenCommand;
    }

    private int printList(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (this.pregenWorker.getQueue().noTasks()) {
            source.m_288197_(() -> Component.m_237113_((String)"Pregeneration Tasklist is empty."), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"Pregeneration Tasklist:"), false);
            ArrayList<PregenTask> activeTasks = this.pregenWorker.getQueue().getActiveTasks();
            ArrayList<PregenTask> pausedTasks = this.pregenWorker.getQueue().getPausedTasks();
            if (!activeTasks.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"Queued Tasks:"), false);
                this.printTasks(source, activeTasks);
            }
            if (!pausedTasks.isEmpty()) {
                source.m_288197_(() -> Component.m_237113_((String)"Paused Tasks:"), false);
                this.printTasks(source, pausedTasks);
            }
        }
        return 1;
    }

    private void printTasks(@NotNull CommandSourceStack source, @NotNull ArrayList<PregenTask> tasks) {
        TasksMessage tasksMessage = new TasksMessage();
        tasksMessage.add(new TaskRow("Dimension", "Type", "Center", null, null, "Radius", "Forced"));
        tasksMessage.addAll(tasks);
        for (String message : tasksMessage.buildMessages()) {
            source.m_288197_(() -> Component.m_237113_((String)message), false);
        }
    }

    private int start(@NotNull CommandContext<CommandSourceStack> context, @NotNull TaskType taskType, boolean checkForced) throws CommandSyntaxException {
        int chunkZ;
        int chunkX;
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ColumnPos center = ColumnPosArgument.m_118992_(context, (String)"center");
        int radius = IntegerArgumentType.getInteger(context, (String)"radius");
        int chunkRadius = switch (taskType) {
            case TaskType.BLOCK -> {
                ChunkPos chunkCenter = center.m_143196_();
                chunkX = chunkCenter.f_45578_;
                chunkZ = chunkCenter.f_45579_;
                yield SectionPos.m_123171_((int)radius);
            }
            case TaskType.CHUNK -> {
                chunkX = center.f_140723_();
                chunkZ = center.f_140724_();
                yield radius;
            }
            default -> throw new IllegalArgumentException("Invalid task type");
        };
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        boolean force = checkForced && BoolArgumentType.getBool(context, (String)"force");
        this.pregenWorker.getQueue().startTask(new PregenTask(taskType, new WorldPos(chunkX, chunkZ), chunkRadius, (ResourceKey<Level>)dimension, force));
        source.m_288197_(() -> Component.m_237113_((String)String.format("Task for %s got queued.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int resume(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        this.pregenWorker.getQueue().resumeTask((ResourceKey<Level>)dimension);
        source.m_288197_(() -> Component.m_237113_((String)String.format("Task for %s was resumed.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int pause(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        this.pregenWorker.getQueue().pauseTask((ResourceKey<Level>)dimension);
        source.m_288197_(() -> Component.m_237113_((String)String.format("Task for %s was paused.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int cancel(@NotNull CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        this.pregenWorker.getQueue().cancelTask((ResourceKey<Level>)dimension);
        source.m_288197_(() -> Component.m_237113_((String)String.format("Task for %s was canceled.", DimensionHelper.getNameOfDim((ResourceKey<Level>)dimension))), true);
        return 1;
    }

    private int clear(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        this.pregenWorker.getQueue().clear();
        source.m_288197_(() -> Component.m_237113_((String)"All Task were canceled."), true);
        return 1;
    }

    private int showSendFeedback(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (this.serverConfig.isSendFeedbackEnabled()) {
            source.m_288197_(() -> Component.m_237113_((String)"Feedback is enabled."), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"Feedback is disabled."), false);
        }
        return 1;
    }

    private int setSendFeedback(@NotNull CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        this.serverConfig.setSendFeedback(BoolArgumentType.getBool(context, (String)"isFeedbackEnabled"));
        if (this.serverConfig.isSendFeedbackEnabled()) {
            source.m_288197_(() -> Component.m_237113_((String)"Feedback is now enabled."), false);
        } else {
            source.m_288197_(() -> Component.m_237113_((String)"Feedback is now disabled."), false);
        }
        return 1;
    }

    public PregenCommand(@NotNull ServerConfig serverConfig, @NotNull PregenWorker pregenWorker) {
        if (serverConfig == null) {
            throw new NullPointerException("serverConfig is marked non-null but is null");
        }
        if (pregenWorker == null) {
            throw new NullPointerException("pregenWorker is marked non-null but is null");
        }
        this.serverConfig = serverConfig;
        this.pregenWorker = pregenWorker;
    }
}

