/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.config;

import appeng.core.config.BaseOption;
import appeng.core.config.ConfigSection;
import appeng.core.config.ConfigValidationException;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;

public class BooleanOption
extends BaseOption {
    private final boolean defaultValue;
    private boolean currentValue;

    public BooleanOption(ConfigSection parent, String id, String comment, boolean defaultValue) {
        super(parent, id, comment);
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
    }

    public boolean get() {
        return this.currentValue;
    }

    public void set(boolean value) {
        if (value == this.currentValue) {
            return;
        }
        this.currentValue = value;
        this.parent.markDirty();
    }

    @Override
    protected JsonElement write() {
        return new JsonPrimitive(Boolean.valueOf(this.currentValue));
    }

    @Override
    protected void read(JsonElement element) {
        if (!element.isJsonPrimitive()) {
            throw new ConfigValidationException(this, "Expected a JSON primitive, but found: " + String.valueOf(element));
        }
        JsonPrimitive primitive = element.getAsJsonPrimitive();
        if (!primitive.isBoolean()) {
            throw new ConfigValidationException(this, "Expected a JSON boolean, but found: " + String.valueOf(primitive));
        }
        this.currentValue = primitive.getAsBoolean();
    }

    @Override
    public boolean isDifferentFromDefault() {
        return this.currentValue != this.defaultValue;
    }

    @Override
    public String getDefaultAsString() {
        return String.valueOf(this.defaultValue);
    }

    @Override
    public String getCurrentValueAsString() {
        return String.valueOf(this.currentValue);
    }
}

