/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.shorts.Short2BooleanMap;
import it.unimi.dsi.fastutil.shorts.Short2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.config.FFConfig;

@Mixin(value={FlowingFluid.class})
public abstract class MixinFlowingFluid
extends Fluid {
    @Unique
    private static short ffCacheKey(BlockPos sourcePos, BlockPos spreadPos) {
        int i = spreadPos.m_123341_() - sourcePos.m_123341_();
        int j = spreadPos.m_123343_() - sourcePos.m_123343_();
        return (short)((i + 128 & 0xFF) << 8 | j + 128 & 0xFF);
    }

    @Unique
    private static boolean ff$handleWaterLoggedFlowAndReturnIfHandled(Level level, BlockPos posFrom, FluidState fluidState, int amount, BlockState thisState, BlockPos posTo, int destFluidAmount, boolean flowingDown) {
        boolean toIsWaterloggable;
        boolean fromIsWaterloggable;
        boolean bl = fromIsWaterloggable = thisState.m_60734_() instanceof LiquidBlockContainer && thisState.m_60734_() instanceof BucketPickup;
        if (fromIsWaterloggable && (flowingDown ? FlowingFluids.config.waterLogFlowMode.blocksFlowOutDown() : FlowingFluids.config.waterLogFlowMode.blocksFlowOutSides())) {
            return true;
        }
        Block blockTo = level.m_8055_(posTo).m_60734_();
        boolean bl2 = toIsWaterloggable = blockTo instanceof LiquidBlockContainer && blockTo instanceof BucketPickup;
        if (toIsWaterloggable && FlowingFluids.config.waterLogFlowMode.blocksFlowIn(flowingDown)) {
            return true;
        }
        if (fromIsWaterloggable || toIsWaterloggable) {
            int totalAmount = destFluidAmount + amount;
            if (totalAmount < 8) {
                return true;
            }
            if (toIsWaterloggable && fromIsWaterloggable) {
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posFrom, fluidState.m_76152_(), 0);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posTo, fluidState.m_76152_(), 8);
            } else if (toIsWaterloggable) {
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posFrom, fluidState.m_76152_(), totalAmount - 8);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posTo, fluidState.m_76152_(), 8);
            } else {
                if (destFluidAmount > 0) {
                    return true;
                }
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posFrom, fluidState.m_76152_(), 0);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posTo, fluidState.m_76152_(), 8);
            }
            return true;
        }
        return false;
    }

    protected boolean m_6685_() {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this)) {
            return true;
        }
        return super.m_6685_();
    }

    protected void m_213812_(Level level, BlockPos pos, FluidState state, RandomSource random) {
        super.m_213812_(level, pos, state, random);
        if (FlowingFluids.config.enableMod && FlowingFluids.config.randomTickLevelingDistance > 0 && level.m_46745_(pos).m_183526_().m_183574_() < 16 && FlowingFluids.config.isFluidAllowed(this) && !level.m_6425_(pos.m_7494_()).m_76152_().m_6212_((Fluid)this)) {
            BiConsumer<BlockPos.MutableBlockPos, BlockPos.MutableBlockPos> move;
            int amount = state.m_76186_();
            if (amount <= this.m_6713_((LevelReader)level)) {
                return;
            }
            int amountLess = amount - 1;
            Direction randomDirection = FFFluidUtils.getCardinalsShuffle(level.m_213780_()).get(0);
            if (level.m_213780_().m_188499_()) {
                move = (mbp, up) -> {
                    mbp.m_122173_(randomDirection);
                    up.m_122173_(randomDirection);
                };
            } else {
                Direction offStep = level.m_213780_().m_188499_() ? randomDirection.m_122427_() : randomDirection.m_122428_();
                RandomSource rand = level.m_213780_();
                move = (mbp, up) -> {
                    Direction dir = rand.m_188499_() ? randomDirection : offStep;
                    mbp.m_122173_(dir);
                    up.m_122173_(dir);
                };
            }
            BlockPos.MutableBlockPos movingDir = pos.m_122032_();
            BlockPos.MutableBlockPos movingDirAbove = pos.m_7494_().m_122032_();
            for (int i = 0; i < FlowingFluids.config.randomTickLevelingDistance; ++i) {
                move.accept(movingDir, movingDirAbove);
                BlockState stateDir = level.m_8055_((BlockPos)movingDir);
                if (!(stateDir.m_60734_() instanceof LiquidBlock)) {
                    return;
                }
                FluidState fluidStateDir = stateDir.m_60819_();
                if (!fluidStateDir.m_76152_().m_6212_((Fluid)this)) {
                    return;
                }
                if (level.m_6425_((BlockPos)movingDirAbove).m_76152_().m_6212_((Fluid)this)) {
                    return;
                }
                int amountDir = fluidStateDir.m_76186_();
                if (amountDir > amount) {
                    return;
                }
                if (amountDir >= amountLess) continue;
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, (BlockPos)movingDir, this, amountDir + 1);
                FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, pos, this, amountLess);
                return;
            }
        }
    }

    @Shadow
    protected abstract int m_6713_(LevelReader var1);

    @Shadow
    protected abstract void m_6364_(LevelAccessor var1, BlockPos var2, BlockState var3, Direction var4, FluidState var5);

    @Shadow
    protected abstract int m_6719_(LevelReader var1);

    @Shadow
    public abstract int m_7430_(FluidState var1);

    @Inject(method={"getOwnHeight"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$differentRenderHeight(FluidState state, CallbackInfoReturnable<Float> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(state) && FlowingFluids.config.fullLiquidHeight != FFConfig.LiquidHeight.REGULAR) {
            cir.setReturnValue((Object)(switch (FlowingFluids.config.fullLiquidHeight) {
                case FFConfig.LiquidHeight.BLOCK -> Float.valueOf((float)state.m_76186_() / 8.0f);
                case FFConfig.LiquidHeight.SLAB -> Float.valueOf((float)state.m_76186_() / 16.0f);
                case FFConfig.LiquidHeight.CARPET -> Float.valueOf(0.0625f);
                case FFConfig.LiquidHeight.REGULAR_LOWER_BOUND -> Float.valueOf(((float)state.m_76186_() - 0.9f) * 0.8888889f / 7.0f);
                case FFConfig.LiquidHeight.BLOCK_LOWER_BOUND -> Float.valueOf(((float)state.m_76186_() - 0.9f) / 7.0f);
                default -> Float.valueOf((float)state.m_76186_() / 9.0f);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void ff$tickMixin(Level level, BlockPos blockPos, FluidState fluidState, CallbackInfo ci) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(fluidState)) {
            ci.cancel();
            if (FlowingFluids.config.dontTickAtLocation(blockPos, (LevelAccessor)level)) {
                level.m_186469_(blockPos, (Fluid)this, 200 + level.f_46441_.m_188503_(200));
                return;
            }
            if (System.currentTimeMillis() < FlowingFluids.debug_killFluidUpdatesUntilTime) {
                return;
            }
            FlowingFluids.isManeuveringFluids = true;
            boolean withinInfBiomeHeights = FlowingFluids.config.fastBiomeRefillAtSeaLevelOnly ? level.m_5736_() == blockPos.m_123342_() || level.m_5736_() - 1 == blockPos.m_123342_() : level.m_5736_() == blockPos.m_123342_() && blockPos.m_123342_() > 0;
            boolean isWaterAndInfiniteBiome = fluidState.m_205070_(FluidTags.f_13131_) && withinInfBiomeHeights && FFFluidUtils.matchInfiniteBiomes((Holder<Biome>)level.m_204166_(blockPos)) && level.m_45517_(LightLayer.SKY, blockPos) > 0;
            boolean dontConsumeWater = isWaterAndInfiniteBiome && level.m_5736_() != blockPos.m_123342_() && level.m_213780_().m_188501_() < FlowingFluids.config.infiniteWaterBiomeNonConsumeChance;
            BlockState thisState = level.m_8055_(blockPos);
            try {
                Direction dir;
                it.unimi.dsi.fastutil.Pair<Integer, Runnable> remainder;
                FlowingFluid flow;
                FluidState aboveF;
                int aboveAmount;
                BlockPos abovePos;
                BlockState above;
                BlockPos posDown = blockPos.m_7495_();
                int remainingAmount = this.flowing_fluids$checkAndFlowDown(level, blockPos, fluidState, thisState, posDown, level.m_8055_(posDown), fluidState.m_76186_());
                if (remainingAmount <= 0) {
                    return;
                }
                if (fluidState.m_76186_() == 8 && thisState.m_278721_() && (above = level.m_8055_(abovePos = blockPos.m_7494_())).m_278721_() && (aboveAmount = (aboveF = above.m_60819_()).m_76186_()) > 0 && FFFluidUtils.canFluidFlowFromPosToDirectionFitOverride(flow = (FlowingFluid)aboveF.m_76152_(), (BlockGetter)level, abovePos, above, Direction.DOWN, blockPos, thisState) && (Integer)(remainder = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction((LevelAccessor)level, blockPos, aboveAmount, flow, 40, false, !FlowingFluids.pistonTick)).first() < aboveAmount) {
                    ((Runnable)remainder.second()).run();
                    if (!dontConsumeWater) {
                        FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, abovePos, (Fluid)flow, (Integer)remainder.first());
                    }
                    return;
                }
                if (remainingAmount > this.m_6713_((LevelReader)level)) {
                    this.ff$flowToSides(level, blockPos, fluidState, remainingAmount, thisState);
                } else if (FlowingFluids.config.flowToEdges && (dir = this.flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(level, blockPos, fluidState, 1, true)) != null) {
                    BlockPos pos = blockPos.m_121945_(dir);
                    this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, 0, thisState, dir);
                    this.flowing_fluids$spreadTo2((LevelAccessor)level, pos, level.m_8055_(pos), dir, remainingAmount);
                }
            }
            finally {
                if (isWaterAndInfiniteBiome) {
                    if (level.m_5736_() == blockPos.m_123342_()) {
                        FluidState below;
                        int amount;
                        if (level.m_213780_().m_188501_() < FlowingFluids.config.infiniteWaterBiomeDrainSurfaceChance && (amount = level.m_6425_(blockPos).m_76186_()) > 0 && (below = level.m_6425_(blockPos.m_7495_())).m_76186_() == 8 && below.m_205070_(FluidTags.f_13131_)) {
                            level.m_46597_(blockPos, FFFluidUtils.getBlockForFluidByAmount(this, amount - 1));
                        }
                    } else if (dontConsumeWater) {
                        level.m_7731_(blockPos, thisState, 0);
                    }
                }
                FlowingFluids.isManeuveringFluids = false;
                FlowingFluids.pistonTick = false;
            }
        }
    }

    @Unique
    private void ff$flowToSides(Level level, BlockPos blockPos, FluidState fluidState, int amount, BlockState thisState) {
        int destFluidAmount;
        Direction dir = this.flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(level, blockPos, fluidState, amount, false);
        if (dir == null) {
            return;
        }
        BlockPos posDir = blockPos.m_121945_(dir);
        if (MixinFlowingFluid.ff$handleWaterLoggedFlowAndReturnIfHandled(level, blockPos, fluidState, amount, thisState, posDir, destFluidAmount = level.m_6425_(posDir).m_76186_(), false)) {
            return;
        }
        int difference = amount - destFluidAmount;
        int averageLevel = destFluidAmount + difference / 2;
        boolean hasRemainder = difference % 2 != 0;
        int fromAmount = averageLevel;
        int toAmount = hasRemainder ? averageLevel + 1 : averageLevel;
        FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, blockPos, fluidState.m_76152_(), fromAmount);
        FFFluidUtils.setFluidStateAtPosToNewAmount((LevelAccessor)level, posDir, fluidState.m_76152_(), toAmount);
    }

    @Unique
    private int flowing_fluids$checkAndFlowDown(Level level, BlockPos blockPos, FluidState fluidState, BlockState thisState, BlockPos posDown, BlockState stateDown, int amount) {
        FluidState downFState = level.m_6425_(posDown);
        if (this.flowing_fluids$canSpreadTo(fluidState.m_76152_(), fluidState.m_76186_(), (BlockGetter)level, blockPos, thisState, Direction.DOWN, posDown, stateDown, downFState)) {
            BlockState block;
            if (!downFState.m_76178_() && !downFState.m_76152_().m_6212_(fluidState.m_76152_())) {
                this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, amount - 1, thisState, Direction.DOWN);
                this.flowing_fluids$spreadTo2((LevelAccessor)level, posDown, stateDown, Direction.DOWN, 1);
                return amount - 1;
            }
            if (FlowingFluids.config.easyPistonPump && FlowingFluids.config.enablePistonPushing && (block = level.m_8055_(posDown.m_7495_())).m_60713_(Blocks.f_50110_) && block.m_61143_((Property)DirectionalBlock.f_52588_) == Direction.UP) {
                level.m_186469_(blockPos, (Fluid)this, 10);
                FlowingFluids.pistonTick = true;
                return amount;
            }
            int fluidDownAmount = downFState.m_76186_();
            if (MixinFlowingFluid.ff$handleWaterLoggedFlowAndReturnIfHandled(level, blockPos, fluidState, amount, thisState, posDown, fluidDownAmount, true)) {
                return level.m_6425_(blockPos).m_76186_();
            }
            int amountDestCanAccept = Math.min(8 - fluidDownAmount, amount);
            if (amountDestCanAccept > 0) {
                int destNewAmount = fluidDownAmount + amountDestCanAccept;
                int sourceNewAmount = amount - amountDestCanAccept;
                this.flowing_fluids$setOrRemoveWaterAmountAt(level, blockPos, sourceNewAmount, thisState, Direction.DOWN);
                this.flowing_fluids$spreadTo2((LevelAccessor)level, posDown, stateDown, Direction.DOWN, destNewAmount);
                return sourceNewAmount;
            }
        }
        return amount;
    }

    @Unique
    private void flowing_fluids$setOrRemoveWaterAmountAt(Level level, BlockPos blockPos, int amount, BlockState thisState, Direction direction) {
        if (amount > 0) {
            this.flowing_fluids$spreadTo2((LevelAccessor)level, blockPos, thisState, direction, amount);
        } else {
            FFFluidUtils.removeAllFluidAtPos((LevelAccessor)level, blockPos, this);
        }
    }

    @Inject(method={"getNewLiquid"}, at={@At(value="HEAD")}, cancellable=true)
    private void flowing_fluids$validateLiquidMixin(Level level, BlockPos blockPos, BlockState blockState, CallbackInfoReturnable<FluidState> cir) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this)) {
            FluidState state = level.m_6425_(blockPos);
            cir.setReturnValue((Object)FFFluidUtils.getStateForFluidByAmount(state.m_76152_(), state.m_76186_()));
        }
    }

    @Unique
    @Nullable
    private Direction flowing_fluids$getLowestSpreadableLookingFor4BlockDrops(Level level, BlockPos blockPos, FluidState fluidState, int amount, boolean requiresSlope) {
        Short2ObjectOpenHashMap statesAtPos = new Short2ObjectOpenHashMap();
        AtomicBoolean anyFlowableNeighbours2LevelsLowerOrMore = new AtomicBoolean(requiresSlope);
        List<Direction> directionsCanSpreadToSortedByAmount = FFFluidUtils.getCardinalsShuffle(level.f_46441_).stream().sorted(Comparator.comparingInt(dir1 -> level.m_6425_(blockPos.m_121945_(dir1)).m_76186_())).filter(arg_0 -> this.lambda$flowing_fluids$getLowestSpreadableLookingFor4BlockDrops$3(blockPos, level, (Short2ObjectMap)statesAtPos, fluidState, amount, requiresSlope, anyFlowableNeighbours2LevelsLowerOrMore, arg_0)).toList();
        if (directionsCanSpreadToSortedByAmount.isEmpty()) {
            return null;
        }
        boolean requiresSlopeWithOverride = requiresSlope || !anyFlowableNeighbours2LevelsLowerOrMore.get();
        Direction spreadDirection = this.flowing_fluids$getValidDirectionFromDeepSpreadSearch(level, blockPos, fluidState, amount, requiresSlopeWithOverride, directionsCanSpreadToSortedByAmount, (Short2ObjectMap<Pair<BlockState, FluidState>>)statesAtPos);
        if (spreadDirection == null && !requiresSlopeWithOverride) {
            return directionsCanSpreadToSortedByAmount.get(0);
        }
        return spreadDirection;
    }

    @Unique
    @Nullable
    private Direction flowing_fluids$getValidDirectionFromDeepSpreadSearch(Level level, BlockPos blockPos, FluidState fluidState, int amount, boolean requiresSlope, List<Direction> directionsCanSpreadToSortedByAmount, Short2ObjectMap<Pair<BlockState, FluidState>> statesAtPos) {
        int slopeFindDistance = this.m_6719_((LevelReader)level);
        if (slopeFindDistance < 1) {
            return null;
        }
        Short2BooleanOpenHashMap posCanFlowDown = new Short2BooleanOpenHashMap();
        posCanFlowDown.put(MixinFlowingFluid.ffCacheKey(blockPos, blockPos), false);
        return directionsCanSpreadToSortedByAmount.stream().map(arg_0 -> this.lambda$flowing_fluids$getValidDirectionFromDeepSpreadSearch$4(blockPos, level, amount, (Short2BooleanMap)posCanFlowDown, fluidState, requiresSlope, statesAtPos, slopeFindDistance, arg_0)).filter(pair -> !requiresSlope || (Integer)pair.getSecond() <= slopeFindDistance).min(Comparator.comparingInt(Pair::getSecond)).map(Pair::getFirst).orElse(null);
    }

    @Unique
    protected int flowing_fluids$getSlopeDistance(LevelReader level, BlockPos sourcePosForKey, int distance, Direction fromDir, Fluid sourceFluid, int sourceAmount, BlockPos newPos, Short2ObjectMap<Pair<BlockState, FluidState>> statesAtPos, Short2BooleanMap posCanFlowDown, boolean forceSlopeDownSameOrEmpty, int slopeFindDistance) {
        int smallest = 1000;
        int searchDistance = distance + 1;
        for (Direction searchDir : Direction.Plane.HORIZONTAL) {
            int next;
            if (searchDir == fromDir) continue;
            BlockPos searchPos = newPos.m_121945_(searchDir);
            short searchKey = MixinFlowingFluid.ffCacheKey(sourcePosForKey, searchPos);
            Pair<BlockState, FluidState> searchStates = this.flowing_fluids$getSetPosCache(searchKey, level, statesAtPos, searchPos);
            if (!this.flowing_fluids$canSpreadToOptionallySameOrEmpty(sourceFluid, sourceAmount, (BlockGetter)level, newPos, level.m_8055_(newPos), searchDir, searchPos, (BlockState)searchStates.getFirst(), (FluidState)searchStates.getSecond(), forceSlopeDownSameOrEmpty)) continue;
            if (((FluidState)searchStates.getSecond()).m_76186_() < sourceAmount - 2 || this.flowing_fluids$getSetFlowDownCache(searchKey, level, posCanFlowDown, searchPos, sourceFluid, forceSlopeDownSameOrEmpty)) {
                return searchDistance;
            }
            if (searchDistance >= slopeFindDistance || (next = this.flowing_fluids$getSlopeDistance(level, sourcePosForKey, searchDistance, searchDir.m_122424_(), sourceFluid, sourceAmount, searchPos, statesAtPos, posCanFlowDown, forceSlopeDownSameOrEmpty, slopeFindDistance)) >= smallest) continue;
            smallest = next;
        }
        return smallest;
    }

    @Unique
    private Pair<BlockState, FluidState> flowing_fluids$getSetPosCache(short key, LevelReader level, Short2ObjectMap<Pair<BlockState, FluidState>> statesAtPos, BlockPos pos) {
        return (Pair)statesAtPos.computeIfAbsent(key, sx -> {
            BlockState blockState = level.m_8055_(pos);
            return Pair.of((Object)blockState, (Object)blockState.m_60819_());
        });
    }

    @Unique
    private boolean flowing_fluids$getSetFlowDownCache(short key, LevelReader level, Short2BooleanMap boolAtPos, BlockPos pos, Fluid sourceFluid, boolean forceSlopeDownSameOrEmpty) {
        return boolAtPos.computeIfAbsent(key, sx -> {
            BlockPos posDown = pos.m_7495_();
            return this.flowing_fluids$canSpreadToOptionallySameOrEmpty(sourceFluid, 8, (BlockGetter)level, pos, level.m_8055_(pos), Direction.DOWN, posDown, level.m_8055_(posDown), level.m_6425_(posDown), forceSlopeDownSameOrEmpty);
        });
    }

    @Unique
    protected void flowing_fluids$spreadTo2(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, Direction direction, int amount) {
        this.m_6364_(levelAccessor, blockPos, blockState, direction, FFFluidUtils.getStateForFluidByAmount(this, amount));
    }

    @Unique
    private boolean flowing_fluids$canSpreadToOptionallySameOrEmpty(Fluid sourceFluid, int sourceAmount, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState2, boolean enforceSameFluidOrEmpty) {
        if (enforceSameFluidOrEmpty && !fluidState2.m_76178_() && !fluidState2.m_76152_().m_6212_(sourceFluid)) {
            return false;
        }
        return this.flowing_fluids$canSpreadTo(sourceFluid, sourceAmount, blockGetter, blockPos, blockState, direction, blockPos2, blockState2, fluidState2);
    }

    @Unique
    private boolean flowing_fluids$canSpreadTo(Fluid sourceFluid, int sourceAmount, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState2) {
        return FFFluidUtils.canFluidFlowFromPosToDirection((FlowingFluid)sourceFluid, sourceAmount, blockGetter, blockPos, blockState, direction, blockPos2, blockState2, fluidState2);
    }

    private /* synthetic */ Pair lambda$flowing_fluids$getValidDirectionFromDeepSpreadSearch$4(BlockPos blockPos, Level level, int amount, Short2BooleanMap posCanFlowDown, FluidState fluidState, boolean requiresSlope, Short2ObjectMap statesAtPos, int slopeFindDistance, Direction dir) {
        BlockPos posDir = blockPos.m_121945_(dir);
        short key = MixinFlowingFluid.ffCacheKey(blockPos, posDir);
        if (level.m_6425_(posDir).m_76186_() < amount - 1 || this.flowing_fluids$getSetFlowDownCache(key, (LevelReader)level, posCanFlowDown, posDir, fluidState.m_76152_(), requiresSlope)) {
            return Pair.of((Object)dir, (Object)0);
        }
        return Pair.of((Object)dir, (Object)this.flowing_fluids$getSlopeDistance((LevelReader)level, blockPos, 1, dir.m_122424_(), fluidState.m_76152_(), amount + 1, posDir, (Short2ObjectMap<Pair<BlockState, FluidState>>)statesAtPos, posCanFlowDown, requiresSlope, slopeFindDistance));
    }

    private /* synthetic */ boolean lambda$flowing_fluids$getLowestSpreadableLookingFor4BlockDrops$3(BlockPos blockPos, Level level, Short2ObjectMap statesAtPos, FluidState fluidState, int amount, boolean requiresSlope, AtomicBoolean anyFlowableNeighbours2LevelsLowerOrMore, Direction dir) {
        BlockPos posDir = blockPos.m_121945_(dir);
        short key = MixinFlowingFluid.ffCacheKey(blockPos, posDir);
        Pair<BlockState, FluidState> statesDir = this.flowing_fluids$getSetPosCache(key, (LevelReader)level, (Short2ObjectMap<Pair<BlockState, FluidState>>)statesAtPos, posDir);
        BlockState stateDir = (BlockState)statesDir.getFirst();
        FluidState fluidStateDir = (FluidState)statesDir.getSecond();
        int amountDir = fluidStateDir.m_76186_();
        boolean canFlow = this.flowing_fluids$canSpreadToOptionallySameOrEmpty(fluidState.m_76152_(), amount, (BlockGetter)level, blockPos, level.m_8055_(blockPos), dir, posDir, stateDir, fluidStateDir, requiresSlope);
        if (canFlow && !anyFlowableNeighbours2LevelsLowerOrMore.get()) {
            anyFlowableNeighbours2LevelsLowerOrMore.set(amountDir < amount - 1);
        }
        return canFlow;
    }
}

