/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.mixin;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.flowing_fluids.FFBucketItem;
import traben.flowing_fluids.FFFluidUtils;
import traben.flowing_fluids.FlowingFluids;

@Mixin(value={BucketItem.class})
public abstract class MixinBucketItem
extends Item
implements FFBucketItem {
    @Shadow
    @Final
    private Fluid f_40687_;

    public MixinBucketItem(Item.Properties properties) {
        super(properties);
    }

    @Shadow
    public static ItemStack m_40699_(ItemStack itemStack, Player player) {
        return null;
    }

    @Shadow
    public abstract void m_142131_(@Nullable Player var1, Level var2, ItemStack var3, BlockPos var4);

    @Shadow
    protected abstract void m_7718_(@Nullable Player var1, LevelAccessor var2, BlockPos var3);

    @ModifyArg(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/BucketItem;getPlayerPOVHitResult(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/ClipContext$Fluid;)Lnet/minecraft/world/phys/BlockHitResult;"), index=2)
    private ClipContext.Fluid flowing_fluids$allowAnyFluid(ClipContext.Fluid par3) {
        if (FlowingFluids.config.enableMod && par3 == ClipContext.Fluid.SOURCE_ONLY) {
            return ClipContext.Fluid.ANY;
        }
        return par3;
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void flowing_fluids$alterBehaviourIfPartial(Level level, Player player, InteractionHand interactionHand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (FlowingFluids.config.enableMod && this.f_40687_ instanceof FlowingFluid && FlowingFluids.config.isFluidAllowed(this.f_40687_)) {
            ItemStack heldBucket = player.m_21120_(interactionHand);
            BlockHitResult blockHitResult = MixinBucketItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            if (blockHitResult.m_6662_() == HitResult.Type.MISS || blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
                cir.setReturnValue((Object)InteractionResultHolder.m_19098_((Object)heldBucket));
            } else {
                BlockPos blockPos = blockHitResult.m_82425_();
                Direction direction = blockHitResult.m_82434_();
                BlockPos blockPos2 = blockPos.m_121945_(direction);
                if (level.m_7966_(player, blockPos) && player.m_36204_(blockPos2, direction, heldBucket)) {
                    int amount;
                    BlockState blockState = level.m_8055_(blockPos);
                    FluidState fluidState = level.m_6425_(blockPos);
                    BlockPos blockPos3 = blockState.m_60734_() instanceof LiquidBlockContainer && this.f_40687_ == Fluids.f_76193_ || this.f_40687_.m_6212_(fluidState.m_76152_()) && fluidState.m_76186_() < 8 ? blockPos : blockPos2;
                    int remainder = this.ff$emptyContents_AndGetRemainder(player, level, blockPos3, blockHitResult, amount = 8 - heldBucket.m_41773_(), false);
                    if (remainder != amount) {
                        this.m_142131_(player, level, heldBucket, blockPos3);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, blockPos3, heldBucket);
                        }
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                        ItemStack resultBucket = remainder == 0 ? MixinBucketItem.m_40699_(heldBucket, player) : this.ff$bucketOfAmount(heldBucket, remainder);
                        ItemStack itemStack2 = ItemUtils.m_41813_((ItemStack)heldBucket, (Player)player, (ItemStack)resultBucket);
                        cir.setReturnValue((Object)InteractionResultHolder.m_19092_((Object)itemStack2, (boolean)level.m_5776_()));
                    } else {
                        cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)heldBucket));
                    }
                } else {
                    cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)heldBucket));
                }
            }
        }
    }

    @Override
    public int ff$emptyContents_AndGetRemainder(@Nullable Player player, Level level, BlockPos blockPos, @Nullable BlockHitResult blockHitResult, int amount, boolean onlyModifyThatBlock) {
        int remainder;
        boolean success;
        LiquidBlockContainer container;
        Block block;
        boolean canPlaceLiquidInPos;
        FlowingFluid flowingFluid;
        block18: {
            block17: {
                Fluid fluid = this.f_40687_;
                if (!(fluid instanceof FlowingFluid)) break block17;
                flowingFluid = (FlowingFluid)fluid;
                if (FlowingFluids.config.isFluidAllowed(this.f_40687_)) break block18;
            }
            return amount;
        }
        BlockState state = level.m_8055_(blockPos);
        FluidState fluidState = level.m_6425_(blockPos);
        boolean fluidIsSameAsContent = this.f_40687_.m_6212_(fluidState.m_76152_());
        boolean bl = canPlaceLiquidInPos = state.m_60722_(this.f_40687_) || state.m_60795_() || fluidIsSameAsContent;
        if (!canPlaceLiquidInPos && (block = state.m_60734_()) instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block).m_6044_((BlockGetter)level, blockPos, state, this.f_40687_)) {
            if (amount != 8) {
                return amount;
            }
            container.m_7361_((LevelAccessor)level, blockPos, level.m_8055_(blockPos), flowingFluid.m_76068_(false));
            this.m_7718_(player, (LevelAccessor)level, blockPos);
            return 0;
        }
        if (!canPlaceLiquidInPos) {
            if (blockHitResult == null) {
                return amount;
            }
            return this.ff$emptyContents_AndGetRemainder(player, level, blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_()), null, amount, onlyModifyThatBlock);
        }
        if (level.m_6042_().f_63857_() && this.f_40687_.m_6212_((Fluid)Fluids.f_76193_)) {
            int i = blockPos.m_123341_();
            int j = blockPos.m_123342_();
            int k = blockPos.m_123343_();
            level.m_5594_(player, blockPos, SoundEvents.f_11937_, SoundSource.BLOCKS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
            return 0;
        }
        if (!level.f_46443_ && level.m_8055_(blockPos).m_60722_(this.f_40687_) && !level.m_8055_(blockPos).m_278721_()) {
            level.m_46961_(blockPos, true);
        }
        if (fluidIsSameAsContent) {
            int levelAtBlock = fluidState.m_76186_();
            int total = levelAtBlock + amount;
            if (total > 8) {
                if (onlyModifyThatBlock) {
                    success = level.m_7731_(blockPos, FFFluidUtils.getBlockForFluidByAmount(this.f_40687_, 8), 11);
                    remainder = total - 8;
                } else {
                    remainder = FFFluidUtils.addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull((LevelAccessor)level, blockPos, flowingFluid, amount);
                    success = remainder != amount;
                }
            } else {
                success = level.m_7731_(blockPos, FFFluidUtils.getBlockForFluidByAmount(this.f_40687_, total), 11);
                remainder = 0;
            }
        } else {
            success = level.m_7731_(blockPos, FFFluidUtils.getBlockForFluidByAmount(this.f_40687_, amount), 11);
            remainder = 0;
        }
        if (success) {
            this.m_7718_(player, (LevelAccessor)level, blockPos);
        }
        return success ? remainder : amount;
    }

    @Override
    public ItemStack ff$bucketOfAmount(ItemStack originalItemData, int amount) {
        if (amount == 0) {
            return Items.f_42446_.m_7968_();
        }
        if (!FlowingFluids.config.isFluidAllowed(this.f_40687_)) {
            return originalItemData;
        }
        ItemStack resultBucket = originalItemData.m_41777_();
        resultBucket.m_41721_(8 - amount);
        return resultBucket;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void getMaxDamage(CallbackInfo ci) {
        this.f_41371_ = 8;
    }

    public int m_142159_(ItemStack itemStack) {
        if (FlowingFluids.config.enableMod && FlowingFluids.config.isFluidAllowed(this.f_40687_)) {
            return this.f_40687_.m_76145_().m_76188_().m_284242_(null, null).f_283871_;
        }
        return super.m_142159_(itemStack);
    }

    @Override
    public Fluid ff$getFluid() {
        return this.f_40687_;
    }
}

