/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.forge;

import java.nio.file.Path;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.forge.ForgePacketHandler;

public class FlowingFluidsPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    public static void sendConfigToClient(ServerPlayer player) {
        ForgePacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ForgePacketHandler.FFConfigPacket());
        FlowingFluids.info("- Sending server config to [" + player.m_7755_().getString() + "]");
    }

    public static boolean isThisModLoaded(String modId) {
        try {
            ModList list = ModList.get();
            if (list == null) {
                LoadingModList list2 = FMLLoader.getLoadingModList();
                return list2 != null && FlowingFluidsPlatformImpl.checkInitialModList(list2, modId);
            }
            return list.isLoaded(modId);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean checkInitialModList(@NotNull LoadingModList list, String modId) {
        try {
            for (ModInfo mod : list.getMods()) {
                if (!mod.getModId().equals(modId)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

