/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids.api;

import it.unimi.dsi.fastutil.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.flowing_fluids.FlowingFluids;
import traben.flowing_fluids.api.FlowingFluidsApiImpl;
import traben.flowing_fluids.config.FFConfig;

public interface FlowingFluidsAPI {
    public static final int VERSION = 2;
    public static final int FLUID_LEVELS_PER_BLOCK = 8;

    public static FlowingFluidsAPI getInstance(@NotNull String modIdRequestingAPI) {
        FlowingFluids.info("API requested by " + modIdRequestingAPI + ", version=2");
        return new FlowingFluidsApiImpl(modIdRequestingAPI);
    }

    public boolean isModEnabled();

    public boolean isModCurrentlyMovingFluids();

    public boolean doesModifyThisFluid(@NotNull Fluid var1);

    public boolean doesModifyThisFluid(@NotNull FluidState var1);

    public void disableThisFluid(@NotNull Fluid var1, @Nullable MinecraftServer var2);

    public void disableThisFluid(@NotNull FluidState var1, @Nullable MinecraftServer var2);

    public void enableThisFluid(@NotNull Fluid var1, @Nullable MinecraftServer var2);

    public void enableThisFluid(@NotNull FluidState var1, @Nullable MinecraftServer var2);

    public FFConfig getConfig();

    public void setConfig(@NotNull FFConfig var1, @Nullable MinecraftServer var2);

    public int removeFluidAmountFromPos(@NotNull LevelAccessor var1, @NotNull BlockPos var2, @NotNull Fluid var3, int var4, int var5);

    public int placeFluidAmountFromPos(@NotNull LevelAccessor var1, @NotNull BlockPos var2, @NotNull Fluid var3, int var4, boolean var5, boolean var6);

    public void registerBlockTagThatWontDisplaceFluid(@NotNull Fluid var1, @NotNull TagKey<Block> var2);

    public void registerBlockThatWontDisplaceFluid(@NotNull Fluid var1, @NotNull Block var2);

    public void registerBiomeTagThatHasInfiniteWaterRefilling(@NotNull TagKey<Biome> var1);

    public void registerBiomeThatHasInfiniteWaterRefilling(@NotNull ResourceKey<Biome> var1);

    public boolean doesBiomeInfiniteWaterRefill(@NotNull Holder<Biome> var1);

    public boolean modifyFluidAmountAtPos(@NotNull LevelAccessor var1, @NotNull BlockPos var2, @NotNull FluidAmountModifier var3);

    public boolean modifyFluidAmountAtPos(@NotNull LevelAccessor var1, @NotNull BlockPos var2, @NotNull Fluid var3, int var4);

    public static interface FluidAmountModifier {
        @NotNull
        public Pair<Fluid, Integer> getNewAmount(@NotNull Fluid var1, int var2);
    }
}

