/*
 * Decompiled with CFR 0.152.
 */
package traben.flowing_fluids;

import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import traben.flowing_fluids.FlowingFluids;

public class FFFluidUtils {
    @NotNull
    public static ResourceLocation res(String fullPath) {
        return new ResourceLocation(fullPath);
    }

    @NotNull
    public static ResourceLocation res(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static boolean canFluidFlowToNeighbourFromPos(LevelAccessor accessor, BlockPos pos, FlowingFluid fluid, int amount) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!FFFluidUtils.canFluidFlowFromPosToDirection(fluid, amount, accessor, pos, direction)) continue;
            return true;
        }
        return false;
    }

    public static FluidState getStateForFluidByAmount(Fluid fluid, int amount) {
        if (amount < 1) {
            return Fluids.f_76191_.m_76145_();
        }
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            return amount >= 8 ? flowing.m_76068_(false) : flowing.m_75953_(amount, false);
        }
        return amount >= 8 ? fluid.m_76145_() : (FluidState)fluid.m_76145_().m_263224_((Property)FlowingFluid.f_75948_, (Comparable)Integer.valueOf(amount));
    }

    public static BlockState getBlockForFluidByAmount(Fluid fluid, int amount) {
        return FFFluidUtils.getStateForFluidByAmount(fluid, amount).m_76188_();
    }

    public static boolean setFluidStateAtPosToNewAmount(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid, int newAmount) {
        if (newAmount < 1) {
            return FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, fluid);
        }
        BlockState blockState = levelAccessor.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer liquidBlockContainer = (LiquidBlockContainer)block;
            if (newAmount == 8) {
                return liquidBlockContainer.m_7361_(levelAccessor, pos, blockState, FFFluidUtils.getStateForFluidByAmount(fluid, newAmount));
            }
            Block block2 = blockState.m_60734_();
            if (block2 instanceof BucketPickup) {
                BucketPickup bucketPickup = (BucketPickup)block2;
                bucketPickup.m_142598_(levelAccessor, pos, blockState);
                return true;
            }
            if (!blockState.m_60722_(fluid)) {
                return false;
            }
        }
        if (!blockState.m_60795_() && fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            flowingFluid.m_7456_(levelAccessor, pos, blockState);
        }
        return levelAccessor.m_7731_(pos, FFFluidUtils.getStateForFluidByAmount(fluid, newAmount).m_76188_(), 3);
    }

    public static boolean removeAllFluidAtPos(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid) {
        Block block;
        BlockState blockState = levelAccessor.m_8055_(pos);
        if (blockState.m_60734_() instanceof LiquidBlockContainer && (block = blockState.m_60734_()) instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            bucketPickup.m_142598_(levelAccessor, pos, blockState);
            return true;
        }
        if (!blockState.m_60795_() && fluid instanceof FlowingFluid) {
            FlowingFluid flowingFluid = (FlowingFluid)fluid;
            flowingFluid.m_7456_(levelAccessor, pos, blockState);
        }
        return levelAccessor.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
    }

    public static int removeAmountFromFluidAtPosWithRemainder(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid, int removeAmount) {
        FluidState state = levelAccessor.m_6425_(pos);
        if (state.m_76152_().m_6212_(fluid)) {
            int currentAmount = state.m_76186_();
            if (currentAmount <= removeAmount) {
                FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, fluid);
                return removeAmount - currentAmount;
            }
            FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, currentAmount - removeAmount);
            return 0;
        }
        return removeAmount;
    }

    public static int addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(LevelAccessor levelAccessor, BlockPos pos, FlowingFluid fluid, int addAmount) {
        Pair<Integer, Runnable> data = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, pos, addAmount, fluid);
        if ((Integer)data.first() != addAmount) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return addAmount;
    }

    public static int addAmountToFluidAtPosWithRemainderAndTrySpreadIfFull(LevelAccessor levelAccessor, BlockPos pos, FlowingFluid fluid, int addAmount, boolean canSpreadUp, boolean canSpreadDown) {
        Pair<Integer, Runnable> data = FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, pos, addAmount, fluid, 80, canSpreadUp, canSpreadDown);
        if ((Integer)data.first() != addAmount) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return addAmount;
    }

    public static int addAmountToFluidAtPosWithRemainder(LevelAccessor levelAccessor, BlockPos pos, Fluid fluid, int addAmount) {
        FluidState state = levelAccessor.m_6425_(pos);
        if (state.m_76178_() || state.m_76152_().m_6212_(fluid)) {
            int currentAmount = state.m_76186_();
            if (currentAmount == 8) {
                return addAmount;
            }
            if (currentAmount + addAmount <= 8) {
                if (FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, currentAmount + addAmount)) {
                    return 0;
                }
            } else if (FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, fluid, 8)) {
                return currentAmount + addAmount - 8;
            }
        }
        return addAmount;
    }

    public static boolean canFluidFlowFromPosToDirection(FlowingFluid fluid, int amount, LevelAccessor levelAccessor, BlockPos fromPos, Direction direction) {
        BlockPos blockPos2 = fromPos.m_121945_(direction);
        BlockState blockState2 = levelAccessor.m_8055_(blockPos2);
        FluidState fluidState2 = blockState2.m_60819_();
        return FFFluidUtils.canFluidFlowFromPosToDirection(fluid, amount, (BlockGetter)levelAccessor, fromPos, levelAccessor.m_8055_(fromPos), direction, blockPos2, blockState2, fluidState2);
    }

    public static boolean canFluidFlowFromPosToDirection(FlowingFluid sourceFluid, int sourceAmount, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2, FluidState fluidState2) {
        return (fluidState2.m_76158_(blockGetter, blockPos2, (Fluid)sourceFluid, direction) || FFFluidUtils.canFitIntoFluid((Fluid)sourceFluid, fluidState2, direction, sourceAmount, blockState2)) && sourceFluid.m_76061_(direction, blockGetter, blockPos, blockState, blockPos2, blockState2) && sourceFluid.m_75972_(blockGetter, blockPos2, blockState2, (Fluid)sourceFluid);
    }

    public static boolean canFluidFlowFromPosToDirectionFitOverride(FlowingFluid sourceFluid, BlockGetter blockGetter, BlockPos blockPos, BlockState blockState, Direction direction, BlockPos blockPos2, BlockState blockState2) {
        return sourceFluid.m_76061_(direction, blockGetter, blockPos, blockState, blockPos2, blockState2) && sourceFluid.m_75972_(blockGetter, blockPos2, blockState2, (Fluid)sourceFluid);
    }

    private static boolean canFitIntoFluid(Fluid thisFluid, FluidState fluidStateTo, Direction direction, int amount, BlockState blockStateTo) {
        if (fluidStateTo.m_76178_()) {
            return true;
        }
        if (fluidStateTo.m_76152_().m_6212_(thisFluid)) {
            if (direction == Direction.DOWN) {
                return fluidStateTo.m_76186_() < 8;
            }
            return fluidStateTo.m_76186_() < amount;
        }
        return false;
    }

    public static Pair<Integer, Runnable> placeConnectedFluidAmountAndPlaceAction(LevelAccessor levelAccessor, BlockPos blockPos, int amountToPlace, FlowingFluid fluid) {
        return FFFluidUtils.placeConnectedFluidAmountAndPlaceAction(levelAccessor, blockPos, amountToPlace, fluid, 80, true, true);
    }

    public static Pair<Integer, Runnable> placeConnectedFluidAmountAndPlaceAction(LevelAccessor levelAccessor, BlockPos blockPos, int amountToPlace, FlowingFluid fluid, int depth, boolean doUp, boolean doDown) {
        FluidState originalState = levelAccessor.m_6425_(blockPos);
        int originalAmount = originalState.m_76186_();
        if (originalState.m_76152_().m_6212_((Fluid)fluid) && originalAmount > 0) {
            if (originalAmount + amountToPlace <= 8) {
                return Pair.of((Object)0, () -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, blockPos, (Fluid)fluid, originalAmount + amountToPlace));
            }
            ArrayList<BlockPos> toCheck = new ArrayList<BlockPos>();
            toCheck.add(blockPos);
            Consumer<BlockPos> addSurroundingPositions = blockPos1 -> {
                BlockPos down;
                BlockPos up;
                for (Direction direction : FFFluidUtils.getCardinalsShuffle(levelAccessor.m_213780_())) {
                    BlockPos offset = blockPos1.m_121945_(direction);
                    if (toCheck.contains(offset)) continue;
                    toCheck.add(offset);
                }
                if (doUp && !toCheck.contains(up = blockPos1.m_7494_())) {
                    toCheck.add(up);
                }
                if (doDown && !toCheck.contains(down = blockPos1.m_7495_())) {
                    toCheck.add(down);
                }
            };
            addSurroundingPositions.accept(blockPos);
            ArrayList<Runnable> onSuccessPlacers = new ArrayList<Runnable>();
            int amountLeftToPlace = amountToPlace;
            for (int i = 0; i < toCheck.size(); ++i) {
                BlockPos pos = (BlockPos)toCheck.get(i);
                if (toCheck.size() > depth) break;
                FluidState state = levelAccessor.m_6425_(pos);
                if (!fluid.m_6212_(state.m_76152_()) && (!state.m_76178_() || !levelAccessor.m_8055_(pos).m_60795_())) continue;
                int space = 8 - state.m_76186_();
                if (space > 0) {
                    if (space >= amountLeftToPlace) {
                        int newAmount = state.m_76186_() + amountLeftToPlace;
                        onSuccessPlacers.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (Fluid)fluid, newAmount));
                        amountLeftToPlace = 0;
                        break;
                    }
                    onSuccessPlacers.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (Fluid)fluid, 8));
                    amountLeftToPlace -= space;
                }
                addSurroundingPositions.accept(pos);
            }
            if (amountLeftToPlace == amountToPlace) {
                return Pair.of((Object)amountToPlace, null);
            }
            return Pair.of((Object)amountLeftToPlace, () -> onSuccessPlacers.forEach(Runnable::run));
        }
        return Pair.of((Object)amountToPlace, null);
    }

    public static int collectConnectedFluidAmountAndRemove(LevelAccessor levelAccessor, BlockPos blockPos, int minAmountRequired, int maxAmountToFind, FlowingFluid fluid) {
        Pair<Integer, Runnable> data = FFFluidUtils.collectConnectedFluidAmountAndRemoveAction(levelAccessor, blockPos, minAmountRequired, maxAmountToFind, fluid);
        if ((Integer)data.first() != 0) {
            ((Runnable)data.second()).run();
            return (Integer)data.first();
        }
        return 0;
    }

    public static Pair<Integer, Runnable> collectConnectedFluidAmountAndRemoveAction(LevelAccessor levelAccessor, BlockPos blockPos, int minAmountRequired, int maxAmountToFind, FlowingFluid fluid) {
        return FFFluidUtils.collectConnectedFluidAmountAndRemoveAction(levelAccessor, blockPos, minAmountRequired, maxAmountToFind, fluid, 40);
    }

    public static Pair<Integer, Runnable> collectConnectedFluidAmountAndRemoveAction(LevelAccessor levelAccessor, BlockPos blockPos, int minAmountRequired, int maxAmountToFind, FlowingFluid fluid, int depth) {
        FluidState originalState = levelAccessor.m_6425_(blockPos);
        int originalAmount = originalState.m_76186_();
        if (originalState.m_76152_().m_6212_((Fluid)fluid) && originalAmount > 0) {
            if (originalAmount >= maxAmountToFind) {
                return Pair.of((Object)maxAmountToFind, () -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, blockPos, (Fluid)fluid, originalAmount - maxAmountToFind));
            }
            ArrayList<BlockPos> toCheck = new ArrayList<BlockPos>();
            toCheck.add(blockPos);
            for (Direction direction : Direction.m_235667_((RandomSource)levelAccessor.m_213780_())) {
                BlockPos offset = blockPos.m_121945_(direction);
                toCheck.add(offset);
            }
            ArrayList<Runnable> onSuccessAirSetters = new ArrayList<Runnable>();
            int foundAmount = 0;
            for (int i = 0; i < toCheck.size(); ++i) {
                int amount;
                BlockPos pos = (BlockPos)toCheck.get(i);
                if (toCheck.size() > depth) break;
                FluidState state = levelAccessor.m_6425_(pos);
                if (!fluid.m_6212_(state.m_76152_()) || (amount = state.m_76186_()) <= 0) continue;
                if ((foundAmount += amount) > maxAmountToFind) {
                    int finalLevel = foundAmount - maxAmountToFind;
                    onSuccessAirSetters.add(() -> FFFluidUtils.setFluidStateAtPosToNewAmount(levelAccessor, pos, (Fluid)fluid, finalLevel));
                    foundAmount = maxAmountToFind;
                    break;
                }
                onSuccessAirSetters.add(() -> FFFluidUtils.removeAllFluidAtPos(levelAccessor, pos, (Fluid)fluid));
                if (foundAmount == maxAmountToFind) break;
                for (Direction direction : Direction.m_235667_((RandomSource)levelAccessor.m_213780_())) {
                    BlockPos offset = pos.m_121945_(direction);
                    if (toCheck.contains(offset)) continue;
                    toCheck.add(offset);
                }
            }
            if (foundAmount < minAmountRequired) {
                return Pair.of((Object)0, null);
            }
            return Pair.of((Object)foundAmount, () -> onSuccessAirSetters.forEach(Runnable::run));
        }
        return Pair.of((Object)0, null);
    }

    public static List<Direction> getCardinalsShuffle(RandomSource random) {
        return Direction.Plane.HORIZONTAL.m_235694_(random);
    }

    private static boolean checkBlockIsNonDisplacer(Fluid fluid, BlockState state) {
        return FlowingFluids.nonDisplacerTags.stream().anyMatch(pair -> (pair.first() == Fluids.f_76191_ || ((Fluid)pair.first()).m_6212_(fluid)) && state.m_204336_((TagKey)pair.second())) || FlowingFluids.nonDisplacers.stream().anyMatch(pair -> (pair.first() == Fluids.f_76191_ || ((Fluid)pair.first()).m_6212_(fluid)) && state.m_60713_((Block)pair.second()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void displaceFluids(Level level, BlockPos pos, BlockState state, int flags, LevelChunk levelChunk, BlockState originalState) {
        block10: {
            Fluid fluid;
            if (!level.m_5776_() && FlowingFluids.config.enableMod && FlowingFluids.config.enableDisplacement && !FlowingFluids.isManeuveringFluids && !originalState.m_60819_().m_76178_() && (fluid = originalState.m_60819_().m_76152_()) instanceof FlowingFluid) {
                FlowingFluid flowSource = (FlowingFluid)fluid;
                if (!(state.m_60795_() || !state.m_60819_().m_76178_() || (flags & 0x40) == 64 || state.m_60734_() instanceof LiquidBlockContainer && originalState.m_60734_() instanceof BucketPickup || FFFluidUtils.checkBlockIsNonDisplacer((Fluid)flowSource, state))) {
                    FlowingFluids.isManeuveringFluids = true;
                    try {
                        int amountRemaining = originalState.m_60819_().m_76186_();
                        for (Direction direction : FFFluidUtils.getCardinalsShuffle(level.m_213780_())) {
                            BlockPos offset = pos.m_121945_(direction);
                            BlockState offsetState = level.m_8055_(offset);
                            if (offsetState.m_60819_().m_76152_() instanceof FlowingFluid) {
                                if ((amountRemaining = FFFluidUtils.addAmountToFluidAtPosWithRemainder((LevelAccessor)level, offset, (Fluid)flowSource, amountRemaining)) != 0) continue;
                                break;
                            }
                            if (!offsetState.m_60795_()) continue;
                            level.m_7731_(offset, originalState.m_60819_().m_76188_(), 3);
                            amountRemaining = 0;
                            break;
                        }
                        if (amountRemaining <= 0) break block10;
                        BlockPos.MutableBlockPos posTraversing = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                        int height = levelChunk.m_151558_();
                        while (amountRemaining > 0 && posTraversing.m_123342_() < height) {
                            posTraversing.m_122173_(Direction.UP);
                            BlockState offsetState = level.m_8055_((BlockPos)posTraversing);
                            if (offsetState.m_60819_().m_76152_() instanceof FlowingFluid) {
                                amountRemaining = FFFluidUtils.addAmountToFluidAtPosWithRemainder((LevelAccessor)level, (BlockPos)posTraversing, (Fluid)flowSource, amountRemaining);
                                continue;
                            }
                            if (offsetState.m_60795_()) {
                                level.m_7731_((BlockPos)posTraversing, originalState.m_60819_().m_76188_(), 3);
                                amountRemaining = 0;
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        FlowingFluids.isManeuveringFluids = false;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean matchInfiniteBiomes(Holder<Biome> biome) {
        if (FlowingFluids.infiniteBiomeTags.stream().anyMatch(arg_0 -> biome.m_203656_(arg_0))) return true;
        if (!FlowingFluids.infiniteBiomes.stream().anyMatch(arg_0 -> biome.m_203565_(arg_0))) return false;
        return true;
    }
}

