/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.interpritation.network;

import java.util.function.Supplier;
import net.mcreator.interpritation.ThebrokenscriptMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThebrokenscriptModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        ThebrokenscriptMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        ThebrokenscriptMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        private final int type;
        private SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            CompoundTag nbt = buffer.m_130260_();
            if (nbt != null) {
                this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
                SavedData savedData = this.data;
                if (savedData instanceof MapVariables) {
                    MapVariables mapVariables = (MapVariables)savedData;
                    mapVariables.read(nbt);
                } else {
                    savedData = this.data;
                    if (savedData instanceof WorldVariables) {
                        WorldVariables worldVariables = (WorldVariables)savedData;
                        worldVariables.read(nbt);
                    }
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            if (message.data != null) {
                buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
            }
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer() && message.data != null) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.showtab = message.data.showtab;
                    variables.filecreated = message.data.filecreated;
                    variables.corrupted = message.data.corrupted;
                    variables.screendamage = message.data.screendamage;
                    variables.is_player_an_entity = message.data.is_player_an_entity;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean showtab = false;
        public boolean filecreated = false;
        public double corrupted = 0.0;
        public boolean screendamage = false;
        public boolean is_player_an_entity = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                ThebrokenscriptMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("showtab", this.showtab);
            nbt.m_128379_("filecreated", this.filecreated);
            nbt.m_128347_("corrupted", this.corrupted);
            nbt.m_128379_("screendamage", this.screendamage);
            nbt.m_128379_("is_player_an_entity", this.is_player_an_entity);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.showtab = nbt.m_128471_("showtab");
            this.filecreated = nbt.m_128471_("filecreated");
            this.corrupted = nbt.m_128459_("corrupted");
            this.screendamage = nbt.m_128471_("screendamage");
            this.is_player_an_entity = nbt.m_128471_("is_player_an_entity");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("thebrokenscript", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "thebrokenscript_mapvars";
        public double baseX = 0.0;
        public double baseY = 0.0;
        public double baseZ = 0.0;
        public boolean isnullspawned = false;
        public boolean isitspawned = false;
        public boolean issiluettspawned = false;
        public boolean firstjoin = true;
        public boolean iseeyoucodeactivated = false;
        public boolean silluetspawned = false;
        public double homeX = 0.0;
        public double homeY = 0.0;
        public double homeZ = 0.0;
        public boolean isnulldimentiongenerated = false;
        public double dimentionspawnX = 0.0;
        public double dimentionspawnY = 0.0;
        public double dimentionspawnZ = 0.0;
        public boolean showvhs = true;
        public boolean iscircuitspawned = false;
        public boolean isthebrokenendspawned = false;
        public boolean clanbuilddimensiongenerated = false;
        public boolean ram2dietriggered = false;
        public boolean ram2diejoined = false;
        public boolean disc13or11played = false;
        public boolean isvoidspawned = false;
        public boolean nullishere = false;
        public boolean cancorrupted = true;
        public boolean isfieldGenerated = false;
        public boolean isDeceiverSpawned = false;
        public boolean devmodeenabled = false;
        public boolean isentityspawned = false;
        public boolean isvoidexpgenerated = false;
        public double reputation = 1.0;
        public double nowayoutframe = 0.0;
        public boolean config_randomevents = false;
        public boolean config_noentitiesspawn = false;
        public boolean config_nocrashes = false;
        public boolean config_norandomstructures = false;
        public boolean config_noban = false;
        public boolean config_noblockbreaking = false;
        public boolean config_nobaseexplode = false;
        public boolean config_norandomjumpscare = false;
        public double moonphase = 0.0;
        public double config_event_engine_chance = 1.0;
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.baseX = nbt.m_128459_("baseX");
            this.baseY = nbt.m_128459_("baseY");
            this.baseZ = nbt.m_128459_("baseZ");
            this.isnullspawned = nbt.m_128471_("isnullspawned");
            this.isitspawned = nbt.m_128471_("isitspawned");
            this.issiluettspawned = nbt.m_128471_("issiluettspawned");
            this.firstjoin = nbt.m_128471_("firstjoin");
            this.iseeyoucodeactivated = nbt.m_128471_("iseeyoucodeactivated");
            this.silluetspawned = nbt.m_128471_("silluetspawned");
            this.homeX = nbt.m_128459_("homeX");
            this.homeY = nbt.m_128459_("homeY");
            this.homeZ = nbt.m_128459_("homeZ");
            this.isnulldimentiongenerated = nbt.m_128471_("isnulldimentiongenerated");
            this.dimentionspawnX = nbt.m_128459_("dimentionspawnX");
            this.dimentionspawnY = nbt.m_128459_("dimentionspawnY");
            this.dimentionspawnZ = nbt.m_128459_("dimentionspawnZ");
            this.showvhs = nbt.m_128471_("showvhs");
            this.iscircuitspawned = nbt.m_128471_("iscircuitspawned");
            this.isthebrokenendspawned = nbt.m_128471_("isthebrokenendspawned");
            this.clanbuilddimensiongenerated = nbt.m_128471_("clanbuilddimensiongenerated");
            this.ram2dietriggered = nbt.m_128471_("ram2dietriggered");
            this.ram2diejoined = nbt.m_128471_("ram2diejoined");
            this.disc13or11played = nbt.m_128471_("disc13or11played");
            this.isvoidspawned = nbt.m_128471_("isvoidspawned");
            this.nullishere = nbt.m_128471_("nullishere");
            this.cancorrupted = nbt.m_128471_("cancorrupted");
            this.isfieldGenerated = nbt.m_128471_("isfieldGenerated");
            this.isDeceiverSpawned = nbt.m_128471_("isDeceiverSpawned");
            this.devmodeenabled = nbt.m_128471_("devmodeenabled");
            this.isentityspawned = nbt.m_128471_("isentityspawned");
            this.isvoidexpgenerated = nbt.m_128471_("isvoidexpgenerated");
            this.reputation = nbt.m_128459_("reputation");
            this.nowayoutframe = nbt.m_128459_("nowayoutframe");
            this.config_randomevents = nbt.m_128471_("config_randomevents");
            this.config_noentitiesspawn = nbt.m_128471_("config_noentitiesspawn");
            this.config_nocrashes = nbt.m_128471_("config_nocrashes");
            this.config_norandomstructures = nbt.m_128471_("config_norandomstructures");
            this.config_noban = nbt.m_128471_("config_noban");
            this.config_noblockbreaking = nbt.m_128471_("config_noblockbreaking");
            this.config_nobaseexplode = nbt.m_128471_("config_nobaseexplode");
            this.config_norandomjumpscare = nbt.m_128471_("config_norandomjumpscare");
            this.moonphase = nbt.m_128459_("moonphase");
            this.config_event_engine_chance = nbt.m_128459_("config_event_engine_chance");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128347_("baseX", this.baseX);
            nbt.m_128347_("baseY", this.baseY);
            nbt.m_128347_("baseZ", this.baseZ);
            nbt.m_128379_("isnullspawned", this.isnullspawned);
            nbt.m_128379_("isitspawned", this.isitspawned);
            nbt.m_128379_("issiluettspawned", this.issiluettspawned);
            nbt.m_128379_("firstjoin", this.firstjoin);
            nbt.m_128379_("iseeyoucodeactivated", this.iseeyoucodeactivated);
            nbt.m_128379_("silluetspawned", this.silluetspawned);
            nbt.m_128347_("homeX", this.homeX);
            nbt.m_128347_("homeY", this.homeY);
            nbt.m_128347_("homeZ", this.homeZ);
            nbt.m_128379_("isnulldimentiongenerated", this.isnulldimentiongenerated);
            nbt.m_128347_("dimentionspawnX", this.dimentionspawnX);
            nbt.m_128347_("dimentionspawnY", this.dimentionspawnY);
            nbt.m_128347_("dimentionspawnZ", this.dimentionspawnZ);
            nbt.m_128379_("showvhs", this.showvhs);
            nbt.m_128379_("iscircuitspawned", this.iscircuitspawned);
            nbt.m_128379_("isthebrokenendspawned", this.isthebrokenendspawned);
            nbt.m_128379_("clanbuilddimensiongenerated", this.clanbuilddimensiongenerated);
            nbt.m_128379_("ram2dietriggered", this.ram2dietriggered);
            nbt.m_128379_("ram2diejoined", this.ram2diejoined);
            nbt.m_128379_("disc13or11played", this.disc13or11played);
            nbt.m_128379_("isvoidspawned", this.isvoidspawned);
            nbt.m_128379_("nullishere", this.nullishere);
            nbt.m_128379_("cancorrupted", this.cancorrupted);
            nbt.m_128379_("isfieldGenerated", this.isfieldGenerated);
            nbt.m_128379_("isDeceiverSpawned", this.isDeceiverSpawned);
            nbt.m_128379_("devmodeenabled", this.devmodeenabled);
            nbt.m_128379_("isentityspawned", this.isentityspawned);
            nbt.m_128379_("isvoidexpgenerated", this.isvoidexpgenerated);
            nbt.m_128347_("reputation", this.reputation);
            nbt.m_128347_("nowayoutframe", this.nowayoutframe);
            nbt.m_128379_("config_randomevents", this.config_randomevents);
            nbt.m_128379_("config_noentitiesspawn", this.config_noentitiesspawn);
            nbt.m_128379_("config_nocrashes", this.config_nocrashes);
            nbt.m_128379_("config_norandomstructures", this.config_norandomstructures);
            nbt.m_128379_("config_noban", this.config_noban);
            nbt.m_128379_("config_noblockbreaking", this.config_noblockbreaking);
            nbt.m_128379_("config_nobaseexplode", this.config_nobaseexplode);
            nbt.m_128379_("config_norandomjumpscare", this.config_norandomjumpscare);
            nbt.m_128347_("moonphase", this.moonphase);
            nbt.m_128347_("config_event_engine_chance", this.config_event_engine_chance);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                ThebrokenscriptMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "thebrokenscript_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                ThebrokenscriptMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.showtab = original.showtab;
            clone.filecreated = original.filecreated;
            clone.corrupted = original.corrupted;
            clone.is_player_an_entity = original.is_player_an_entity;
            if (!event.isWasDeath()) {
                clone.screendamage = original.screendamage;
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().m_9236_());
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_());
                if (mapdata != null) {
                    ThebrokenscriptMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    ThebrokenscriptMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().m_9236_().m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().m_9236_())) != null) {
                ThebrokenscriptMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

