/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.server.world.data.villageComponents;

import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.relationship.Gender;
import forge.net.mca.resources.PoolUtil;
import forge.net.mca.server.world.data.FamilyTree;
import forge.net.mca.server.world.data.Village;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;

public class VillageProcreationManager {
    private final Village village;

    public VillageProcreationManager(Village village) {
        this.village = village;
    }

    public void procreate(ServerLevel world) {
        int maxPopulation;
        if (world.f_46441_.m_188501_() >= Config.getInstance().villagerProcreationChancePerMinute) {
            return;
        }
        int population = this.village.getPopulation();
        if ((float)population >= (float)(maxPopulation = this.village.getMaxPopulation()) * this.village.getPopulationThreshold()) {
            return;
        }
        PoolUtil.pick(this.village.getResidents(world), world.f_46441_).filter(villager -> villager.getGenetics().getGender() == Gender.FEMALE).filter(villager -> (double)world.f_46441_.m_188501_() < 1.0 / ((double)FamilyTree.get(world).getOrCreate((Entity)villager).getChildren().count() + 0.1)).filter(villager -> villager.getRelationships().getPregnancy().tryStartGestation()).ifPresent(villager -> villager.getRelationships().getPartner().ifPresent(spouse -> {
            if (Config.getInstance().villagerBirthNotification && spouse instanceof VillagerEntityMCA) {
                VillagerEntityMCA spouseVillager = (VillagerEntityMCA)spouse;
                this.village.broadCastMessage(world, "events.baby", (VillagerEntityMCA)villager, spouseVillager);
            }
        }));
    }
}

