/*
 * Decompiled with CFR 0.152.
 */
package forge.net.mca.entity.ai.brain.sensor;

import com.google.common.collect.ImmutableSet;
import forge.net.mca.Config;
import forge.net.mca.entity.VillagerEntityMCA;
import forge.net.mca.entity.ai.MemoryModuleTypeMCA;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Enemy;

public class GuardEnemiesSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)((MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get()));
    }

    protected void m_5578_(ServerLevel world, LivingEntity entity) {
        entity.m_6274_().m_21886_((MemoryModuleType)MemoryModuleTypeMCA.NEAREST_GUARD_ENEMY.get(), this.getNearestHostile(entity));
    }

    private Optional<LivingEntity> getNearestHostile(LivingEntity entity) {
        return this.getVisibleMobs(entity).flatMap(list -> list.m_186128_(this::isHostile).min((a, b) -> this.compareEntities(entity, (LivingEntity)a, (LivingEntity)b)));
    }

    private Optional<NearestVisibleLivingEntities> getVisibleMobs(LivingEntity entity) {
        return entity.m_6274_().m_257414_(MemoryModuleType.f_148205_);
    }

    private int compareEntities(LivingEntity entity, LivingEntity hostile1, LivingEntity hostile2) {
        int i = this.getPriority(hostile2, entity) - this.getPriority(hostile1, entity);
        return i == 0 ? this.compareDistances(entity, hostile1, hostile2) : i;
    }

    private int compareDistances(LivingEntity entity, LivingEntity hostile1, LivingEntity hostile2) {
        return Mth.m_14107_((double)(hostile1.m_20280_((Entity)entity) - hostile2.m_20280_((Entity)entity)));
    }

    private int getPriority(LivingEntity entity, LivingEntity guard) {
        if (entity instanceof VillagerEntityMCA) {
            VillagerEntityMCA villager = (VillagerEntityMCA)entity;
            return villager.isHostile() ? 10 : -1;
        }
        if (guard != null && entity instanceof Mob && ((Mob)entity).m_5448_() == guard) {
            return 9;
        }
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
        if (Config.getInstance().guardsTargetEntities.containsKey(id.toString())) {
            return Config.getInstance().guardsTargetEntities.get(id.toString());
        }
        if (Config.getInstance().guardsTargetMonsters && entity instanceof Enemy) {
            return 3;
        }
        return -1;
    }

    private boolean isHostile(LivingEntity entity) {
        return this.getPriority(entity, null) >= 0;
    }
}

