/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.resources.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fabric.net.mca.MCA;
import fabric.net.mca.util.RegistryHelper;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class BuildingType
implements Serializable {
    private static final long serialVersionUID = 2215455350801127280L;
    private final String name;
    private final int margin;
    private final String color;
    private final int priority;
    private final boolean visible;
    private final boolean noBeds;
    private final Map<String, Integer> blocks;
    private transient Map<class_2960, class_2960> blockToGroup;
    private transient Map<class_2960, Integer> groups;
    private final boolean icon;
    private final int iconU;
    private final int iconV;
    private final boolean grouped;
    private final int mergeRange;

    public BuildingType() {
        this.name = "?";
        this.margin = 0;
        this.color = "ffffffff";
        this.priority = 0;
        this.visible = true;
        this.noBeds = false;
        this.blocks = Map.of("#minecraft:beds", 1000000000);
        this.blockToGroup = null;
        this.icon = false;
        this.iconU = 0;
        this.iconV = 0;
        this.grouped = false;
        this.mergeRange = 32;
    }

    public BuildingType(String name, JsonObject value) {
        JsonObject blocks;
        this.name = name;
        this.margin = class_3518.method_15282((JsonObject)value, (String)"margin", (int)0);
        this.color = class_3518.method_15253((JsonObject)value, (String)"color", (String)"ffffffff");
        this.priority = class_3518.method_15282((JsonObject)value, (String)"priority", (int)0);
        this.visible = class_3518.method_15258((JsonObject)value, (String)"visible", (boolean)true);
        this.noBeds = class_3518.method_15258((JsonObject)value, (String)"noBeds", (boolean)false);
        this.icon = class_3518.method_15258((JsonObject)value, (String)"icon", (boolean)false);
        this.iconU = class_3518.method_15282((JsonObject)value, (String)"iconU", (int)0);
        this.iconV = class_3518.method_15282((JsonObject)value, (String)"iconV", (int)0);
        this.grouped = class_3518.method_15258((JsonObject)value, (String)"grouped", (boolean)false);
        this.mergeRange = class_3518.method_15282((JsonObject)value, (String)"mergeRange", (int)0);
        this.blocks = new HashMap<String, Integer>();
        if (class_3518.method_34923((JsonObject)value, (String)"blocks")) {
            blocks = class_3518.method_15296((JsonObject)value, (String)"blocks");
            for (Map.Entry entry : blocks.entrySet()) {
                this.blocks.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
        this.groups = new HashMap<class_2960, Integer>();
        if (class_3518.method_34923((JsonObject)value, (String)"groups")) {
            blocks = class_3518.method_15296((JsonObject)value, (String)"groups");
            for (Map.Entry entry : blocks.entrySet()) {
                this.groups.put(new class_2960((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsInt());
            }
        }
    }

    public String name() {
        return this.name;
    }

    public String color() {
        return this.color;
    }

    public int priority() {
        return this.priority;
    }

    public boolean visible() {
        return this.visible;
    }

    public int getColor() {
        return (int)Long.parseLong(this.color, 16);
    }

    public Map<class_2960, class_2960> getBlockToGroup() {
        if (this.blockToGroup == null) {
            this.blockToGroup = new HashMap<class_2960, class_2960>();
            this.groups = new HashMap<class_2960, Integer>();
            for (Map.Entry<String, Integer> requirement : this.blocks.entrySet()) {
                class_2960 identifier;
                if (requirement.getKey().startsWith("#")) {
                    identifier = new class_2960(requirement.getKey().substring(1));
                    class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
                    if (tag == null || RegistryHelper.isTagEmpty(tag)) {
                        MCA.LOGGER.error("Unknown building type tag " + String.valueOf(identifier));
                    } else {
                        Optional<class_6885<class_6885>> entries = RegistryHelper.getEntries(tag);
                        entries.ifPresent(registryEntries -> {
                            for (class_2248 b : registryEntries.method_40239().map(class_6880::comp_349).toList()) {
                                this.blockToGroup.putIfAbsent(class_7923.field_41175.method_10221((Object)b), identifier);
                            }
                        });
                    }
                } else {
                    identifier = new class_2960(requirement.getKey());
                    this.blockToGroup.put(identifier, identifier);
                }
                this.groups.put(identifier, requirement.getValue());
            }
        }
        return this.blockToGroup;
    }

    public Map<class_2960, Integer> getGroups() {
        this.getBlockToGroup();
        return this.groups;
    }

    public Map<class_2960, List<class_2338>> getGroups(Map<class_2960, List<class_2338>> blocks) {
        HashMap<class_2960, List<class_2338>> available = new HashMap<class_2960, List<class_2338>>();
        for (Map.Entry<class_2960, List<class_2338>> entry : blocks.entrySet()) {
            Optional.ofNullable(this.getBlockToGroup().get(entry.getKey())).ifPresent(v -> available.computeIfAbsent((class_2960)v, k -> new LinkedList()).addAll((Collection)entry.getValue()));
        }
        return available;
    }

    public boolean isIcon() {
        return this.icon;
    }

    public int iconU() {
        return this.iconU * 20;
    }

    public int iconV() {
        return this.iconV * 60;
    }

    public boolean grouped() {
        return this.grouped;
    }

    public int mergeRange() {
        return this.mergeRange;
    }

    public boolean noBeds() {
        return this.noBeds;
    }

    public int getMargin() {
        return this.margin;
    }

    public int getMinBlocks() {
        return this.blocks.values().stream().mapToInt(v -> v).sum();
    }
}

