/*
 * Decompiled with CFR 0.152.
 */
package cubicoder.well.block.entity;

import cubicoder.well.block.ModBlocks;
import cubicoder.well.block.WellBlock;
import cubicoder.well.config.WellConfig;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidHandlerBlockEntity;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class WellBlockEntity
extends FluidHandlerBlockEntity {
    public int fillTick = 0;
    public int nearbyWells = 1;
    public int delayUntilNextBucket = 0;
    public boolean initialized;

    public WellBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlocks.WELL_BE.get(), pos, state);
        this.tank = new WellFluidTank(this, (Integer)WellConfig.tankCapacity.get());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WellBlockEntity be) {
        if (be.delayUntilNextBucket > 0) {
            --be.delayUntilNextBucket;
        }
        if (be.fillTick > 0) {
            --be.fillTick;
            be.m_6596_();
        }
        if (be.fillTick <= 0 && WellConfig.canGenerateFluid(be.nearbyWells)) {
            FluidStack fluidToFill = be.getFluidToFill();
            int result = 0;
            if (fluidToFill != null) {
                result = be.tank.fill(fluidToFill, IFluidHandler.FluidAction.EXECUTE);
            }
            if (result > 0) {
                be.initFillTick();
                be.m_6596_();
            }
        }
    }

    public void onLoad() {
        if (!this.initialized) {
            this.initialized = true;
            if (!this.f_58857_.f_46443_) {
                this.initFillTick();
                this.countNearbyWells(be -> {
                    ++be.nearbyWells;
                    ++this.nearbyWells;
                });
            }
        }
        if (((WellFluidTank)this.tank).updateLight(this.tank.getFluid())) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    protected FluidStack getFluidToFill() {
        return WellConfig.getFillFluid((Biome)this.f_58857_.m_204166_(this.m_58899_()).m_203334_(), this.f_58857_, this.m_58899_(), this.isUpsideDown(), this.nearbyWells);
    }

    protected void initFillTick() {
        this.fillTick = WellConfig.getFillDelay((Biome)this.f_58857_.m_204166_(this.m_58899_()).m_203334_(), this.f_58857_, this.f_58857_.f_46441_, this.isUpsideDown());
    }

    public void countNearbyWells(Consumer<WellBlockEntity> updateScript) {
        this.f_58857_.m_46745_(this.m_58899_()).m_5928_().forEach(otherPos -> {
            BlockEntity be;
            if (!otherPos.equals((Object)this.m_58899_()) && (be = this.f_58857_.m_7702_(otherPos)) instanceof WellBlockEntity && ((WellBlockEntity)be).isUpsideDown() == this.isUpsideDown()) {
                updateScript.accept((WellBlockEntity)be);
            }
        });
    }

    public boolean isUpsideDown() {
        return (Boolean)this.m_58900_().m_61143_((Property)WellBlock.UPSIDE_DOWN);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fillTick = tag.m_128451_("FillTick");
        this.nearbyWells = Math.max(1, tag.m_128451_("NearbyWells"));
        this.initialized = tag.m_128471_("Initialized");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("FillTick", this.fillTick);
        tag.m_128405_("NearbyWells", this.nearbyWells);
        tag.m_128379_("Initialized", this.initialized);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        boolean wasFull;
        FluidStack oldFluid = this.tank.getFluid();
        this.handleUpdateTag(pkt.m_131708_());
        FluidStack newFluid = this.tank.getFluid();
        boolean wasEmpty = newFluid != null && oldFluid == null;
        boolean bl = wasFull = newFluid == null && oldFluid != null;
        if (wasEmpty || wasFull || newFluid != null && newFluid.getAmount() != oldFluid.getAmount()) {
            if (newFluid != null) {
                ((WellFluidTank)this.tank).updateLight(newFluid);
            } else {
                ((WellFluidTank)this.tank).updateLight(oldFluid);
            }
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public static class WellFluidTank
    extends FluidTank {
        private WellBlockEntity well;

        public WellFluidTank(WellBlockEntity well, int capacity) {
            super(capacity);
            this.well = well;
            this.setValidator(fluid -> {
                boolean isLighterThanAir = fluid.getFluid().getFluidType().isLighterThanAir();
                if (this.well.isUpsideDown()) {
                    return isLighterThanAir;
                }
                if (isLighterThanAir) {
                    return false;
                }
                return !this.well.m_58904_().m_6042_().f_63857_() || !fluid.getFluid().getFluidType().isVaporizedOnPlacement(this.well.m_58904_(), this.well.m_58899_(), fluid);
            });
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            int fill;
            int n = fill = this.well.getFluidToFill().getFluid() == resource.getFluid() ? super.fill(resource, action) : 0;
            if (action.execute() && fill > 0) {
                BlockState state = this.well.m_58900_();
                this.well.m_58904_().m_7260_(this.well.m_58899_(), state, state, 3);
                this.updateLight(resource);
            }
            return fill;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack resource = super.drain(maxDrain, action);
            if (resource != null && action.execute()) {
                BlockState state = this.well.m_58900_();
                this.well.m_58904_().m_7260_(this.well.m_58899_(), state, state, 3);
                this.updateLight(resource);
            }
            return resource;
        }

        protected boolean updateLight(FluidStack resource) {
            if (resource != null && resource.getFluid().getFluidType().getLightLevel(resource.getFluid().m_76145_(), (BlockAndTintGetter)this.well.m_58904_(), this.well.m_58899_()) > 0) {
                this.well.m_58904_().m_5518_().m_7174_(this.well.m_58899_());
                return true;
            }
            return false;
        }
    }
}

