/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.impl.GasParticle;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.util.helpers.vfx.Color;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;

public class MistParticle
extends GasParticle {
    protected MistParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, sprites, x, y, z, dx, dy, dz);
        this.f_107204_ = this.f_107231_ = this.f_107223_.m_188501_() * ((float)Math.PI * 2);
        this.baseColor = Color.fromRGBA(data.rgba0);
        this.groundFriction = 0.3f;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = time / this.duration;
        float q = 2.0f * progress - 1.0f;
        q *= q;
        this.setColor0(this.baseColor.scaleAlpha(Math.max((1.0f - q * q) * MathHelper.cos(0.7853982f * progress), 0.0f)));
        this.size = this.f_107221_ * MathHelper.sin(0.7853982f * (progress + 1.0f));
        super.render(stack, buffer, consumer, packedLight, time, pTicks);
    }

    @Nonnull
    public static ParticleProvider<ColorParticleOptions> factory(SpriteSet spriteSet) {
        return (data, level, x, y, z, dx, dy, dz) -> new MistParticle((ColorParticleOptions)data, level, spriteSet, x, y, z, dx, dy, dz);
    }
}

