/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.compat.iris;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.vicmatskiv.pointblank.client.ClientSystem;
import com.vicmatskiv.pointblank.client.render.Flushable;
import com.vicmatskiv.pointblank.client.render.RenderTypeKey;
import com.vicmatskiv.pointblank.client.render.RenderTypeProvider;
import com.vicmatskiv.pointblank.compat.iris.IrisAuxShaderProvider;
import java.io.FileNotFoundException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.lwjgl.opengl.GL11;

public class IrisRenderTypeProvider
extends RenderStateShard
implements RenderTypeProvider {
    private final Function<RenderTypeKey, RenderType> pipRenderTypes = Util.m_143827_(this::createPipRenderType);
    private final Function<RenderTypeKey, RenderType> pipMaskRenderTypes = Util.m_143827_(key -> this.createPipMaskRenderType((RenderTypeKey)key, this::getPipMaskShader));
    private final Function<RenderTypeKey, RenderType> pipOverlayRenderTypes = Util.m_143827_(key -> IrisRenderTypeProvider.createPipOverlayRenderType(key, GameRenderer::m_172820_));
    private final Function<ResourceLocation, RenderType> reticleRenderTypes = Util.m_143827_(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));
    private final Function<ResourceLocation, RenderType> reticleRenderTypesWithParallax = Util.m_143827_(texture -> IrisRenderTypeProvider.createReticleRenderType(IrisRenderTypeProvider.getIrisTexture(texture), GameRenderer::m_172820_));
    private final Function<ResourceLocation, RenderType> glowRenderTypes = Util.m_143827_(texture -> IrisRenderTypeProvider.createGlowRenderType(IrisRenderTypeProvider.getIrisTexture(texture)));
    private final Function<RenderTypeKey, RenderType> defaultItemRenderTypes = Util.m_143827_(IrisRenderTypeProvider::createDefaultItemRenderType);
    private final Function<RenderTypeKey, RenderType> pipShutterOverlayRenderTypes = Util.m_143827_(this::createPipShutterOverlayRenderType);
    private final Function<ResourceLocation, RenderType> muzzleFlashRenderTypes = Util.m_143827_(IrisRenderTypeProvider::createMuzzleFlashRenderType);

    public IrisRenderTypeProvider() {
        super(null, null, null);
    }

    @Override
    public MultiBufferSource wrapBufferSource(MultiBufferSource source) {
        return new WrappedBufferSource(source);
    }

    @Override
    public RenderType getDefaultItemRenderType(RenderTypeKey key) {
        return this.defaultItemRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipShutterOverlayRenderType(RenderTypeKey key) {
        return this.pipShutterOverlayRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipRenderType(RenderTypeKey key) {
        return this.pipRenderTypes.apply(key);
    }

    private ShaderInstance getPipShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxShader();
        }
        if (shader == null) {
            shader = GameRenderer.m_172820_();
        }
        return shader;
    }

    private ShaderInstance getPipOverlayShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankAuxPlainShader();
        }
        if (shader == null) {
            shader = GameRenderer.m_172820_();
        }
        return shader;
    }

    private ShaderInstance getPipMaskShader() {
        WorldRenderingPipeline pipeline = Iris.getPipelineManager().getPipeline().orElse(null);
        ShaderInstance shader = null;
        if (pipeline instanceof IrisAuxShaderProvider) {
            IrisAuxShaderProvider auxShaderProvider = (IrisAuxShaderProvider)pipeline;
            shader = auxShaderProvider.getPointblankMaskShader();
        }
        if (shader == null) {
            shader = GameRenderer.m_172820_();
        }
        return shader;
    }

    @Override
    public RenderType getPipOverlayRenderType(RenderTypeKey key) {
        return this.pipOverlayRenderTypes.apply(key);
    }

    @Override
    public RenderType getPipMaskRenderType(RenderTypeKey key) {
        return this.pipMaskRenderTypes.apply(key);
    }

    @Override
    public RenderType getGlowRenderType(ResourceLocation texture) {
        return this.glowRenderTypes.apply(texture);
    }

    @Override
    public RenderType getGlowBlockEntityRenderType(ResourceLocation texture) {
        return RenderType.m_110473_((ResourceLocation)texture);
    }

    @Override
    public RenderType getMuzzleFlashRenderType(ResourceLocation texture) {
        return this.muzzleFlashRenderTypes.apply(texture);
    }

    @Override
    public RenderType getReticleRenderType(ResourceLocation texture, boolean isParallaxEnabled) {
        return isParallaxEnabled ? this.reticleRenderTypesWithParallax.apply(texture) : this.reticleRenderTypes.apply(texture);
    }

    private static ResourceLocation getIrisTexture(ResourceLocation originalTexture) {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager resourceManager = mc.m_91098_();
        String path = originalTexture.m_135815_();
        if (path.endsWith(".png")) {
            String modifiedPath = path.replace(".png", "_iris.png");
            ResourceLocation irisTexture = new ResourceLocation(originalTexture.m_135827_(), modifiedPath);
            try {
                resourceManager.m_215593_(irisTexture);
                return irisTexture;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return originalTexture;
    }

    private static RenderType createDefaultItemRenderType(RenderTypeKey key) {
        Runnable setup = key.isStencilEnabled() ? () -> SETUP_STENCIL_RENDER.accept(key) : () -> {};
        Runnable clear = key.isStencilEnabled() ? () -> CLEAR_STENCIL_RENDER.accept(key) : () -> {};
        RenderType baseRenderType = RenderType.m_110458_((ResourceLocation)key.texture());
        return RenderTypeProvider.wrapAsCompositeRenderType(baseRenderType, setup, clear);
    }

    private static RenderType createReticleRenderType(ResourceLocation texture, Supplier<ShaderInstance> shaderSupplier) {
        return RenderType.m_173215_((String)"pointblank:reticle_iris_with_parallax", (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).m_110691_(false));
    }

    private static RenderType createReticleRenderType(ResourceLocation texture) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(f_234323_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_110685_(f_110139_).m_110661_(f_110110_).m_110691_(true);
        return RenderType.m_173215_((String)"pointblank:reticle_iris", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState);
    }

    private RenderType createPipRenderType(RenderTypeKey key) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(this::getPipShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)new PipTextureStateShard()).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(true);
        Consumer<RenderTypeKey> setup = key.isStencilEnabled() ? SETUP_STENCIL_RENDER : k -> {};
        Consumer<RenderTypeKey> clear = key.isStencilEnabled() ? CLEAR_STENCIL_RENDER : k -> {};
        return RenderTypeProvider.wrapAsBaseRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_iris_" + key), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState), () -> setup.accept(key), () -> clear.accept(key));
    }

    private RenderType createPipShutterOverlayRenderType(RenderTypeKey key) {
        RenderType.CompositeState compositeState = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172811_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new PipTextureStateShard()).m_110685_(f_110134_).m_110671_(f_110153_).m_110677_(f_110155_).m_110691_(true);
        Consumer<RenderTypeKey> setup = key.isStencilEnabled() ? RenderTypeProvider.SETUP_STENCIL_MASK_UPDATE_RENDER : k -> {};
        Consumer<RenderTypeKey> clear = key.isStencilEnabled() ? RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER : k -> {};
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_shutter_iris_" + key), (VertexFormat)DefaultVertexFormat.f_85815_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)compositeState), () -> setup.accept(key), () -> clear.accept(key));
    }

    private RenderType createPipMaskRenderType(RenderTypeKey key, Supplier<ShaderInstance> shaderSupplier) {
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_mask_iris" + key), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110663_(f_110111_).m_110671_(f_110153_).m_110677_(f_110155_).m_110685_(f_110134_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(IrisRenderTypeProvider.getIrisTexture(key.texture()), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).m_110691_(false)), () -> RenderTypeProvider.SETUP_STENCIL_MASK_RENDER.accept(key), () -> RenderTypeProvider.CLEAR_STENCIL_MASK_RENDER.accept(key));
    }

    private static RenderType createPipOverlayRenderType(RenderTypeKey key, Supplier<ShaderInstance> shaderSupplier) {
        Consumer<RenderTypeKey> setup = key.isStencilEnabled() ? SETUP_STENCIL_RENDER : k -> {};
        Consumer<RenderTypeKey> clear = key.isStencilEnabled() ? CLEAR_STENCIL_RENDER : k -> {};
        return RenderTypeProvider.wrapAsBaseRenderType((RenderType)RenderType.m_173215_((String)("pointblank:pip_overlay_iris_" + key), (VertexFormat)DefaultVertexFormat.f_85819_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110153_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(IrisRenderTypeProvider.getIrisTexture(key.texture()), false, false)).m_173292_(new RenderStateShard.ShaderStateShard(shaderSupplier::get)).m_110691_(false)), () -> setup.accept(key), () -> clear.accept(key));
    }

    private static RenderType createGlowRenderType(ResourceLocation glowTexture) {
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.m_173215_((String)"pointblank:glow_iris", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110139_).m_110661_(f_110110_).m_110663_(f_110113_).m_110671_(f_110152_).m_110677_(f_110155_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(glowTexture, false, false)).m_173292_(RenderStateShard.f_234323_).m_110691_(false)), () -> {
            GL11.glEnable((int)2960);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.stencilFunc((int)517, (int)2, (int)255);
        }, () -> GL11.glDisable((int)2960));
    }

    private static RenderType createMuzzleFlashRenderType(ResourceLocation texture) {
        return RenderTypeProvider.wrapAsCompositeRenderType((RenderType)RenderType.m_173215_((String)"pointblank:muzzle_flash_iris", (VertexFormat)DefaultVertexFormat.f_85812_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_110685_(RenderStateShard.f_110135_).m_110661_(f_110110_).m_110663_(f_110113_).m_110687_(f_110115_).m_110671_(f_110152_).m_110677_(f_110154_).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(texture, false, false)).m_173292_(RenderStateShard.f_234323_).m_110691_(false)), () -> {
            GL11.glEnable((int)2960);
            RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
            RenderSystem.stencilFunc((int)517, (int)2, (int)255);
        }, () -> GL11.glDisable((int)2960));
    }

    @Override
    public float getReticleBrightness() {
        return 0.6f;
    }

    @Override
    public float getGlowBrightness() {
        return 0.6f;
    }

    private static class WrappedBufferSource
    implements MultiBufferSource,
    Flushable {
        private final MultiBufferSource delegate;

        WrappedBufferSource(MultiBufferSource delegate) {
            this.delegate = delegate;
        }

        @Override
        public void flush() {
            MultiBufferSource multiBufferSource = this.delegate;
            if (multiBufferSource instanceof FullyBufferedMultiBufferSource) {
                FullyBufferedMultiBufferSource fbmbs = (FullyBufferedMultiBufferSource)multiBufferSource;
                fbmbs.m_109911_();
            }
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            if (renderType == RenderTypeProvider.NO_RENDER_TYPE) {
                return null;
            }
            return this.delegate.m_6299_(renderType);
        }
    }

    private static class PipTextureStateShard
    extends RenderStateShard.EmptyTextureStateShard {
        public PipTextureStateShard() {
            super(() -> {
                int textureId = ClientSystem.getInstance().getAuxLevelRenderer().getRenderTarget().m_83975_();
                RenderSystem.setShaderTexture((int)0, (int)textureId);
            }, () -> {});
        }
    }
}

