/*
 * Decompiled with CFR 0.152.
 */
package com.vicmatskiv.pointblank.client;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import com.vicmatskiv.pointblank.Config;
import com.vicmatskiv.pointblank.Enableable;
import com.vicmatskiv.pointblank.Nameable;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.AttachmentHost;
import com.vicmatskiv.pointblank.attachment.AttachmentModelInfo;
import com.vicmatskiv.pointblank.attachment.Attachments;
import com.vicmatskiv.pointblank.block.entity.PrinterBlockEntity;
import com.vicmatskiv.pointblank.block.entity.WorkstationBlockEntity;
import com.vicmatskiv.pointblank.client.BiDirectionalInterpolator;
import com.vicmatskiv.pointblank.client.FirstPersonWalkingAnimationHandler;
import com.vicmatskiv.pointblank.client.GunClientState;
import com.vicmatskiv.pointblank.client.GunStateTicker;
import com.vicmatskiv.pointblank.client.LockableTarget;
import com.vicmatskiv.pointblank.client.RealtimeLinearEaser;
import com.vicmatskiv.pointblank.client.ThrowableClientState;
import com.vicmatskiv.pointblank.client.controller.AbstractProceduralAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunJumpAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRandomizingAnimationController;
import com.vicmatskiv.pointblank.client.controller.GunRecoilAnimationController;
import com.vicmatskiv.pointblank.client.controller.InertiaController;
import com.vicmatskiv.pointblank.client.controller.PostPassEffectController;
import com.vicmatskiv.pointblank.client.controller.PryAnimationController;
import com.vicmatskiv.pointblank.client.controller.TimerController;
import com.vicmatskiv.pointblank.client.controller.ViewShakeAnimationController2;
import com.vicmatskiv.pointblank.client.gui.AttachmentManagerScreen;
import com.vicmatskiv.pointblank.client.gui.CraftingScreen;
import com.vicmatskiv.pointblank.client.gui.GunItemOverlay;
import com.vicmatskiv.pointblank.client.gui.SettingsScreen;
import com.vicmatskiv.pointblank.client.particle.EffectParticles;
import com.vicmatskiv.pointblank.client.render.BaseModelBlockRenderer;
import com.vicmatskiv.pointblank.client.render.CrosshairRenderer;
import com.vicmatskiv.pointblank.client.render.RenderUtil;
import com.vicmatskiv.pointblank.compat.playeranimator.PlayerAnimatorCompat;
import com.vicmatskiv.pointblank.entity.EntityBuilder;
import com.vicmatskiv.pointblank.event.RenderHandEvent;
import com.vicmatskiv.pointblank.explosion.ExplosionEvent;
import com.vicmatskiv.pointblank.feature.AimingFeature;
import com.vicmatskiv.pointblank.feature.FeatureProvider;
import com.vicmatskiv.pointblank.feature.PipFeature;
import com.vicmatskiv.pointblank.item.ExplosionDescriptor;
import com.vicmatskiv.pointblank.item.GunItem;
import com.vicmatskiv.pointblank.item.ThrowableItem;
import com.vicmatskiv.pointblank.network.AimingChangeRequestPacket;
import com.vicmatskiv.pointblank.network.Network;
import com.vicmatskiv.pointblank.registry.BlockEntityRegistry;
import com.vicmatskiv.pointblank.registry.BlockModelRegistry;
import com.vicmatskiv.pointblank.registry.EntityRegistry;
import com.vicmatskiv.pointblank.registry.MenuRegistry;
import com.vicmatskiv.pointblank.registry.ParticleRegistry;
import com.vicmatskiv.pointblank.registry.ThirdPersonAnimationRegistry;
import com.vicmatskiv.pointblank.util.ClientUtil;
import com.vicmatskiv.pointblank.util.HitScan;
import com.vicmatskiv.pointblank.util.MiscUtil;
import com.vicmatskiv.pointblank.util.UpDownCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.CameraType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import org.joml.Vector2ic;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.ClientUtils;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)"pointblank");
    public static final Lazy<KeyMapping> RELOAD_KEY = Lazy.of(() -> new KeyMapping("key.pointblack.reload", InputConstants.Type.KEYSYM, 82, "key.categories.pointblank"));
    public static final Lazy<KeyMapping> FIRE_MODE_KEY = Lazy.of(() -> new KeyMapping("key.pointblack.firemode", InputConstants.Type.KEYSYM, 66, "key.categories.pointblank"));
    public static final Lazy<KeyMapping> INSPECT_KEY = Lazy.of(() -> new KeyMapping("key.pointblack.inspect", InputConstants.Type.KEYSYM, 73, "key.categories.pointblank"));
    public static final Lazy<KeyMapping> ATTACHMENT_KEY = Lazy.of(() -> new KeyMapping("key.pointblack.attachments", InputConstants.Type.KEYSYM, 89, "key.categories.pointblank"));
    public static final Lazy<KeyMapping> SCOPE_SWITCH_KEY = Lazy.of(() -> new KeyMapping("key.pointblack.scope_switch", InputConstants.Type.KEYSYM, 86, "key.categories.pointblank"));
    public static final Lazy<KeyMapping> SETTINGS_KEY = Lazy.of(() -> new KeyMapping("key.pointblack.settings", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 89, "key.categories.pointblank"));
    private static ReentrantLock mainLoopLock = new ReentrantLock();
    private InertiaController scopeInertiaController = new InertiaController(0.06, 0.2, 0.1);
    private InertiaController inertiaController = new InertiaController(0.01, 0.1, 1.2217304706573486);
    public static InertiaController reticleInertiaController = new InertiaController(0.005, 0.05, 1.0);
    private GunJumpAnimationController jumpController = new GunJumpAnimationController(0.3, 0.8, 1.3, 0.05, 2000L);
    private ViewShakeAnimationController2 sharedViewShakeController = new ViewShakeAnimationController2(0.15, 0.3, 1.0, 0.01, 500L);
    private int currentInventorySlot;
    private int previousInventorySlot;
    private boolean inventorySlotChanged;
    private boolean currentSlotHasGun;
    private boolean currentSlotHasGunChanged;
    private boolean leftMouseButtonDown = false;
    private boolean rightMouseButtonDown = false;
    private float previousPlayerXRot;
    private float previousPlayerYRot;
    private float playerDeltaXRot;
    private float playerDeltaYRot;
    private double previousPlayerPosX;
    private double previousPlayerPosY;
    private double previousPlayerPosZ;
    private double playerDeltaX;
    private double playerDeltaY;
    private double playerDeltaZ;
    private static LivingEntity currentEntityLiving;
    private RealtimeLinearEaser bobbingValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser bobbingYawValue = new RealtimeLinearEaser(200L);
    private RealtimeLinearEaser zoomValue = new RealtimeLinearEaser(200L);
    private static boolean isPipFallbackZoomActive;
    private static double gunFov;
    private RealtimeLinearEaser crossHairExp = new RealtimeLinearEaser(100L);
    private LockableTarget lockableTarget = new LockableTarget();
    private static PostPassEffectController postPassEffectController;
    private static final ResourceLocation crossHairOverlay;
    private final FirstPersonWalkingAnimationHandler firstPersonWalkingAnimationHandler = new FirstPersonWalkingAnimationHandler();

    public ClientEventHandler() {
        this.startTicker();
    }

    private void startTicker() {
        GunStateTicker gunStateTicker = new GunStateTicker(this);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> gunStateTicker.shutdown()));
        gunStateTicker.start();
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            this.currentInventorySlot = -1;
        }
    }

    @SubscribeEvent
    public void onExplosion(ExplosionEvent event) {
        double distanceToPlayer = event.getLocation().m_82554_(ClientUtils.getClientPlayer().m_20182_());
        ExplosionDescriptor descriptor = event.getExplosionDescriptor();
        distanceToPlayer = Mth.m_14008_((double)distanceToPlayer, (double)1.0, (double)Double.MAX_VALUE);
        double lambda = 0.2;
        double adjustedPower = (double)descriptor.power() * Math.exp(-lambda * distanceToPlayer);
        this.sharedViewShakeController.reset(adjustedPower, 0.5, 1.5, 0.01);
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Player player = ClientUtils.getClientPlayer();
        if (event.phase == TickEvent.Phase.START) {
            GunClientState state;
            mainLoopLock.lock();
            if (player != null && (state = GunClientState.getMainHeldState()) != null) {
                ItemStack gunStack = GunItem.getMainHeldGunItemStack((LivingEntity)player);
                Minecraft mc = Minecraft.m_91087_();
                state.renderTick((LivingEntity)player, gunStack, event.renderTickTime);
                if (!mc.f_91066_.m_92176_().m_90612_()) {
                    return;
                }
                GunItem gunItem = state.getGunItem();
                ItemDisplayContext itemDisplayContext = ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
                this.inertiaController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, event.renderTickTime);
                if (gunItem.getScopeOverlay() != null && state.isAiming() && state.isFiring()) {
                    this.scopeInertiaController.setDynamicModifier(0.01f);
                } else {
                    this.scopeInertiaController.setDynamicModifier(1.0f);
                }
                this.scopeInertiaController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, event.renderTickTime);
                this.jumpController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, event.renderTickTime);
                postPassEffectController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, event.renderTickTime);
                this.sharedViewShakeController.onRenderTick((LivingEntity)player, state, gunStack, itemDisplayContext, event.renderTickTime);
            }
        } else if (event.phase == TickEvent.Phase.END && mainLoopLock.isLocked()) {
            mainLoopLock.unlock();
        }
    }

    public static PostPassEffectController getPostPassEffectController() {
        return postPassEffectController;
    }

    private boolean autoReloadEnabled(Player player) {
        Config.AutoReload autoReload = (Config.AutoReload)((Object)Config.AUTO_RELOAD.get());
        return autoReload == Config.AutoReload.ENABLED || autoReload == Config.AutoReload.CREATIVE && player.m_7500_() || autoReload == Config.AutoReload.SURVIVAL && !player.m_7500_();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (event.phase == TickEvent.Phase.START) {
            mainLoopLock.lock();
        } else if (event.phase == TickEvent.Phase.END) {
            if (player != null) {
                GunClientState state;
                Enableable e;
                boolean isEnabled;
                boolean updatedSlotHasGun;
                this.playerDeltaX = player.m_20185_() - this.previousPlayerPosX;
                this.playerDeltaY = player.m_20186_() - this.previousPlayerPosY;
                this.playerDeltaZ = player.m_20189_() - this.previousPlayerPosZ;
                this.previousPlayerPosX = player.m_20185_();
                this.previousPlayerPosY = player.m_20186_();
                this.previousPlayerPosZ = player.m_20189_();
                this.playerDeltaXRot = player.m_146909_() - this.previousPlayerXRot;
                this.playerDeltaYRot = player.m_146908_() - this.previousPlayerYRot;
                this.previousPlayerXRot = player.m_146909_();
                this.previousPlayerYRot = player.m_146908_();
                ItemStack heldItem = player.m_21205_();
                int activeSlot = player.m_150109_().f_35977_;
                if (activeSlot != this.currentInventorySlot) {
                    this.inventorySlotChanged = true;
                    this.previousInventorySlot = this.currentInventorySlot;
                    this.currentInventorySlot = activeSlot;
                } else {
                    this.inventorySlotChanged = false;
                }
                boolean bl = updatedSlotHasGun = heldItem != null && heldItem.m_41720_() instanceof GunItem;
                if (updatedSlotHasGun != this.currentSlotHasGun) {
                    this.currentSlotHasGun = updatedSlotHasGun;
                    this.currentSlotHasGunChanged = true;
                } else {
                    this.currentSlotHasGunChanged = false;
                }
                Item item = heldItem.m_41720_();
                boolean bl2 = isEnabled = !(item instanceof Enableable) || (e = (Enableable)item).isEnabled();
                if (isEnabled && this.autoReloadEnabled((Player)player) && heldItem.m_41720_() instanceof GunItem && !this.inventorySlotChanged) {
                    LazyOptional<Integer> optionalAmmo = GunItem.getClientSideAmmo((Player)player, heldItem, this.currentInventorySlot);
                    optionalAmmo.ifPresent(ammo -> {
                        if (ammo <= 0) {
                            ((GunItem)heldItem.m_41720_()).tryReload((Player)player, heldItem);
                        }
                    });
                }
                while (isEnabled && ((KeyMapping)RELOAD_KEY.get()).m_90859_() && !this.inventorySlotChanged) {
                    if (!(heldItem.m_41720_() instanceof GunItem)) continue;
                    ((GunItem)heldItem.m_41720_()).tryReload((Player)player, heldItem);
                }
                while (((KeyMapping)FIRE_MODE_KEY.get()).m_90859_()) {
                    state = GunClientState.getMainHeldState();
                    if (state == null) continue;
                    state.tryChangeFireMode((LivingEntity)player, player.m_21205_());
                }
                while (((KeyMapping)INSPECT_KEY.get()).m_90859_() && !this.inventorySlotChanged) {
                    state = GunClientState.getMainHeldState();
                    if (state == null) continue;
                    state.tryInspect((LivingEntity)player, player.m_21205_());
                }
                while (((KeyMapping)ATTACHMENT_KEY.get()).m_90859_()) {
                    if (heldItem == null || !(heldItem.m_41720_() instanceof AttachmentHost)) continue;
                    Attachments.tryAttachmentMode((Player)player, heldItem);
                }
                boolean leftMouseButtonDown = mc.f_91066_.f_92096_.m_90857_();
                if (leftMouseButtonDown && !this.leftMouseButtonDown) {
                    this.leftMouseDown();
                } else if (!leftMouseButtonDown && this.leftMouseButtonDown) {
                    this.leftMouseButtonRelease();
                }
                this.leftMouseButtonDown = leftMouseButtonDown;
                boolean rightMouseButtonDown = mc.f_91066_.f_92095_.m_90857_();
                if (rightMouseButtonDown && !this.rightMouseButtonDown) {
                    this.rightMouseButtonDown();
                } else if (!rightMouseButtonDown && this.rightMouseButtonDown) {
                    this.rightMouseButtonRelease();
                }
                GunClientState state2 = GunClientState.getMainHeldState();
                while (((KeyMapping)SCOPE_SWITCH_KEY.get()).m_90859_()) {
                    if (heldItem == null || !(heldItem.m_41720_() instanceof GunItem) || state2 == null || !state2.isAiming()) continue;
                    Attachments.tryNextAttachment((Player)player, heldItem, AttachmentCategory.SCOPE, AimingFeature.class);
                }
                if (heldItem.m_41720_() instanceof LockableTarget.TargetLocker) {
                    this.lockableTarget.setLocker((LockableTarget.TargetLocker)heldItem.m_41720_());
                } else {
                    this.lockableTarget.setLocker(null);
                }
                if (state2 != null && state2.isAiming() && state2.isIdle() && this.lockableTarget.getLockTimeTicks() > 0L) {
                    HitResult hitResult = HitScan.getNearestObjectInCrosshair((LivingEntity)player, 0.0f, 400.0, b -> false, b -> false, new ArrayList<BlockPos>());
                    if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                        Entity hitScanEntity = ((EntityHitResult)hitResult).m_82443_();
                        if (MiscUtil.isProtected(hitScanEntity) || !this.lockableTarget.tryLock(hitScanEntity)) {
                            this.lockableTarget.unlock(hitScanEntity);
                        }
                    } else {
                        this.lockableTarget.unlock(null);
                    }
                } else {
                    this.lockableTarget.unlock(null);
                }
                if (this.inventorySlotChanged) {
                    ThrowableClientState throwableState;
                    this.lockableTarget.unlock(null);
                    this.inertiaController.reset((Player)player);
                    this.scopeInertiaController.reset();
                    reticleInertiaController.reset();
                    if (this.previousInventorySlot >= 0) {
                        Object previousState;
                        Item item2;
                        ItemStack previousStack = player.m_150109_().m_8020_(this.previousInventorySlot);
                        if (previousStack != null && (item2 = previousStack.m_41720_()) instanceof GunItem) {
                            AnimationController<GeoAnimatable> walkingController;
                            GunItem previousGunItem = (GunItem)item2;
                            previousState = GunClientState.getState((Player)player, previousStack, this.previousInventorySlot, false);
                            if (previousState != null) {
                                ((GunClientState)previousState).tryDeactivate((LivingEntity)player, previousStack);
                            }
                            if ((walkingController = previousGunItem.getGeoAnimationController("walking", previousStack)) != null) {
                                walkingController.tryTriggerAnimation("animation.model.standing");
                            }
                        } else if (previousStack != null && previousStack.m_41720_() instanceof ThrowableItem && (previousState = ThrowableClientState.getState((Player)player, previousStack, this.previousInventorySlot, false)) != null) {
                            ((ThrowableClientState)previousState).tryDeactivate((LivingEntity)player, previousStack);
                        }
                    }
                    ItemStack mainHeldItem = player.m_21205_();
                    if (state2 != null) {
                        state2.tryDraw((LivingEntity)player, mainHeldItem);
                        if (heldItem.m_41720_() instanceof GunItem) {
                            this.firstPersonWalkingAnimationHandler.reset((Player)player, heldItem);
                        }
                    } else if (mainHeldItem.m_41720_() instanceof ThrowableItem && (throwableState = ThrowableClientState.getMainHeldState()) != null) {
                        throwableState.tryDraw((LivingEntity)player, mainHeldItem);
                    }
                }
                if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                    this.jumpController.reset();
                }
                this.leftMouseButtonDown = leftMouseButtonDown;
                this.rightMouseButtonDown = rightMouseButtonDown;
            }
            mainLoopLock.unlock();
        }
    }

    @SubscribeEvent
    public void onRenderLivingEvent(RenderLivingEvent.Pre<LivingEntity, EntityModel<LivingEntity>> e) {
        currentEntityLiving = e.getEntity();
        if (e.getEntity() instanceof Player) {
            Player player = (Player)e.getEntity();
            ItemStack itemStack = player.m_21205_();
            int activeSlot = player.m_150109_().f_35977_;
            if (itemStack != null && itemStack.m_41720_() instanceof GunItem && !PlayerAnimatorCompat.getInstance().isEnabled()) {
                LivingEntityRenderer r;
                EntityModel model;
                GunClientState gunClientState = GunClientState.getState(player, itemStack, activeSlot, false);
                if ((Config.thirdPersonArmPoseAlwaysOn || gunClientState != null && (gunClientState.isAiming() || gunClientState.isFiring())) && (model = (r = e.getRenderer()).m_7200_()) instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)model;
                    playerModel.f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
                }
            }
            Minecraft mc = Minecraft.m_91087_();
            this.handlePlayerFirstPersonMovement(player, itemStack);
            if (Config.thirdPersonAnimationsEnabled) {
                PlayerAnimatorCompat.getInstance().handlePlayerThirdPersonMovement(player, mc.getPartialTick());
            } else {
                PlayerAnimatorCompat.getInstance().clearAll(player);
            }
        }
    }

    public void onRenderLivingEvent(RenderLivingEvent.Post<LivingEntity, EntityModel<LivingEntity>> e) {
        currentEntityLiving = null;
    }

    public static LivingEntity getCurrentEntityLiving() {
        return currentEntityLiving;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderGameOverlay(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (mc.f_91080_ instanceof AttachmentManagerScreen) {
            return;
        }
        ItemStack stack = mc.f_91074_.m_21205_();
        GuiGraphics guiGraphics = event.getGuiGraphics();
        if (stack != null && stack.m_41720_() instanceof GunItem) {
            GunItemOverlay.renderGunOverlay2(guiGraphics, stack);
        }
    }

    @SubscribeEvent
    public void onFovUpdate(ViewportEvent.ComputeFov event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91074_.m_21205_().m_41619_() || minecraft.f_91066_.m_92176_() != CameraType.FIRST_PERSON) {
            isPipFallbackZoomActive = false;
            return;
        }
        ItemStack itemStack = minecraft.f_91074_.m_21205_();
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            isPipFallbackZoomActive = false;
            return;
        }
        int activeSlot = minecraft.f_91074_.m_150109_().f_35977_;
        GunClientState gunClientState = GunClientState.getState((Player)minecraft.f_91074_, itemStack, activeSlot, false);
        if (gunClientState != null) {
            boolean isFallbackActive = this.isPipFallbackActive(itemStack);
            float fullZoom = this.zoomValue.update(AimingFeature.getZoom(itemStack));
            BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)gunClientState.getAnimationController("aiming");
            float aimingProgress = (float)aimingController.getValue();
            float fullZoomAdj = fullZoom * aimingProgress;
            float baseZoom = AimingFeature.getBaseZoom(itemStack);
            float baseZoomAdj = baseZoom * aimingProgress;
            double baseFov = event.getFOV();
            double worldFov = baseFov - baseFov * (double)fullZoomAdj - (double)((float)this.sharedViewShakeController.getRoll());
            gunFov = baseFov - baseFov * (double)baseZoomAdj - (double)((float)this.sharedViewShakeController.getRoll());
            isPipFallbackZoomActive = isFallbackActive && fullZoomAdj > baseZoomAdj;
            event.setFOV(worldFov);
        } else {
            isPipFallbackZoomActive = false;
        }
    }

    private boolean isPipFallbackActive(ItemStack itemStack) {
        PipFeature pipFeature = this.getActivePipFeature(itemStack);
        return pipFeature != null && pipFeature.isFallbackRequired();
    }

    private PipFeature getActivePipFeature(ItemStack itemStack) {
        Item item;
        ItemStack selectedStack;
        Pair<String, ItemStack> selected = Attachments.getSelectedAttachment(itemStack, AttachmentCategory.SCOPE);
        ItemStack itemStack2 = selectedStack = selected != null ? (ItemStack)selected.getSecond() : itemStack;
        if (selectedStack != null && (item = selectedStack.m_41720_()) instanceof FeatureProvider) {
            FeatureProvider fp = (FeatureProvider)item;
            return fp.getFeature(PipFeature.class);
        }
        return null;
    }

    public static boolean isPipFallbackZoomActive() {
        return isPipFallbackZoomActive;
    }

    public static double getGunFov() {
        return gunFov;
    }

    @SubscribeEvent
    public void onRenderHandEvent(RenderHandEvent event) {
        Item item;
        ItemStack heldItem = event.getItemStack();
        if (event.getHand() == InteractionHand.MAIN_HAND && (item = heldItem.m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            int slot = ClientUtils.getClientPlayer().m_150109_().m_36030_(heldItem);
            Minecraft minecraft = Minecraft.m_91087_();
            GunClientState gunClientState = GunClientState.getState((Player)minecraft.f_91074_, heldItem, slot, false);
            if (gunClientState != null) {
                GunRecoilAnimationController recoilController;
                GunRandomizingAnimationController randomizerController;
                Player player;
                if (((Boolean)minecraft.f_91066_.m_231830_().m_231551_()).booleanValue() && minecraft.m_91288_() instanceof Player) {
                    float targetYaw;
                    player = (Player)minecraft.m_91288_();
                    PoseStack poseStack = event.getPoseStack();
                    float f = player.f_19787_ - player.f_19867_;
                    float partialTick = event.getPartialTick();
                    float walkDistance = -(player.f_19787_ + f * partialTick);
                    float bobbing = Mth.m_14179_((float)partialTick, (float)player.f_36099_, (float)player.f_36100_);
                    poseStack.m_252781_(Axis.f_252529_.m_252977_(-Math.abs(Mth.m_14089_((float)(walkDistance * (float)Math.PI - 0.2f)) * bobbing) * 5.0f));
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(-Mth.m_14031_((float)(walkDistance * (float)Math.PI)) * bobbing * 3.0f));
                    poseStack.m_252880_(-Mth.m_14031_((float)(walkDistance * (float)Math.PI)) * bobbing * 0.5f, Math.abs(Mth.m_14089_((float)(walkDistance * (float)Math.PI)) * bobbing), 0.0f);
                    float randomPitch = 0.0f;
                    float randomYaw = 0.0f;
                    float targetBobbing = 1.0f;
                    if (player.m_20142_()) {
                        targetYaw = 10.0f;
                        targetBobbing = gunItem.getBobbing();
                    } else if (gunClientState.isAiming()) {
                        targetBobbing = gunItem.getBobbingOnAim();
                        float afc = AimingFeature.getViewBobbing(heldItem);
                        targetYaw = 5.0f * afc;
                        targetBobbing *= afc;
                    } else {
                        targetBobbing = gunItem.getBobbing();
                        targetYaw = 5.0f;
                    }
                    if (!Config.firstPersonAnimationsEnabled) {
                        float bobbingRoll = (bobbing *= this.bobbingValue.update(targetBobbing)) * 10.0f * gunItem.getBobbingRollMultiplier();
                        float bobbingPitch = bobbing * 5.0f;
                        float bobbingYaw = bobbing * this.bobbingYawValue.update(targetYaw);
                        poseStack.m_85837_((double)(-Mth.m_14031_((float)(walkDistance * (float)Math.PI)) * bobbing * 0.5f), (double)Math.abs(Mth.m_14089_((float)(walkDistance * (float)Math.PI)) * bobbing) * 0.35 + (double)(randomPitch * 0.01f), (double)(randomYaw * 0.0f));
                        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14031_((float)(walkDistance * (float)Math.PI)) * bobbingRoll));
                        poseStack.m_252781_(Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(walkDistance * (float)Math.PI - 0.2f))) * bobbingPitch));
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14031_((float)(walkDistance * (float)Math.PI)) * bobbingYaw));
                    }
                }
                if (Config.firstPersonAnimationsEnabled) {
                    player = ClientUtil.getClientPlayer();
                    this.handlePlayerFirstPersonMovement(player, player.m_21205_());
                }
                if ((randomizerController = (GunRandomizingAnimationController)gunClientState.getAnimationController("randomizer")) != null) {
                    if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                        randomizerController.reset();
                    }
                    double posX = randomizerController.getPosX();
                    double posY = randomizerController.getPosY();
                    double posZ = randomizerController.getPosZ();
                    double roll = randomizerController.getRoll();
                    double yaw = randomizerController.getYaw();
                    double pitch = randomizerController.getPitch();
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, yaw, roll, 1.0);
                    poseStack.m_85837_(posX, posY, posZ);
                    poseStack.m_252781_(q);
                }
                if ((recoilController = (GunRecoilAnimationController)gunClientState.getAnimationController("recoil2")) != null) {
                    if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                        recoilController.reset();
                    }
                    double posX = recoilController.getPosX();
                    double posY = recoilController.getPosY();
                    double posZ = recoilController.getPosZ();
                    double roll = recoilController.getRoll();
                    double pitch = recoilController.getPitch();
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, 0.0, roll, 1.0);
                    poseStack.m_85837_(posX, posY, posZ);
                    poseStack.m_252781_(q);
                }
                if (this.jumpController != null) {
                    double jumpMultiplier = gunItem.getJumpMultiplier();
                    double posX = this.jumpController.getPosX() * jumpMultiplier;
                    double posY = this.jumpController.getPosY() * jumpMultiplier;
                    double posZ = this.jumpController.getPosZ() * jumpMultiplier;
                    double roll = this.jumpController.getRoll() * jumpMultiplier;
                    double pitch = this.jumpController.getPitch() * jumpMultiplier;
                    double yaw = this.jumpController.getYaw() * jumpMultiplier;
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(pitch, yaw, roll, 1.0);
                    poseStack.m_85837_(posX, posY, posZ);
                    poseStack.m_252781_(q);
                }
                if (this.inertiaController != null) {
                    double roll = this.inertiaController.getRoll();
                    double yaw = 0.0;
                    PoseStack poseStack = event.getPoseStack();
                    Quaternionf q = new Quaternionf(0.0, yaw, roll, 1.0);
                    poseStack.m_252781_(q);
                }
            }
        }
    }

    private void handlePlayerFirstPersonMovement(Player player, ItemStack itemStack) {
        this.firstPersonWalkingAnimationHandler.handlePlayerFirstPersonMovement(player, itemStack);
    }

    @SubscribeEvent
    public void onClickEvent(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        ItemStack heldItem = player.m_21205_();
        if (heldItem.m_41720_() instanceof GunItem || heldItem.m_41720_() instanceof ThrowableItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.f_91080_ != null) {
            return;
        }
        if (event.getAction() == 1 && ((KeyMapping)SETTINGS_KEY.get()).m_90832_(event.getKey(), event.getScanCode()) && ((KeyMapping)SETTINGS_KEY.get()).getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.IN_GAME)) {
            this.openSettingsScreen();
        }
    }

    private void openSettingsScreen() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ == null) {
            mc.m_91152_((Screen)new SettingsScreen());
        }
    }

    @SubscribeEvent
    public void onPreRenderHandEvent(RenderHandEvent.Pre event) {
        GeoBone cameraBone;
        Nameable gunItem;
        BakedGeoModel model;
        Item item;
        ItemStack itemStack = GunItem.getMainHeldGunItemStack((LivingEntity)ClientUtils.getClientPlayer());
        if (itemStack != null && (item = itemStack.m_41720_()) instanceof Nameable && (model = AttachmentModelInfo.getModel((gunItem = (Nameable)item).getName())) != null && (cameraBone = (GeoBone)model.getBone("_camera_").orElse(null)) != null) {
            PoseStack poseStack = event.getPoseStack();
            if (cameraBone.getRotY() != 0.0f) {
                poseStack.m_252781_(Axis.f_252436_.m_252961_(-cameraBone.getRotY()));
            }
            if (cameraBone.getRotX() != 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252961_(-cameraBone.getRotX()));
            }
            if (cameraBone.getRotZ() != 0.0f) {
                poseStack.m_252781_(Axis.f_252403_.m_252961_(-cameraBone.getRotZ()));
            }
        }
    }

    @SubscribeEvent
    public void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        GeoBone cameraBone;
        Nameable gunItem;
        BakedGeoModel model;
        ItemStack itemStack;
        Item roll2;
        Minecraft mc = Minecraft.m_91087_();
        if (!mc.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        GunClientState state = GunClientState.getMainHeldState();
        if (state != null) {
            TimerController reloadTimer;
            PryAnimationController shakeAnimationController = (PryAnimationController)state.getAnimationController("shake");
            if (shakeAnimationController != null) {
                float yawModifier = state.isAiming() ? 0.1f : 1.0f;
                float rollModifier = state.isAiming() ? 1.5f : 1.0f;
                event.setRoll(event.getRoll() + (float)shakeAnimationController.getRoll() * rollModifier);
                event.setYaw(event.getYaw() + (float)shakeAnimationController.getYaw() * yawModifier);
            }
            if ((reloadTimer = (TimerController)state.getAnimationController("reloadTimer")) != null && !reloadTimer.isDone()) {
                for (AbstractProceduralAnimationController activeHandler : reloadTimer.getActiveHandlers(ClientUtils.getClientPlayer(), state, ClientUtils.getClientPlayer().m_21205_())) {
                    event.setRoll(event.getRoll() + (float)activeHandler.getRoll());
                    event.setPitch(event.getPitch() + (float)activeHandler.getPitch());
                }
            }
            if (this.sharedViewShakeController != null) {
                event.setRoll(event.getRoll() + (float)this.sharedViewShakeController.getRoll() * 0.5f);
            }
            if (this.inertiaController != null) {
                double roll2 = this.inertiaController.getYaw();
                double yaw = this.inertiaController.getYaw();
                event.setRoll(event.getRoll() + (float)roll2 * 15.0f);
                event.setYaw(event.getYaw() + (float)yaw * 15.0f);
            }
        }
        if ((roll2 = (itemStack = ClientUtil.getClientPlayer().m_21205_()).m_41720_()) instanceof Nameable && (model = AttachmentModelInfo.getModel((gunItem = (Nameable)roll2).getName())) != null && (cameraBone = (GeoBone)model.getBone("_camera_").orElse(null)) != null) {
            event.setPitch(event.getPitch() - cameraBone.getRotX() * 57.295776f);
            event.setYaw(event.getYaw() - cameraBone.getRotY() * 57.295776f);
            event.setRoll(event.getRoll() - cameraBone.getRotZ() * 57.295776f);
        }
    }

    @SubscribeEvent
    public void onRenderOverlay(RenderGuiOverlayEvent.Pre event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        ItemStack itemStack = minecraft.f_91074_.m_21205_();
        if (!(itemStack.m_41720_() instanceof GunItem)) {
            return;
        }
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type() && minecraft.f_91080_ instanceof AttachmentManagerScreen) {
            event.setCanceled(true);
            return;
        }
        if (!minecraft.f_91066_.m_92176_().m_90612_()) {
            return;
        }
        int activeSlot = minecraft.f_91074_.m_150109_().f_35977_;
        GunClientState gunClientState = GunClientState.getState((Player)minecraft.f_91074_, itemStack, activeSlot, false);
        if (gunClientState == null) {
            return;
        }
        GunItem item = (GunItem)itemStack.m_41720_();
        ResourceLocation scopeOverlay = item.getScopeOverlay();
        if (event.getOverlay() == VanillaGuiOverlay.CROSSHAIR.type()) {
            if (Config.crosshairType == Config.CrosshairType.DEFAULT && !gunClientState.isAiming() && (gunClientState.isFiring() || gunClientState.isIdle())) {
                int height;
                double scaleFactor;
                float crossHairExpansionRate = this.getCrosshairExpansionRatio((Player)minecraft.f_91074_, gunClientState);
                double originalAspectRatio = 1.0;
                int width = event.getWindow().m_85445_();
                int renderWidth = (int)((double)width * (scaleFactor = 3.3));
                int renderHeight = (int)((double)renderWidth / originalAspectRatio);
                if (renderHeight > (height = event.getWindow().m_85446_())) {
                    renderHeight = (int)((double)height * scaleFactor);
                    renderWidth = (int)((double)renderHeight * originalAspectRatio);
                }
                renderWidth = 80;
                renderHeight = 80;
                float posX = (float)(width - renderWidth) / 2.0f;
                float posY = (float)(height - renderHeight) / 2.0f;
                CrosshairRenderer.renderCrosshairOverlay3(event.getGuiGraphics(), event.getPartialTick(), crossHairOverlay, crossHairExpansionRate - 1.0f, posX, posY, renderWidth, renderHeight);
            }
            if (Config.crosshairType == Config.CrosshairType.DEFAULT || Config.crosshairType == Config.CrosshairType.DISABLED) {
                event.setCanceled(true);
            }
        }
        if (gunClientState.isAiming()) {
            boolean pipZoomEnabled = MiscUtil.isGreaterThanZero(gunClientState.getGunItem().getPipScopeZoom());
            if (scopeOverlay != null && !pipZoomEnabled) {
                event.setCanceled(true);
            }
            if (!pipZoomEnabled || Config.isPipFallbackRequired()) {
                BiDirectionalInterpolator aimingController = (BiDirectionalInterpolator)gunClientState.getAnimationController("aiming");
                double aimingProgress = aimingController.getValue();
                if (aimingController != null && scopeOverlay != null && !gunClientState.isReloading()) {
                    this.renderTextureOverlay(item, gunClientState, event.getGuiGraphics(), event.getPartialTick(), item.getScopeOverlay(), event.getWindow().m_85445_(), event.getWindow().m_85446_(), (float)aimingProgress);
                }
            }
        }
    }

    protected void renderTextureOverlay(GunItem gunItem, GunClientState gunClientState, GuiGraphics guiGraphics, float partialTick, ResourceLocation textureLocation, int width, int height, float alpha) {
        GunRecoilAnimationController recoilController;
        double scaleFactor = 3.3;
        int renderWidth = (int)((double)width * scaleFactor);
        double originalAspectRatio = 1.0;
        int renderHeight = (int)((double)renderWidth / originalAspectRatio);
        if (renderHeight > height) {
            renderHeight = (int)((double)height * scaleFactor);
            renderWidth = (int)((double)renderHeight * originalAspectRatio);
        }
        float posX = (float)(width - renderWidth) / 2.0f;
        float posY = (float)(height - renderHeight) / 2.0f;
        if (this.scopeInertiaController != null) {
            double yaw = this.scopeInertiaController.getYaw();
            double pitch = this.scopeInertiaController.getPitch();
            posX = (float)((double)posX - yaw * 5000.0);
            posY = (float)((double)posY - pitch * 5000.0);
        }
        if ((recoilController = (GunRecoilAnimationController)gunClientState.getAnimationController("recoil2")) != null) {
            if (this.inventorySlotChanged || this.currentSlotHasGunChanged) {
                recoilController.reset();
            }
            double posZ1 = recoilController.getPosZ();
            posY = (float)((double)posY + posZ1 * 50.0);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
        RenderUtil.blit(guiGraphics, textureLocation, posX, posY, -90, 0.0f, 0.0f, renderWidth, renderHeight, renderWidth, renderHeight);
        ResourceLocation targetLockOverlay = gunItem.getTargetLockOverlay();
        if (targetLockOverlay != null) {
            this.renderTargetLockOverlay(guiGraphics, partialTick, targetLockOverlay, posX, posY, renderWidth, renderHeight);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTargetLockOverlay(GuiGraphics guiGraphics, float partialTick, ResourceLocation targetLockonOverlay, float posX, float posY, int renderWidth, int renderHeight) {
        UpDownCounter lockCounter = this.lockableTarget.getLockCounter();
        float targetLockCount = Mth.m_14179_((float)partialTick, (float)lockCounter.getPreviousValue(), (float)lockCounter.getCurrentValue()) / (float)lockCounter.getMaxValue();
        float lockProgress2 = 1.0f - targetLockCount;
        float lockRatio = 0.2f;
        int halfLockWidth = (int)((float)renderWidth * lockRatio * 0.5f);
        int halfLockHeight = (int)((float)renderHeight * lockRatio * 0.5f);
        float centerX = posX + (float)renderWidth * 0.5f;
        float centerY = posY + (float)renderHeight * 0.5f;
        float xOffset = (float)halfLockWidth * 0.4f * lockProgress2;
        float yOffset = (float)halfLockHeight * 0.4f * lockProgress2;
        float minU = 0.0f;
        float minV = 0.0f;
        float maxU = 0.5f;
        float maxV = 0.5f;
        float posXStart = centerX - (float)halfLockWidth - xOffset;
        float posXEnd = centerX - xOffset;
        float posYStart = centerY - (float)halfLockHeight - yOffset;
        float posYEnd = centerY - yOffset;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart, posXEnd, posYStart, posYEnd, -90.0f, minU, maxU, minV, maxV);
        float posXStart2 = centerX + xOffset;
        float posXEnd2 = centerX + (float)halfLockWidth + xOffset;
        float posYStart2 = centerY - (float)halfLockHeight - yOffset;
        float posYEnd2 = centerY - yOffset;
        float minU2 = 0.5f;
        float minV2 = 0.0f;
        float maxU2 = 1.0f;
        float maxV2 = 0.5f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
        posXStart2 = centerX + xOffset;
        posXEnd2 = centerX + (float)halfLockWidth + xOffset;
        posYStart2 = centerY + yOffset;
        posYEnd2 = centerY + (float)halfLockHeight + yOffset;
        minU2 = 0.5f;
        minV2 = 0.5f;
        maxU2 = 1.0f;
        maxV2 = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
        posXStart2 = centerX - (float)halfLockWidth - xOffset;
        posXEnd2 = centerX - xOffset;
        posYStart2 = centerY + yOffset;
        posYEnd2 = centerY + (float)halfLockHeight + yOffset;
        minU2 = 0.0f;
        minV2 = 0.5f;
        maxU2 = 0.5f;
        maxV2 = 1.0f;
        RenderUtil.blit(guiGraphics, targetLockonOverlay, posXStart2, posXEnd2, posYStart2, posYEnd2, -90.0f, minU2, maxU2, minV2, maxV2);
    }

    private void setTriggerOff(LocalPlayer player) {
        ItemStack heldItem = player.m_21205_();
        Item item = heldItem.m_41720_();
        if (item instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (player.m_20142_()) {
                player.m_6858_(false);
            } else {
                gunItem.setTriggerOff(player, heldItem);
            }
        } else {
            item = heldItem.m_41720_();
            if (item instanceof ThrowableItem) {
                ThrowableItem throwableItem = (ThrowableItem)item;
                throwableItem.setTriggerOff((Player)player, heldItem);
            }
        }
    }

    private void leftMouseDown() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        this.tryFire(player);
    }

    private void rightMouseButtonDown() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        if (player.m_20142_()) {
            player.m_6858_(false);
        }
        MiscUtil.getMainHeldGun((LivingEntity)player).ifPresent(item -> {
            if (item.isAimingEnabled()) {
                this.toggleAiming(player, true);
            }
        });
    }

    private void rightMouseButtonRelease() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        this.toggleAiming(player, false);
    }

    private void leftMouseButtonRelease() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        this.setTriggerOff(player);
    }

    public void tickMainHeldGun() {
        GunClientState state;
        Player player = ClientUtils.getClientPlayer();
        if (player != null && (state = GunClientState.getMainHeldState()) != null) {
            state.stateTick((LivingEntity)player, player.m_21205_(), true);
            this.scopeInertiaController.onUpdateState((LivingEntity)player, state);
            reticleInertiaController.onUpdateState((LivingEntity)player, state);
            this.inertiaController.onUpdateState((LivingEntity)player, state);
        }
    }

    public static void runSyncTick(Runnable runnable) {
        mainLoopLock.lock();
        try {
            runnable.run();
        }
        catch (Exception e) {
            LOGGER.error("Client sync tick failed: {}", (Throwable)e);
        }
        finally {
            mainLoopLock.unlock();
        }
    }

    public static <T> T runSyncCompute(Supplier<T> resultSupplier) {
        T result;
        mainLoopLock.lock();
        try {
            result = resultSupplier.get();
        }
        catch (Exception e) {
            LOGGER.error("Run sync compute failed: {}", (Throwable)e);
            throw e;
        }
        finally {
            mainLoopLock.unlock();
        }
        return result;
    }

    private boolean toggleAiming(LocalPlayer player, boolean isAiming) {
        int activeSlot;
        GunClientState gunClientState;
        boolean toggled = false;
        ItemStack itemStack = player.m_21205_();
        if (itemStack != null && itemStack.m_41720_() instanceof GunItem && (gunClientState = GunClientState.getState((Player)player, itemStack, activeSlot = player.m_150109_().f_35977_, false)) != null) {
            toggled = gunClientState.isAiming() != isAiming;
            gunClientState.setAiming(isAiming);
            if (toggled) {
                Network.networkChannel.sendToServer((Object)new AimingChangeRequestPacket(gunClientState.getId(), activeSlot, isAiming));
            }
        }
        return toggled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryFire(LocalPlayer player) {
        Item item;
        boolean result = false;
        ItemStack heldItemStack = player.m_21205_();
        if (heldItemStack != null && (item = heldItemStack.m_41720_()) instanceof GunItem) {
            GunItem gunItem = (GunItem)item;
            if (player.m_21206_() != heldItemStack && gunItem.isEnabled()) {
                long minTargetLockTime = gunItem.getTargetLockTimeTicks();
                if (minTargetLockTime == 0L) return gunItem.tryFire(player, heldItemStack, this.lockableTarget.getTargetEntity());
                if (!this.lockableTarget.getLockCounter().isAtMax()) return result;
                return gunItem.tryFire(player, heldItemStack, this.lockableTarget.getTargetEntity());
            }
        }
        if (heldItemStack == null) return result;
        item = heldItemStack.m_41720_();
        if (!(item instanceof ThrowableItem)) return result;
        ThrowableItem throwableItem = (ThrowableItem)item;
        if (player.m_21206_() == heldItemStack) return result;
        if (!throwableItem.isEnabled()) return result;
        return throwableItem.tryThrow((Player)player, heldItemStack, this.lockableTarget.getTargetEntity());
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent event) {
        Level level = MiscUtil.getLevel((Entity)event.getEntity());
        if (level.f_46443_ && event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            ItemStack heldItem = player.m_21205_();
            if (player == ClientUtils.getClientPlayer() && heldItem.m_41720_() instanceof GunItem) {
                GunClientState state = GunClientState.getState(player, heldItem, this.currentInventorySlot, false);
                if (state != null) {
                    state.jump((LivingEntity)player, heldItem);
                }
                if (this.jumpController != null) {
                    this.jumpController.onJumping((LivingEntity)player, state, heldItem);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack itemStack;
        Player mainPlayer;
        if (event.side == LogicalSide.CLIENT && event.player != (mainPlayer = ClientUtils.getClientPlayer())) {
            ItemStack itemStack2 = event.player.m_21205_();
            GunClientState state = GunClientState.getMainHeldState(event.player);
            if (state != null) {
                state.stateTick((LivingEntity)event.player, itemStack2, false);
            }
        }
        if ((itemStack = event.player.m_21205_()) != null && itemStack.m_41720_() instanceof GunItem) {
            GunClientState state;
            if (GunItem.isAiming(itemStack)) {
                event.player.m_6858_(false);
            }
            if (MiscUtil.isClientSide((Entity)event.player) && (state = GunClientState.getMainHeldState(event.player)) != null && !state.isIdle() && !state.isDrawing()) {
                event.player.m_6858_(false);
            }
        }
    }

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.Pre event) {
        ClientTooltipComponent component;
        ItemStack itemStack = event.getItemStack();
        if (!(itemStack.m_41720_() instanceof AttachmentHost)) {
            return;
        }
        event.setCanceled(true);
        Minecraft mc = Minecraft.m_91087_();
        GuiGraphics guiGraphics = event.getGraphics();
        List tooltipComponents = event.getComponents();
        int i = 0;
        int j = tooltipComponents.size() == 1 ? -2 : 0;
        for (ClientTooltipComponent clienttooltipcomponent : tooltipComponents) {
            int k = clienttooltipcomponent.m_142069_(event.getFont());
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.m_142103_();
        }
        int i2 = i;
        int j2 = j;
        Vector2ic vector2ic = event.getTooltipPositioner().m_262814_(guiGraphics.m_280182_(), guiGraphics.m_280206_(), event.getX(), event.getY(), i2, j2);
        int l = vector2ic.x();
        int i1 = vector2ic.y();
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        guiGraphics.m_286007_(() -> {
            int background = 0x50101010;
            int borderStart = 1342218495;
            int borderEnd = 0x50005077;
            if (!(mc.f_91080_ instanceof AttachmentManagerScreen)) {
                background = -267382768;
            }
            TooltipRenderUtil.renderTooltipBackground((GuiGraphics)guiGraphics, (int)l, (int)i1, (int)i2, (int)j2, (int)400, (int)background, (int)background, (int)borderStart, (int)borderEnd);
        });
        poseStack.m_252880_(0.0f, 0.0f, 400.0f);
        int k1 = i1;
        for (int l1 = 0; l1 < tooltipComponents.size(); ++l1) {
            component = (ClientTooltipComponent)tooltipComponents.get(l1);
            component.m_142440_(event.getFont(), l, k1, poseStack.m_85850_().m_252922_(), guiGraphics.m_280091_());
            k1 += component.m_142103_() + (l1 == 0 ? 2 : 0);
        }
        k1 = i1;
        for (int k2 = 0; k2 < tooltipComponents.size(); ++k2) {
            component = (ClientTooltipComponent)tooltipComponents.get(k2);
            component.m_183452_(event.getFont(), l, k1, guiGraphics);
            k1 += component.m_142103_() + (k2 == 0 ? 2 : 0);
        }
        poseStack.m_85849_();
    }

    @SubscribeEvent
    public void onGatherTooltipComponents(RenderTooltipEvent.GatherComponents event) {
        ItemStack itemStack = event.getItemStack();
        Item item = itemStack.m_41720_();
        if (item instanceof FeatureProvider) {
            AttachmentHost attachmentHost;
            Collection<Attachment> collection;
            FeatureProvider featureProvider = (FeatureProvider)item;
            List elements = event.getTooltipElements();
            ArrayList<Object> components = new ArrayList<Object>();
            components.addAll(featureProvider.getDescriptionTooltipLines());
            components.addAll(featureProvider.getFeatureTooltipLines());
            if (item instanceof AttachmentHost && !(collection = (attachmentHost = (AttachmentHost)item).getCompatibleAttachments()).isEmpty()) {
                if (Screen.m_96638_()) {
                    components.addAll(attachmentHost.getCompatibleAttachmentTooltipLines(itemStack));
                } else {
                    components.add(Component.m_237119_());
                    components.add(Component.m_237115_((String)"message.pointblank.holdShiftForCompatibleAttachments").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.DARK_AQUA));
                }
            }
            for (Component component : components) {
                elements.add(Either.left((Object)component));
            }
        }
    }

    private float getCrosshairExpansionRatio(Player player, GunClientState gunClientState) {
        float inaccuracy = 2.0f;
        float baseExpansion = 1.0f;
        float speedMultiplier = 4.0f * inaccuracy;
        float rotationMultiplier = 0.05f * inaccuracy;
        float sprintMultiplier = 1.5f * inaccuracy;
        float jumpMultiplier = 1.2f * inaccuracy;
        float sneakMultiplier = 0.8f;
        float crouchMultiplier = 0.7f;
        float fireMultiplier = 2.0f * inaccuracy;
        double horizontalSpeed = Mth.m_14116_((float)((float)(this.playerDeltaX * this.playerDeltaX + this.playerDeltaY * this.playerDeltaY + this.playerDeltaZ * this.playerDeltaZ)));
        float expansionRatio = baseExpansion + (float)horizontalSpeed * speedMultiplier;
        if (player.m_20142_()) {
            expansionRatio *= sprintMultiplier;
        }
        if (!player.m_20096_()) {
            expansionRatio *= jumpMultiplier;
        }
        if (player.m_20143_()) {
            expansionRatio *= sneakMultiplier;
        }
        if (player.m_6047_()) {
            expansionRatio *= crouchMultiplier;
        }
        float yawChangeRate = Math.abs(this.playerDeltaYRot);
        float pitchChangeRate = Math.abs(this.playerDeltaXRot);
        expansionRatio += yawChangeRate * rotationMultiplier;
        expansionRatio += pitchChangeRate * rotationMultiplier;
        if (gunClientState.getTotalUninterruptedShots() > 0) {
            expansionRatio *= fireMultiplier;
        }
        return Mth.m_14036_((float)this.crossHairExp.update(expansionRatio), (float)1.0f, (float)7.0f);
    }

    static {
        isPipFallbackZoomActive = false;
        gunFov = 0.0;
        postPassEffectController = new PostPassEffectController(2000L);
        crossHairOverlay = new ResourceLocation("pointblank", "textures/gui/crosshair.png");
    }

    @Mod.EventBusSubscriber(modid="pointblank", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusRegistration {
        @SubscribeEvent
        public static void registerKeybindings(RegisterKeyMappingsEvent event) {
            event.register((KeyMapping)RELOAD_KEY.get());
            event.register((KeyMapping)FIRE_MODE_KEY.get());
            event.register((KeyMapping)INSPECT_KEY.get());
            event.register((KeyMapping)ATTACHMENT_KEY.get());
            event.register((KeyMapping)SCOPE_SWITCH_KEY.get());
            event.register((KeyMapping)SETTINGS_KEY.get());
        }

        @SubscribeEvent
        public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.WORKSTATION_BLOCK_ENTITY.get(), context -> new BaseModelBlockRenderer<WorkstationBlockEntity>(BlockModelRegistry.WORKSTATION_BLOCK_MODEL.get()));
            event.registerBlockEntityRenderer((BlockEntityType)BlockEntityRegistry.PRINTER_BLOCK_ENTITY.get(), context -> new BaseModelBlockRenderer<PrinterBlockEntity>(BlockModelRegistry.PRINTER_BLOCK_MODEL.get()));
            for (Map.Entry<RegistryObject<EntityType<?>>, Supplier<EntityBuilder<?, ?>>> e : EntityRegistry.getItemEntityBuilders().entrySet()) {
                Supplier<EntityBuilder<?, ?>> supplier = e.getValue();
                EntityBuilder<?, ?> builder = supplier.get();
                if (!builder.hasRenderer()) continue;
                EntityType entityType = (EntityType)e.getKey().get();
                event.registerEntityRenderer(entityType, context -> builder.createEntityRenderer(context));
            }
        }

        @SubscribeEvent
        public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)ParticleRegistry.IMPACT_PARTICLE.get(), EffectParticles.EffectParticleProvider::new);
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent evt) {
            MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.ATTACHMENTS.get()), AttachmentManagerScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)MenuRegistry.CRAFTING.get()), CraftingScreen::new);
            PlayerAnimatorCompat.getInstance().registerAnimationTypes();
            ThirdPersonAnimationRegistry.init();
        }
    }
}

