/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf.fluid;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.util.mcf.fluid.FluidIngredient;

public record FluidIngredientStack(FluidIngredient fluid, int amount) implements Predicate<FluidStack>
{
    public static final FluidIngredientStack EMPTY = new FluidIngredientStack(FluidIngredient.EMPTY, 0);
    public static final Codec<FluidIngredientStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidIngredient.CODEC.fieldOf("fluid").forGetter(FluidIngredientStack::fluid), (App)Codec.INT.fieldOf("amount").forGetter(FluidIngredientStack::amount)).apply((Applicative)instance, FluidIngredientStack::new));

    public FluidIngredientStack(FluidIngredient fluid, int amount) {
        this.fluid = fluid.resolve();
        this.amount = amount;
    }

    private FluidIngredientStack resolve() {
        return this.isEmpty() ? EMPTY : this;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.amount <= 0 || this.fluid.isEmpty();
    }

    public boolean fluidMatches(FluidStack fluidStack) {
        return this.fluid.test(fluidStack);
    }

    public FluidStack[] getValues() {
        return this.fluid.getValues(this.amount);
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return fluidStack.getAmount() >= this.amount && this.fluidMatches(fluidStack);
    }
}

