/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.tiles.tooltip.own.inf;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.client.utils.RenderUtils;
import org.zeith.hammerlib.tiles.tooltip.EnumNumberFormat;
import org.zeith.hammerlib.tiles.tooltip.ProgressBar;
import org.zeith.hammerlib.tiles.tooltip.own.IRenderableInfo;

public record TooltipInfoProgressBar(ProgressBar bar) implements IRenderableInfo
{
    @Override
    public float getWidth() {
        return 101.0f;
    }

    @Override
    public float getHeight() {
        return 12.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(GuiGraphics gfx, float x, float y, float partialTime) {
        RenderSystem.setShader(GameRenderer::m_172811_);
        PoseStack pose = gfx.m_280168_();
        pose.m_85836_();
        pose.m_252880_(x, y, 0.0f);
        RenderUtils.drawColoredModalRect(gfx, 0.0f, 0.0f, 101.0f, 12.0f, this.bar.borderColor);
        RenderUtils.drawColoredModalRect(gfx, 1.0f, 1.0f, 99.0f, 10.0f, this.bar.backgroundColor);
        int fill = this.bar.getProgressPercent();
        RenderUtils.drawColoredModalRect(gfx, 1.0f, 1.0f, fill, 10.0f, this.bar.filledMainColor);
        for (int j = 0; j < fill; j += 2) {
            RenderUtils.drawColoredModalRect(gfx, 1 + j, 1.0f, 1.0f, 10.0f, this.bar.filledAlternateColor);
        }
        String core = switch (this.bar.numberFormat) {
            case EnumNumberFormat.COMPACT -> Math.round(this.bar.getProgress() * 100.0f) + " ";
            case EnumNumberFormat.NONE -> "";
            default -> Integer.toString(Math.round(this.bar.getProgress() * 100.0f));
        };
        String txt = (this.bar.prefix != null ? this.bar.prefix : "") + core + (this.bar.suffix != null ? this.bar.suffix : "");
        RenderSystem.setShader(GameRenderer::m_172817_);
        gfx.m_280488_(Minecraft.m_91087_().f_91062_, txt, 3, 2, 0xFFFFFF);
        pose.m_85849_();
    }
}

