/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.client.render.TintingVertexConsumer;
import org.zeith.hammerlib.proxy.HLConstants;

public class RenderCustomGlint {
    public static final ResourceLocation ENCHANTED_GLINT_ENTITY = HLConstants.id("textures/misc/enchanted_glint_entity.png");
    public static final ResourceLocation ENCHANTED_GLINT_ITEM = HLConstants.id("textures/misc/enchanted_glint_item.png");
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ARMOR_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getArmorGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getArmorEntityGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_GLINT_TRANSLUCENT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getGlintTranslucentShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_GLINT_DIRECT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getGlintDirectShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getEntityGlintShader);
    protected static final RenderStateShard.ShaderStateShard RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER = new RenderStateShard.ShaderStateShard(GlintShaders::getEntityGlintDirectShader);
    protected static final RenderStateShard.WriteMaskStateShard COLOR_WRITE = new RenderStateShard.WriteMaskStateShard(true, false);
    protected static final RenderStateShard.CullStateShard NO_CULL = new RenderStateShard.CullStateShard(false);
    protected static final RenderStateShard.DepthTestStateShard EQUAL_DEPTH_TEST = new RenderStateShard.DepthTestStateShard("==", 514);
    protected static final RenderStateShard.TransparencyStateShard GLINT_TRANSPARENCY = new RenderStateShard.TransparencyStateShard("glint_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });
    protected static final RenderStateShard.LayeringStateShard VIEW_OFFSET_Z_LAYERING = new RenderStateShard.LayeringStateShard("view_offset_z_layering", () -> {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        posestack.m_85841_(0.99975586f, 0.99975586f, 0.99975586f);
        RenderSystem.applyModelViewMatrix();
    }, () -> {
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    });
    protected static final RenderStateShard.TexturingStateShard GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("glint_texturing", () -> RenderCustomGlint.setupGlintTexturing(8.0f), () -> RenderSystem.resetTextureMatrix());
    protected static final RenderStateShard.TexturingStateShard ENTITY_GLINT_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> RenderCustomGlint.setupGlintTexturing(0.16f), () -> RenderSystem.resetTextureMatrix());
    protected static final RenderStateShard.OutputStateShard ITEM_ENTITY_TARGET = new RenderStateShard.OutputStateShard("item_entity_target", () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().f_91060_.m_109829_().m_83947_(false);
        }
    }, () -> {
        if (Minecraft.m_91085_()) {
            Minecraft.m_91087_().m_91385_().m_83947_(false);
        }
    });
    private static final RenderType ARMOR_GLINT = RenderType.m_173215_((String)"hammerlib:armor_glint", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ARMOR_GLINT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110683_(GLINT_TEXTURING).m_110669_(VIEW_OFFSET_Z_LAYERING).m_110691_(false));
    private static final RenderType ARMOR_ENTITY_GLINT = RenderType.m_173215_((String)"hammerlib:armor_entity_glint", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ARMOR_ENTITY_GLINT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110683_(ENTITY_GLINT_TEXTURING).m_110669_(VIEW_OFFSET_Z_LAYERING).m_110691_(false));
    private static final RenderType GLINT_TRANSLUCENT = RenderType.m_173215_((String)"hammerlib:glint_translucent", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_GLINT_TRANSLUCENT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ITEM, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110683_(GLINT_TEXTURING).m_110675_(ITEM_ENTITY_TARGET).m_110691_(false));
    private static final RenderType GLINT = RenderType.m_173215_((String)"hammerlib:glint", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_GLINT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ITEM, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110683_(GLINT_TEXTURING).m_110691_(false));
    private static final RenderType GLINT_DIRECT = RenderType.m_173215_((String)"hammerlib:glint_direct", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_GLINT_DIRECT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ITEM, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110683_(GLINT_TEXTURING).m_110691_(false));
    private static final RenderType ENTITY_GLINT = RenderType.m_173215_((String)"hammerlib:entity_glint", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ENTITY_GLINT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110675_(ITEM_ENTITY_TARGET).m_110683_(ENTITY_GLINT_TEXTURING).m_110691_(false));
    private static final RenderType ENTITY_GLINT_DIRECT = RenderType.m_173215_((String)"hammerlib:entity_glint_direct", (VertexFormat)DefaultVertexFormat.f_85818_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ENCHANTED_GLINT_ENTITY, true, false)).m_110687_(COLOR_WRITE).m_110661_(NO_CULL).m_110663_(EQUAL_DEPTH_TEST).m_110685_(GLINT_TRANSPARENCY).m_110683_(ENTITY_GLINT_TEXTURING).m_110691_(false));

    private static void setupGlintTexturing(float pScale) {
        long i = (long)((double)Util.m_137550_() * (Double)Minecraft.m_91087_().f_91066_.m_267805_().m_231551_() * 8.0);
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(-f, f1, 0.0f);
        matrix4f.rotateZ(0.17453292f).scale(pScale);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    public static VertexConsumer glintBuffer(MultiBufferSource src, GlintType type, float r, float g, float b, float a) {
        return new TintingVertexConsumer(src.m_6299_(type.type), r, g, b, a);
    }

    public static VertexConsumer glintBuffer(MultiBufferSource src, GlintType type, int rgba) {
        return new TintingVertexConsumer(src.m_6299_(type.type), rgba);
    }

    public static RenderType armorGlint() {
        return ARMOR_GLINT;
    }

    public static RenderType armorEntityGlint() {
        return ARMOR_ENTITY_GLINT;
    }

    public static RenderType glintTranslucent() {
        return GLINT_TRANSLUCENT;
    }

    public static RenderType glint() {
        return GLINT;
    }

    public static RenderType glintDirect() {
        return GLINT_DIRECT;
    }

    public static RenderType entityGlint() {
        return ENTITY_GLINT;
    }

    public static RenderType entityGlintDirect() {
        return ENTITY_GLINT_DIRECT;
    }

    public static enum GlintType {
        ARMOR_GLINT(ARMOR_GLINT),
        ARMOR_ENTITY_GLINT(ARMOR_ENTITY_GLINT),
        GLINT_TRANSLUCENT(GLINT_TRANSLUCENT),
        GLINT(GLINT),
        GLINT_DIRECT(GLINT_DIRECT),
        ENTITY_GLINT(ENTITY_GLINT),
        ENTITY_GLINT_DIRECT(ENTITY_GLINT_DIRECT);

        final RenderType type;

        private GlintType(RenderType type) {
            this.type = type;
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class GlintShaders {
        private static ShaderInstance armorGlintShader;
        private static ShaderInstance armorEntityGlintShader;
        private static ShaderInstance glintTranslucentShader;
        private static ShaderInstance glintShader;
        private static ShaderInstance glintDirectShader;
        private static ShaderInstance entityGlintShader;
        private static ShaderInstance entityGlintDirectShader;

        @SubscribeEvent
        public static void registerShaders(RegisterShadersEvent e) {
            ResourceProvider pResourceProvider = e.getResourceProvider();
            try {
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_armor_glint").toString(), DefaultVertexFormat.f_85818_), s -> {
                    armorGlintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_armor_entity_glint").toString(), DefaultVertexFormat.f_85818_), s -> {
                    armorEntityGlintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_glint_translucent").toString(), DefaultVertexFormat.f_85818_), s -> {
                    glintTranslucentShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_glint").toString(), DefaultVertexFormat.f_85818_), s -> {
                    glintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_glint_direct").toString(), DefaultVertexFormat.f_85818_), s -> {
                    glintDirectShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_entity_glint").toString(), DefaultVertexFormat.f_85818_), s -> {
                    entityGlintShader = s;
                });
                e.registerShader(new ShaderInstance(pResourceProvider, HLConstants.id("rendertype_entity_glint_direct").toString(), DefaultVertexFormat.f_85818_), s -> {
                    entityGlintDirectShader = s;
                });
                HammerLib.LOG.info("Reloaded glint shaders.");
            }
            catch (IOException err) {
                HammerLib.LOG.error("Failed to reload shaders.", (Throwable)err);
            }
        }

        @Nullable
        public static ShaderInstance getArmorGlintShader() {
            return armorGlintShader;
        }

        @Nullable
        public static ShaderInstance getArmorEntityGlintShader() {
            return armorEntityGlintShader;
        }

        @Nullable
        public static ShaderInstance getGlintTranslucentShader() {
            return glintTranslucentShader;
        }

        @Nullable
        public static ShaderInstance getGlintShader() {
            return glintShader;
        }

        @Nullable
        public static ShaderInstance getGlintDirectShader() {
            return glintDirectShader;
        }

        @Nullable
        public static ShaderInstance getEntityGlintShader() {
            return entityGlintShader;
        }

        @Nullable
        public static ShaderInstance getEntityGlintDirectShader() {
            return entityGlintDirectShader;
        }
    }
}

