/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui.readers;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.abstractions.props.KeyMap;
import org.zeith.hammerlib.annotations.ide.AllowJS;
import org.zeith.hammerlib.annotations.ide.AllowedValues;
import org.zeith.hammerlib.annotations.ide.Default;
import org.zeith.hammerlib.annotations.ide.Namespace;
import org.zeith.hammerlib.annotations.ide.Required;
import org.zeith.hammerlib.annotations.ide.Suggestions;
import org.zeith.hammerlib.api.data.IDataNode;
import org.zeith.hammerlib.client.flowgui.objects.GuiTextObject;
import org.zeith.hammerlib.client.flowgui.reader.ComDrivers;
import org.zeith.hammerlib.client.flowgui.reader.DriverContext;
import org.zeith.hammerlib.client.flowgui.reader.FlowguiReader;
import org.zeith.hammerlib.client.flowgui.reader.GuiReader;
import org.zeith.hammerlib.util.java.OptionalBoolean;
import org.zeith.hammerlib.util.java.Suppliers2;
import org.zeith.hammerlib.util.mcf.Resources;

@Namespace(value="hammerlib")
@FlowguiReader(value="label")
public class FlowguiLabelReader
extends GuiReader<GuiTextObject> {
    @AllowJS
    @Required(value="{\"translate\":\"block.minecraft.stone\"}")
    public static final String KEY_VALUE = "value";
    @AllowJS
    @Default(value="#FFFFFF")
    public static final String KEY_COLOR = "color";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="true")
    public static final String KEY_SHADOW = "shadow";
    @AllowJS
    @AllowedValues(value={"^([a-z0-9_.-]+:[a-z0-9_./-]+)|([a-z0-9_./-]+)$"})
    @Default(value="minecraft:default")
    public static final String KEY_FONT = "font";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_BOLD = "bold";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_ITALIC = "italic";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_UNDERLINED = "underlined";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_STRIKETHROUGH = "strikethrough";
    @AllowJS
    @Suggestions(value={"true", "false"})
    @AllowedValues(value={"^true|false$"})
    @Default(value="false")
    public static final String KEY_OBFUSCATED = "obfuscated";

    @Override
    protected GuiTextObject readObject(KeyMap map, String name, IDataNode node) {
        GuiTextObject self = new GuiTextObject(name, Minecraft.m_91087_().f_91062_, Component.m_237119_().m_7532_(), -1, true);
        DriverContext ctx = this.getDriverContext(map, node, self);
        Supplier<OptionalBoolean> bold = ComDrivers.readBoolean(ctx, KEY_BOLD);
        Supplier<OptionalBoolean> italic = ComDrivers.readBoolean(ctx, KEY_ITALIC);
        Supplier<OptionalBoolean> underlined = ComDrivers.readBoolean(ctx, KEY_UNDERLINED);
        Supplier<OptionalBoolean> strikethrough = ComDrivers.readBoolean(ctx, KEY_STRIKETHROUGH);
        Supplier<OptionalBoolean> obfuscated = ComDrivers.readBoolean(ctx, KEY_OBFUSCATED);
        Supplier<ResourceLocation> font = Suppliers2.map(ComDrivers.readString(ctx, KEY_FONT), s -> s.isBlank() ? null : Resources.locationOrNull(s));
        ComDrivers.driveColor(ctx, KEY_COLOR, -1, false, self::setColor);
        ComDrivers.driveBool(ctx, KEY_SHADOW, true, false, self::setShadow);
        ComDrivers.driveComponent(ctx, KEY_VALUE, (Component)Component.m_237119_(), false, comp -> self.setText((Component)comp.m_6881_().m_130938_(arg_0 -> FlowguiLabelReader.lambda$readObject$1((Supplier)bold, (Supplier)italic, (Supplier)underlined, (Supplier)strikethrough, (Supplier)obfuscated, (Supplier)font, arg_0))));
        return self;
    }

    private static /* synthetic */ Style lambda$readObject$1(Supplier bold, Supplier italic, Supplier underlined, Supplier strikethrough, Supplier obfuscated, Supplier font, Style st) {
        ResourceLocation f;
        OptionalBoolean b = (OptionalBoolean)((Object)bold.get());
        if (b != null && b.isPresent()) {
            st = st.m_131136_(Boolean.valueOf(b.orElse(false)));
        }
        if ((b = (OptionalBoolean)((Object)italic.get())) != null && b.isPresent()) {
            st = st.m_131155_(Boolean.valueOf(b.orElse(false)));
        }
        if ((b = (OptionalBoolean)((Object)underlined.get())) != null && b.isPresent()) {
            st = st.m_131162_(Boolean.valueOf(b.orElse(false)));
        }
        if ((b = (OptionalBoolean)((Object)strikethrough.get())) != null && b.isPresent()) {
            st = st.m_178522_(Boolean.valueOf(b.orElse(false)));
        }
        if ((b = (OptionalBoolean)((Object)obfuscated.get())) != null && b.isPresent()) {
            st = st.m_178524_(Boolean.valueOf(b.orElse(false)));
        }
        if ((f = (ResourceLocation)font.get()) != null) {
            st = st.m_131150_(f);
        }
        return st;
    }
}

