/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.client.flowgui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeith.hammerlib.client.flowgui.Graphics;
import org.zeith.hammerlib.client.flowgui.GuiObjectBuilder;
import org.zeith.hammerlib.client.flowgui.MousePos;
import org.zeith.hammerlib.client.flowgui.objects.GuiRootObject;
import org.zeith.hammerlib.client.flowgui.objects.GuiTooltipObject;
import org.zeith.hammerlib.client.flowgui.objects.RenderHook;
import org.zeith.hammerlib.client.flowgui.util.ScrollData;
import org.zeith.hammerlib.client.flowgui.util.Tooltip;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;
import org.zeith.hammerlib.util.math.Point;

public class GuiObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GuiObject.class);
    public static final int SIMULATED_MOUSE_BUTTON = -25902376;
    private static final Vec3 ONE = new Vec3(1.0, 1.0, 1.0);
    private GuiObject parent;
    private final List<GuiObject> children = new ArrayList<GuiObject>();
    private final List<GuiObject> childrenView = Collections.unmodifiableList(this.children);
    private final Map<String, GuiObject> byName = new HashMap<String, GuiObject>();
    private final String originalName;
    private String name;
    private final String simpleName = this.getClass().getSimpleName();
    protected RenderHook preRenderHandler = RenderHook.list();
    protected RenderHook postRenderHandler = RenderHook.list();
    protected boolean enabled = true;
    protected boolean visible = true;
    protected float zOffset;
    protected Point pos = Point.ZERO;
    protected Point pivot = Point.ZERO;
    protected Vec3 scale = ONE;
    protected float width;
    protected float height;
    protected float rotation;
    public final List<Runnable> finishBuilding = new ArrayList<Runnable>(0);
    public final DirectStorage<Point> elementPosition = DirectStorage.create(p -> this.pos(p.x(), p.y()), () -> this.pos);
    public final DirectStorage<Float> elementZPos = DirectStorage.create(this::zOffset, () -> Float.valueOf(this.zOffset));
    public final DirectStorage<Point> elementPivot = DirectStorage.create(p -> this.pivot(p.x(), p.y()), () -> this.pivot);
    public final DirectStorage<Vec3> elementScale = DirectStorage.create(p -> {
        this.scale = p;
    }, () -> this.scale);
    public final DirectStorage<Float> elementRotation = DirectStorage.create(this::rotation, () -> Float.valueOf(this.rotation));
    public final DirectStorage<Float> elementWidth = DirectStorage.create(p -> {
        this.width = p.floatValue();
    }, () -> Float.valueOf(this.width));
    public final DirectStorage<Float> elementHeight = DirectStorage.create(p -> {
        this.height = p.floatValue();
    }, () -> Float.valueOf(this.height));
    private String myPathCache;

    public GuiObject(String name) {
        if (name.contains("/")) {
            throw new IllegalArgumentException("GuiObject's path can not have '/' character.");
        }
        this.originalName = this.name = name;
    }

    public GuiObject addTooltip(Supplier<Tooltip> tooltipSupplier) {
        this.addChild(new GuiTooltipObject("$tooltip").tooltip(tooltipSupplier));
        return this;
    }

    public GuiObject addTooltip(Tooltip tooltip) {
        this.addChild(new GuiTooltipObject("$tooltip").tooltip(tooltip));
        return this;
    }

    public GuiObject onPreRender(RenderHook task) {
        this.preRenderHandler = this.preRenderHandler.andThen(task);
        return this;
    }

    public GuiObject onPostRender(RenderHook task) {
        this.postRenderHandler = this.postRenderHandler.andThen(task);
        return this;
    }

    public void visitObjects(Consumer<GuiObject> pConsumer) {
        pConsumer.accept(this);
        this.children.forEach(o -> o.visitObjects(pConsumer));
    }

    @Nullable
    public <T extends GuiObject> T findByName(String path, Class<T> expectType) {
        ArrayList<GuiObject> allChildren = new ArrayList<GuiObject>();
        allChildren.add(this);
        for (int i = 0; i < allChildren.size(); ++i) {
            GuiObject c = (GuiObject)allChildren.get(i);
            if (c.getName().equals(path) && expectType.isInstance(c)) {
                return (T)((GuiObject)expectType.cast(c));
            }
            for (GuiObject c2 : c.getChildren()) {
                allChildren.add(c2);
            }
        }
        return null;
    }

    @Nullable
    public <T extends GuiObject> T findByNameIgnoreCase(String path, Class<T> expectType) {
        return (T)((GuiObject)Cast.cast(this.findByNameIgnoreCase(path), expectType));
    }

    @Nullable
    public <T extends GuiObject> T findByPath(String path, Class<T> expectType) {
        return (T)((GuiObject)Cast.cast(this.findByPath(path), expectType));
    }

    @Nullable
    public GuiObject findByName(String path) {
        ArrayList<GuiObject> allChildren = new ArrayList<GuiObject>();
        allChildren.add(this);
        for (int i = 0; i < allChildren.size(); ++i) {
            GuiObject c = (GuiObject)allChildren.get(i);
            if (c.getName().equals(path)) {
                return c;
            }
            for (GuiObject c2 : c.getChildren()) {
                allChildren.add(c2);
            }
        }
        return null;
    }

    @Nullable
    public GuiObject findByNameIgnoreCase(String path) {
        ArrayList<GuiObject> allChildren = new ArrayList<GuiObject>();
        allChildren.add(this);
        for (int i = 0; i < allChildren.size(); ++i) {
            GuiObject c = (GuiObject)allChildren.get(i);
            if (c.getName().equalsIgnoreCase(path)) {
                return c;
            }
            for (GuiObject c2 : c.getChildren()) {
                allChildren.add(c2);
            }
        }
        return null;
    }

    @Nullable
    public GuiObject findByPath(String path) {
        int nextSlash;
        if (path.isBlank()) {
            return this;
        }
        if (path.startsWith("$root")) {
            path = path.substring(5);
            GuiObject o = this;
            while (o != null) {
                if (o instanceof GuiRootObject) {
                    GuiRootObject root = (GuiRootObject)o;
                    if (o.parent == null) {
                        if (path.equals("/")) {
                            return root;
                        }
                        return root.findByPath(path.substring(1));
                    }
                }
                o = o.parent;
            }
        }
        if ((nextSlash = path.indexOf(47)) < 0) {
            return this.byName.get(path);
        }
        String name = path.substring(0, nextSlash);
        GuiObject o = this.byName.get(name);
        return o != null ? o.findByPath(path.substring(nextSlash + 1)) : null;
    }

    @Nullable
    public String getMyPath() {
        if (this.myPathCache != null) {
            return this.myPathCache;
        }
        ArrayList<String> names = new ArrayList<String>();
        GuiObject o = this;
        while (o != null) {
            names.add(0, o.getName());
            o = o.parent;
        }
        this.myPathCache = String.join((CharSequence)"/", names);
        return this.myPathCache;
    }

    public final Iterable<GuiObject> getChildren() {
        return this.childrenView;
    }

    public GuiObject getChild(String name) {
        return this.byName.get(name);
    }

    public final GuiObject addChild(GuiObject child) {
        if (child == this) {
            log.warn("Attempted to add {} into itself.", (Object)this);
            return this;
        }
        if (GuiObject.anyMatchesWithinTree(this, o -> o == child)) {
            log.warn("Attempted to add {} into {} but it is already in the vertical hierarchy.", (Object)child, (Object)this);
            return this;
        }
        child.remove();
        child.parent = this;
        this.children.add(child);
        this.onChildAdded(child);
        child.onAddedInto(this);
        if (this.byName.containsKey(child.getName())) {
            String pv = child.toString();
            child.setName(child.originalName);
            child.myPathCache = null;
            log.warn("Attempted to add {} into {} but the name is already bound. Renaming to {}.", new Object[]{pv, this, child.getName()});
            return this;
        }
        this.byName.put(child.getName(), child);
        this.myPathCache = null;
        child.myPathCache = null;
        return this;
    }

    public final GuiObject removeChild(String name) {
        GuiObject go = this.byName.remove(name);
        if (go == null) {
            return null;
        }
        this.children.remove(go);
        go.parent = null;
        go.name = go.originalName;
        go.onRemovedFrom(this);
        this.onChildRemoved(go);
        return go;
    }

    public final void remove() {
        if (this.parent != null) {
            this.parent.removeChild(this.getName());
            this.myPathCache = null;
        }
    }

    public List<Rect2i> getUnpositionedBounds() {
        int width = this.elementWidth.get().intValue();
        int height = this.elementHeight.get().intValue();
        return List.of(new Rect2i(0, 0, width, height));
    }

    protected void onAddedInto(GuiObject parent) {
    }

    protected void onRemovedFrom(GuiObject parent) {
    }

    protected void onChildAdded(GuiObject child) {
    }

    protected void onChildRemoved(GuiObject child) {
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (this.parent != null) {
            int j = 0;
            Object on = name;
            while (this.parent.byName.containsKey(on)) {
                on = name + " (" + ++j + ")";
            }
            name = on;
            this.parent.byName.put(name, this);
            if (this.parent.byName.get(this.name) == this) {
                this.parent.byName.remove(this.name);
            }
        }
        this.name = name;
    }

    public GuiObject setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GuiObject setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiObject centered(float width, float height) {
        this.pos((width - this.width) / 2.0f, (height - this.height) / 2.0f);
        return this;
    }

    public GuiObject centered(int width, int height) {
        this.pos((int)(((float)width - this.width) / 2.0f), (int)(((float)height - this.height) / 2.0f));
        return this;
    }

    public GuiObject centeredX(float width) {
        this.pos((width - this.width) / 2.0f, this.pos.y());
        return this;
    }

    public GuiObject centeredX(int width) {
        this.pos((int)(((float)width - this.width) / 2.0f), this.pos.y());
        return this;
    }

    public GuiObject centeredY(float height) {
        this.pos(this.pos.x(), (height - this.height) / 2.0f);
        return this;
    }

    public GuiObject centeredY(int height) {
        this.pos(this.pos.x(), (int)(((float)height - this.height) / 2.0f));
        return this;
    }

    public GuiObject pos(float x, float y) {
        this.pos = new Point(x, y);
        return this;
    }

    public GuiObject zOffset(float zOffset) {
        this.zOffset = zOffset;
        return this;
    }

    public GuiObject offset(float x, float y) {
        this.pos = this.pos.offset(x, y);
        return this;
    }

    public GuiObject size(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public GuiObject pivot(float x, float y) {
        this.pivot = new Point(x, y);
        return this;
    }

    public GuiObject pivotAtCenter() {
        return this.pivot(this.getUnscaledWidth() / 2.0f, this.getUnscaledHeight() / 2.0f);
    }

    public GuiObject rotation(float rotation) {
        this.rotation = rotation;
        return this;
    }

    public float getUnscaledWidth() {
        return this.width;
    }

    public float getUnscaledHeight() {
        return this.height;
    }

    public float getScaledWidth() {
        return (float)((double)this.getUnscaledWidth() * this.scale.f_82479_);
    }

    public float getScaledHeight() {
        return (float)((double)this.getUnscaledHeight() * this.scale.f_82480_);
    }

    public GuiObject usePos(Consumer<DirectStorage<Point>> handler) {
        handler.accept(this.elementPosition);
        return this;
    }

    public GuiObject usePivot(Consumer<DirectStorage<Point>> handler) {
        handler.accept(this.elementPivot);
        return this;
    }

    public GuiObject useScale(Consumer<DirectStorage<Vec3>> handler) {
        handler.accept(this.elementScale);
        return this;
    }

    public GuiObject useRotation(Consumer<DirectStorage<Float>> handler) {
        handler.accept(this.elementRotation);
        return this;
    }

    protected void update() {
    }

    protected void render(Graphics gfx, MousePos pos) {
    }

    protected boolean onMouseClicked(Point globalMousePos, MousePos pos, int button, boolean fake) {
        return false;
    }

    protected boolean onMouseDragged(Point globalMousePos, MousePos pos, int button, MousePos dragPos) {
        return false;
    }

    protected boolean onMouseReleased(Point globalMousePos, MousePos pos, int button) {
        return false;
    }

    protected boolean onMouseScrolled(Point globalMousePos, MousePos pos, ScrollData delta) {
        return false;
    }

    protected void onMouseMoved(Point globalMousePos, MousePos pos) {
    }

    protected boolean onKeyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean onKeyReleased(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    protected boolean onCharTyped(char codePoint, int modifiers) {
        return false;
    }

    public final void sendUpdate() {
        if (!this.enabled) {
            return;
        }
        if (this.visible) {
            this.update();
        }
        for (GuiObject child : this.children) {
            child.sendUpdate();
        }
    }

    public final <T> void runForTree(PoseStack pose, Class<T> filter, BiConsumer<T, PoseStack> handler) {
        this.runForTree(pose, (obj, ps) -> {
            Object t = Cast.cast(obj, filter);
            if (t != null) {
                handler.accept(t, (PoseStack)ps);
            }
        });
    }

    public final <T, R> Optional<R> findInTree(PoseStack pose, Class<T> filter, BiFunction<T, PoseStack, Optional<R>> handler) {
        return this.findInTree(pose, (obj, ps) -> {
            Object t = Cast.cast(obj, filter);
            if (t != null) {
                return (Optional)handler.apply(t, (PoseStack)ps);
            }
            return Optional.empty();
        });
    }

    public final void runForTree(PoseStack pose, BiConsumer<GuiObject, PoseStack> handler) {
        if (!this.enabled) {
            return;
        }
        pose.m_85836_();
        this.transform(pose);
        if (this.visible) {
            handler.accept(this, pose);
        }
        for (GuiObject child : this.children) {
            child.runForTree(pose, handler);
        }
        pose.m_85849_();
    }

    public final <R> Optional<R> findInTree(PoseStack pose, BiFunction<GuiObject, PoseStack, Optional<R>> handler) {
        Optional<R> o;
        if (!this.enabled) {
            return Optional.empty();
        }
        pose.m_85836_();
        this.transform(pose);
        if (this.visible && (o = handler.apply(this, pose)).isPresent()) {
            pose.m_85849_();
            return o;
        }
        for (GuiObject child : this.children) {
            Optional<R> o2 = child.findInTree(pose, handler);
            if (!o2.isPresent()) continue;
            pose.m_85849_();
            return o2;
        }
        pose.m_85849_();
        return Optional.empty();
    }

    public final void renderObject(Graphics g, Point globalMousePos) {
        if (!this.enabled) {
            return;
        }
        PoseStack ps = g.gfx().m_280168_();
        ps.m_85836_();
        this.transform(ps);
        Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
        MousePos mouse = new MousePos(globalMousePos, v.x, v.y);
        if (this.visible) {
            this.preRenderHandler.hook(g.partialTime(), mouse);
            this.render(g, mouse);
        }
        this.renderChildren(g, globalMousePos);
        this.postRenderHandler.hook(g.partialTime(), mouse);
        ps.m_85849_();
    }

    public boolean isFakeMouseButton(int button) {
        return -25902376 == button;
    }

    public final boolean sendMouseClick(PoseStack ps, Point globalMousePos, int button) {
        if (!this.enabled) {
            return false;
        }
        ps.m_85836_();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            if (this.onMouseClicked(globalMousePos, new MousePos(globalMousePos, v.x, v.y), button, this.isFakeMouseButton(button))) {
                return true;
            }
        }
        if (this.sendMouseClickToChildren(ps, globalMousePos, button)) {
            return true;
        }
        ps.m_85849_();
        return false;
    }

    protected boolean sendMouseClickToChildren(PoseStack ps, Point globalMousePos, int button) {
        for (GuiObject child : this.children) {
            if (!child.sendMouseClick(ps, globalMousePos, button)) continue;
            return true;
        }
        return false;
    }

    public final boolean sendMouseDrag(PoseStack ps, Point globalMousePos, int button, Point globalDragPos) {
        if (!this.enabled) {
            return false;
        }
        ps.m_85836_();
        this.transform(ps);
        if (this.visible) {
            Matrix4f ivm = GuiObject.untransform(ps);
            Vector3f v = ivm.transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            Vector3f d = ivm.transformPosition(globalDragPos.x(), globalDragPos.y(), 0.0f, new Vector3f());
            if (this.onMouseDragged(globalMousePos, new MousePos(globalMousePos, v.x, v.y), button, new MousePos(globalDragPos, d.x, d.y))) {
                return true;
            }
        }
        if (this.sendMouseDragToChildren(ps, globalMousePos, button, globalDragPos)) {
            return true;
        }
        ps.m_85849_();
        return false;
    }

    public final boolean sendMouseRelease(PoseStack ps, Point globalMousePos, int button) {
        if (!this.enabled) {
            return false;
        }
        ps.m_85836_();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            if (this.onMouseReleased(globalMousePos, new MousePos(globalMousePos, v.x, v.y), button)) {
                return true;
            }
        }
        if (this.sendMouseReleaseToChildren(ps, globalMousePos, button)) {
            return true;
        }
        ps.m_85849_();
        return false;
    }

    public final boolean sendMouseScroll(PoseStack ps, Point globalMousePos, ScrollData delta) {
        if (!this.enabled) {
            return false;
        }
        ps.m_85836_();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            if (this.onMouseScrolled(globalMousePos, new MousePos(globalMousePos, v.x, v.y), delta)) {
                return true;
            }
        }
        if (this.sendMouseScrollToChildren(ps, globalMousePos, delta)) {
            return true;
        }
        ps.m_85849_();
        return false;
    }

    public final void sendMouseMove(PoseStack ps, Point globalMousePos) {
        if (!this.enabled) {
            return;
        }
        ps.m_85836_();
        this.transform(ps);
        if (this.visible) {
            Vector3f v = GuiObject.untransform(ps).transformPosition(globalMousePos.x(), globalMousePos.y(), 0.0f, new Vector3f());
            this.onMouseMoved(globalMousePos, new MousePos(globalMousePos, v.x, v.y));
        }
        this.sendMouseMoveToChildren(ps, globalMousePos);
        ps.m_85849_();
    }

    public final boolean sendKeyPress(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (this.visible && this.onKeyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.sendKeyPressToChildren(keyCode, scanCode, modifiers);
    }

    public final boolean sendKeyRelease(int keyCode, int scanCode, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (this.visible && this.onKeyReleased(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.sendKeyReleaseToChildren(keyCode, scanCode, modifiers);
    }

    public final boolean sendCharType(char codePoint, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (this.visible && this.onCharTyped(codePoint, modifiers)) {
            return true;
        }
        return this.sendCharTypeToChildren(codePoint, modifiers);
    }

    protected void renderChildren(Graphics g, Point globalMousePos) {
        for (GuiObject child : this.children) {
            child.renderObject(g, globalMousePos);
        }
    }

    protected boolean sendMouseDragToChildren(PoseStack ps, Point globalMousePos, int button, Point globalDragPos) {
        for (GuiObject child : this.children) {
            if (!child.sendMouseDrag(ps, globalMousePos, button, globalDragPos)) continue;
            return true;
        }
        return false;
    }

    protected boolean sendMouseReleaseToChildren(PoseStack ps, Point globalMousePos, int button) {
        for (GuiObject child : this.children) {
            if (!child.sendMouseRelease(ps, globalMousePos, button)) continue;
            return true;
        }
        return false;
    }

    protected boolean sendMouseScrollToChildren(PoseStack ps, Point globalMousePos, ScrollData delta) {
        for (GuiObject child : this.children) {
            if (!child.sendMouseScroll(ps, globalMousePos, delta)) continue;
            return true;
        }
        return false;
    }

    protected void sendMouseMoveToChildren(PoseStack ps, Point globalMousePos) {
        for (GuiObject child : this.children) {
            child.sendMouseMove(ps, globalMousePos);
        }
    }

    protected boolean sendKeyPressToChildren(int keyCode, int scanCode, int modifiers) {
        for (GuiObject child : this.children) {
            if (!child.sendKeyPress(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    protected boolean sendKeyReleaseToChildren(int keyCode, int scanCode, int modifiers) {
        for (GuiObject child : this.children) {
            if (!child.sendKeyRelease(keyCode, scanCode, modifiers)) continue;
            return true;
        }
        return false;
    }

    protected boolean sendCharTypeToChildren(char codePoint, int modifiers) {
        for (GuiObject child : this.children) {
            if (!child.sendCharType(codePoint, modifiers)) continue;
            return true;
        }
        return false;
    }

    public void transform(PoseStack ps) {
        ps.m_252880_(this.pos.x(), this.pos.y(), this.zOffset);
        if (this.scale != ONE) {
            ps.m_85841_((float)this.scale.f_82479_, (float)this.scale.f_82480_, (float)this.scale.f_82481_);
        }
        ps.m_252880_(this.pivot.x(), this.pivot.y(), 0.0f);
        ps.m_252781_(Axis.f_252403_.m_252977_(this.rotation));
        ps.m_252880_(-this.pivot.x(), -this.pivot.y(), 0.0f);
    }

    public String toString() {
        return this.simpleName + "{" + this.getName() + "}";
    }

    public static GuiRootObject root() {
        return new GuiRootObject();
    }

    public static GuiObjectBuilder create(String s) {
        return GuiObjectBuilder.named(s);
    }

    public static Matrix4f untransform(PoseStack pose) {
        return pose.m_85850_().m_252922_().invert(new Matrix4f());
    }

    protected static boolean anyMatchesWithinTree(GuiObject root, Predicate<GuiObject> obj) {
        for (GuiObject child : root.children) {
            if (!GuiObject.anyMatchesWithinTree(child, obj)) continue;
            return true;
        }
        while (root != null) {
            if (obj.test(root)) {
                return true;
            }
            root = root.parent;
        }
        return false;
    }

    public GuiObject scale(float scale) {
        this.scale = this.scale.m_82490_((double)scale);
        return this;
    }

    public GuiObject scale(float x, float y) {
        return this.scale(x, y, x);
    }

    public GuiObject scale(float x, float y, float z) {
        this.scale = this.scale.m_82542_((double)x, (double)y, (double)z);
        return this;
    }

    protected void drawTooltip(Graphics gfx, MousePos mouse, Font font, Tooltip tooltip) {
        PoseStack ps = gfx.pose();
        ps.m_85836_();
        ps.m_252931_(new Matrix4f((Matrix4fc)ps.m_85850_().m_252922_()).invert());
        Point gp = mouse.globalPos();
        float x = gp.x();
        float y = gp.y();
        ps.m_252880_(x % 1.0f, y % 1.0f, 0.0f);
        tooltip.render(gfx, font, (int)x, (int)y);
        ps.m_85849_();
    }

    @Generated
    public GuiObject getParent() {
        return this.parent;
    }
}

