/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.littletractor;

import com.dragn0007.littletractor.LittleTractorMain;
import net.minecraft.client.model.geom.ModelPart;

public final class Animation {
    public final KeyFrame[] keyFrames;
    public final float length;

    public Animation(float length, KeyFrame[] keyFrames) {
        this.length = length * 20.0f;
        this.keyFrames = keyFrames;
    }

    public static void animate(ModelPart modelPart, Animation animation, float tick, float partialTick, float speed) {
        int i;
        float t = LittleTractorMain.mod((tick + partialTick) * speed, animation.length);
        for (i = 0; i < animation.keyFrames.length && !(t < animation.keyFrames[i].time); ++i) {
        }
        int idx1 = (int)LittleTractorMain.mod(i - 1, animation.keyFrames.length);
        int idx2 = i % animation.keyFrames.length;
        KeyFrame k1 = animation.keyFrames[Math.min(idx1, idx2)];
        KeyFrame k2 = animation.keyFrames[Math.max(idx1, idx2)];
        float f = (t - k1.time) / (k2.time - k1.time);
        modelPart.f_104203_ = k1.rot.x + (k2.rot.x - k1.rot.x) * f;
        modelPart.f_104204_ = k1.rot.y + (k2.rot.y - k1.rot.y) * f;
        modelPart.f_104205_ = k1.rot.z + (k2.rot.z - k1.rot.z) * f;
    }

    static class KeyFrame {
        public final float time;
        public final Vec3f rot;

        KeyFrame(float time, float x, float y, float z) {
            this.time = time * 20.0f;
            this.rot = new Vec3f(x * (float)Math.PI / 180.0f, y * (float)Math.PI / 180.0f, z * (float)Math.PI / 180.0f);
        }
    }

    public record Vec3f(float x, float y, float z) {
    }
}

